﻿
# Building a bootable image for a Victor 9000 / Sirius 1 / Victor Vicki machine
  
Included in the disk_bios_302_mame.zip is stuff you'll need for mame.  
Including an hd image with the key repeat disabled so you can run it 10x speed  
The speed line in mame.ini configures that  

https://victor9000.com/disk-bios/disk_bios_302_mame.zip
  
## Tool for working with img files:
https://github.com/IntergalacticMicrosystems/vtg_image_util
  
  
***NOTE: 3 of the built OBJ files are different***
**HDSETUP.OBJ is the only one that changes the output**
**A single byte in msdos.bin is different - reversed comparison**
**operators.  Effectively identical in this case as it's a <> comparison**
`HDSETUP.OBJ`  
`SYSINIT1.OBJ`  
`SYSINIT2.OBJ`  
  
## IO SUBSYSTEM 3.02 / MS-DOS 3.10He
    
Download mame, extract into a folder  
extract disk_bios_302_mame.zip into the same folder  
run.cmd  (on windows, similar on linux/mac)  
  
## Assemble / Compile the disk BIOS
**If you don't want to change the source you can skip this step**
**Also - you can just assemble/compile single files, check the bld batch files**
  
(NOTE: ALT = CTRL on the Victor, `ALT + =` key = \ )  
  
**In the booted Victor:**  
`d:`  
`cd bios302`  
`bldasm`  
this assembles asm files to obj.  3 errors, can ignore them  
`bldplm`  
this compiles the PLM files to obj  
copy the modified obj files you want to e:\sysgen31  
  
**Generate the msdos system file, sys it to disk**
  
`e:`  
`cd sysgen31`  
`sysgen`  
follow the prompts
sometimes the num keypad arrows work better
here you select the system config you need
for example floppy/hd system you'd run
`2 e: e:`  
once it's done it'll ask destination drive
hit return to exit - sys from the hd doesn't work
mount a DOS 3.1 floppy now to flop1 - it will need to be able to sys another disk without error
the included DOS31-FULL-DS-NO-KEY_RPT.img disk should work
mount a floppy to copy the new boot files to in flop2 (v9k-blank-ds.img will work)
`copy msdos.bin a:`  
`cd a:`  
`sys msdos.bin`  
choose b as destination
hit space to do the copy
if it errors out, the a: disk may not be just right, sys is picky
you can close mame and run-flop.cmd to test  
  
### On Windows, mounting a floppy -
  
Scroll Lock (sometimes need to hit it twice)  
tab should bring up a menu  
choose File Manager  
select floppydisk1  
select the floppy image (DOS31.img is included)  
read-write  
return to previous menu  
close menu  
hit scroll lock again  
  
### MISC NOTES
The PLM and ASM files were painstakingly (un)made from LST listing files.  
With a bit of help at the end from Codex and Claude Code.  
The SYSGEN bits are from the Application Programmers Toolkit II v3. (I think)  

**I made notes on what some of the files in the process do:**  
  
**Files that are probably supplied by MS we don't have the code for:**  
`doshi.obj`  
  
**SYSGEN.BAT runs:**
 `SYSELECT` and `BIN2REL`  
  
**SYSELECT creates/changes:**  
`tempfile.$$$`   (contains name.ctl)  
`name.ctl`  
`name.spr`  
`name.ban`  
  
**BIN2REL creates:   (from .CTL file pointed to by tempfile.$$$ instructions?)**  
`banner.obj`  
`charset.obj`  
`keys.obj`  
`xlate.obj`  
`syspar.obj`  
  
**The numbered batch files - (1.bat, 2.bat, etc):**  
eg: 2.bat runs  
`makems %1 %2 v9000hd`  
%1 %2 are the arguments - disk letters where the OBJ files are  
`v9000hd.lnk` is a linker list file for that configuration  
  
**MAKEMS.bat runs:**  
`link order+ mscold+ doshi+ sysinit1+ sysinit2+ sysimes+ msbios+ makebpb+ @%3.lnk`  
creates msdos.exe  
`sysloc msdos.exe msdos.bin /l/s`  
? not sure - msdos.bin is smaller than exe  

### Notes on the Source / OBJ file:
| Filename | Univ V9K / Vicki? | Compiles | Matches | Type | Language |
| --- | --- | --- | --- | --- | --- |
| BEL.PLM | NO - SET | x | x | PLM | PL/M-86 |
| BUFFER.ASM | x | x | x | ASM | MASM 1.24 |
| BUFFERFL.ASM | x | x | x | ASM | MASM 1.24 |
| BUFFERHD.ASM | x | x | x | ASM | MASM 1.24 |
| CB.PLM | NO - SET | x | x | PLM | PL/M-86 |
| CI.PLM | x |  | x | PLM | PL/M-86 |
| CO.PLM | x | x | x | PLM | PL/M-86 |
| CONS.ASM | x | x | x | ASM | MASM 1.24 |
| DIO.PLM | NO - SET | x | x | PLM | PL/M-86 |
| DLABEL.PLM |  | x | x | PLM | PL/M-86 |
| DMATH.ASM | x | x | x | ASM | MASM 1.24 |
| ERRORMAP.PLM |  | x | x | PLM | PL/M-86 |
| FDDV9000.PLM | NO - sep files | x | x | PLM | PL/M-86 |
| FDDVICKI.PLM | NO - sep files | x | x | PLM | PL/M-86 |
| FDIOREGS.ASM | x | x | x | ASM | MASM 1.24 |
| FSYNC.ASM | x | x | x | ASM | MASM 1.24 |
| HDLIO.PLM |  | x | x | PLM | PL/M-86 |
| HDPHY.PLM |  | x | x | PLM | PL/M-86 |
| HDSETUP.PLM |  | x | NO - diff | PLM | PL/M-86 |
| HDVIO.PLM |  | x | x | PLM | PL/M-86 |
| IODEV.ASM | x | x | x | ASM | MASM 1.24 |
| IODISP.PLM |  | x | x | PLM | PL/M-86 |
| IOINIT.PLM | NO - SET + special | x | x | PLM | PL/M-86 |
| IRQ.ASM | x | x | x | ASM | MASM 1.24 |
| KB.PLM | NO - SET | x | x | PLM | PL/M-86 |
| KBCHRHK.PLM |  | x | x | PLM | PL/M-86 |
| MAKEBPB.PLM |  | x | x | PLM | PL/M-86 |
| MSBIOS.ASM | x | x | x | ASM | MASM 1.24 |
| MSCOLD.ASM | x | x | x | ASM | MASM 1.24 |
| MSDISK.PLM |  | x | x | PLM | PL/M-86 |
| MSSETUP.PLM |  | x | x | PLM | PL/M-86 |
| NOHD.PLM |  | x | x | PLM | PL/M-86 |
| NOIEEE.ASM | x | x | x | ASM | MASM 1.24 |
| ORDER.ASM | x | x | x | ASM | MASM 1.24 |
| PASSKEY.ASM | x | x | x | ASM | MASM 1.24 |
| SASIDMA.PLM |  | x | x | PLM | PL/M-86 |
| SPEED.PLM |  | x | x | PLM | PL/M-86 |
| SYSIMES.ASM | x | ERR-OK | x | ASM | MASM 3.06 |
| SYSINIT1.ASM | ? | ERR-OK | NO - diff | ASM | MASM 3.06 |
| SYSINIT2.ASM | ? | ERR-OK | NO - diff | ASM | MASM 3.06 |
| TOD.ASM | x | x | x | ASM | MASM 1.24 |
| XBIOS.ASM | x | x | x | ASM | MASM 1.24 |
| DOSHI | missing |  |  |  |  |
| VERSION.ASM |  |  |  | ASM | MASM 1.24 |
| STDSW.ASM |  |  |  | ASM | MASM 1.24 |
| TITLE.ASM |  |  |  | ASM | MASM 1.24 |
| PAGESIZE.ASM |  |  |  | ASM | MASM 1.24 |
| LEGAL.ASM |  |  |  | ASM | MASM 1.24 |
| LEGAL.PLM |  |  |  | PLM | PL/M-86 |
| TITLE.PLM |  |  |  | PLM | PL/M-86 |
| AIB.STR |  |  |  | STR | PL/M-86 |
| DG.STR |  |  |  | STR | PL/M-86 |
| DI.STR |  |  |  | STR | PL/M-86 |
| J.STR |  |  |  | STR | PL/M-86 |
| JA.STR | for asm |  |  |  |  |
| J.DEF |  |  |  | DEF | PL/M-86 |
| FDDCLOCK.INC |  |  |  | INC | PL/M-86 |
| FDDMOTOR.INC |  |  |  | INC | PL/M-86 |
| FDDSTEP.INC |  |  |  | INC | PL/M-86 |
| FLERRORA.INC | for asm |  |  | INC | PL/M-86 |
| FLERRORS.INC |  |  |  |  |  |
| PLM.INC |  |  |  | INC | PL/M-86 |
| SIGNON.INC |  |  |  | INC | PL/M-86 |
#### UNIMPORTANT Created during BIN2REL / SYSELECT 
| Filename | Univ V9K / Vicki? | Compiles | Matches | Type | Language |
| --- | --- | --- | --- | --- | --- |
| BANNER.ASM |  |  | NO - diff | ASM | MASM 1.24 |
| XLATE.ASM |  | x | NO - diff |  |  |
| SYSPAR.PLM |  | x | NO - diff |  |  |
| KEYS.ASM |  | x | NO - but OK |  |  |
| CHARSET |  |  |  |  |  |
