
 \ mouse interface from                               10Jun90Rei
 \ Dr Dobbs toolbook of forth pp. 60-62



\ Screen 1

 0  \ microsoft mouse interface                           08Aug90Rei
 1  .( mouse.blk )
 2  
 3  FORTH DEFINITIONS HEX
 4  
 5  (S M4 M3 M2 M1 -- M4 M3 M2 M1 )
 6  (S dx cx bx ax -- dx cx bx ax )
 7  code mouse-io  ax pop   bx pop   cx pop   dx pop
 8                 si push   bp push   33 int
 9                 bp pop   si pop
10                 dx push  cx push bx push ax push
11                 next end-code
12  
13  : 4drop 2drop 2drop ;
14                                                       -->
15  

Screen 2 

 0  \ microsoft mouse driver                              10Jun90Rei
 1  DECIMAL
 2  
 3      (S -- f ) \ -1 = installed, 0 = not installed.
 4  : mouse-reset   0 0 0 0 mouse-io >r 2drop drop r> ;
 5  : show-cursor   0 0 0 1 mouse-io 4drop ;
 6  : hide-cursor   0 0 0 2 mouse-io 4drop ;
 7  
 8     (S -- x y )
 9  : @position     0 0 0 3 mouse-io 2drop swap ;
10  
11     (S -- n ) \ bits 0 = left  bit 1 = right button
12  : @buttons      0 0 0 3 mouse-io drop >r 2drop r> ;
13  
14     (S x y -- )
15  : !position  swap 0 4 mouse-io 4drop ;      -->








Screen 3 

 0  \ mouse driver interface                              10Jun90Rei
 1      (S button -- x y press-cnt button-status )
 2  : @presses 0 0 rot 5 mouse-io
 3             3 roll 3 roll swap 3 roll 3 roll ;
 4  : @releases 0 0 rot 6 mouse-io
 5             3 roll 3 roll swap 3 roll 3 roll ;
 6  
 7      (S min max -- )
 8  :  hor-limits swap 0 7 mouse-io 4drop ;
 9  : vert-limits swap 0 8 mouse-io 4drop ;
10  
11      (S pointer x y -- )
12  : set-gcur swap 9 mouse-io 4drop ;
13  (S hardware: scan-line-start scan-line-stop cursor-select --  )
14  (S software: screen-mask     cursor-mask    cursor-select --  )
15  : set-tcur  rot rot swap rot 10 mouse-io 4drop ; -->


Screen 4 

 0  \ mouse driver                                        08Aug90Rei
 1    (S -- x-cnt y-cnt )
 2  : @counters  0 0 0 11 mouse-io 2drop swap ;
 3     (S adr mask -- )
 4  : set-subr  0 12 mouse-io 4drop ;
 5  
 6  : enable-pen (S -- ) 0 0 0 13 mouse-io 4drop ;
 7  : disable-pen 0 0 0 14 mouse-io 4drop ;
 8  
 9  : set-micky (S hor vert -- ) \ ratio
10    swap 0 15 mouse-io 4drop ;
11  
12  
13  
14  
15  


