
\ fractulus mandelbrotis MANDEL45 released as version 1.0
\ NoCreditWara para dwarfa data
\ BurpWare
\ Quack Production's QuackWare  
\ spliffware (armageddon designers)
\ wrapping-up early hours of Monday 29th April 1991
\ can be unwrapped again late evening of tuesday next day
\ (but by then the horse will have bolted)
\ (no point closing the barn doors)

128 MSDOS




INCLUDE NPU8087
INCLUDE DOSINT		HANDLE FRACTALFILE
INCLUDE SIRIUS
INCLUDE GRAFEMIT
INCLUDE SOUND

INCLUDE FONTSCWL        

\ COMMENT OUT THESE THREE LINES TO RETURN TO FULL 256 CHARS TABLE
	CHARYSIZE DECIMAL 32 ( CHARS PINCHED ) * 
	DUP NEGATE ALLOT
	DUP CR . .( bytes pinched from chartab ) -

INCLUDE MENUS

DECIMAL



\ compiler extensions 

H: .S    ( -- )    DEPTH 0 ?DO I PICK . LOOP  ;
H: SECTION   ( N -- )
	DEPTH 2 -  
	IF  
		CR ." ERR @ SECTION " . 
		."  STACK: "  .S   FALSE
	THEN DROP  ;

H: CREATE-LOOKUP  ( -- ADDR )    
	HERE CREATE 0 , ;

H: END-LOOKUP     ( ADDR -- )    
	HERE OVER CELL + -  
	2/ 2/  SWAP !  ; 

H: "  ( -- ADDR )    
	HERE 0 C,  ,"  
	HERE OVER 1+ - OVER C!  ;	

1 0 IN/OUT
H: MESSAGE  ( -- )  
	CREATE " DROP  
	DOES> COUNT TYPE  ;

H: COMMON_FLOAT   ( -- ) 
	10 ALLOT  ;

H: OTHER_TOKEN  ( N -- N )
	DUP CONSTANT  1+    ;

VARIABLE FRACTALNAMES   ( link fractal names )
H: ADD_FRACTAL ( -- )
	FRACTALNAMES LINK 
	" DROP ;


CREATE EXTENSION " .ORB"  DROP
CREATE WILDCARD  " *.ORB" DROP


MESSAGE SILLY silly, you'll have to get an Issue 8087 Board
MESSAGE STACK-ERROR bug: net stack effect
MESSAGE PRESS_KEY ... press key ...
MESSAGE LOADING loading
MESSAGE IMAGE-DATA image data
MESSAGE WRITING writing
MESSAGE OBJECT-DATA object data
MESSAGE DONE done
MESSAGE SAVE save
MESSAGE LOAD load
MESSAGE FILESPEC filespec >
MESSAGE NOW now
MESSAGE IT'S it's




2 0 IN/OUT
H: FILEPROBLEM    ( -- )
	CREATE  
		" DROP
	DOES>	
		SWAP IF DUP
			>R
			BEGIN_DIALOG
			R> COUNT TYPE
			FRACTALFILE .FILENAME
			PRESS_KEY WAIT 
			WIPE_DIALOG  
			END_DIALOG
		THEN DROP   ;



( F -- )
FILEPROBLEM ?CAN'T-CREATE can't create
FILEPROBLEM ?CAN'T-OPEN can't open
FILEPROBLEM ?CAN'T-READ can't read
FILEPROBLEM ?CAN'T-WRITE problem writing to
FILEPROBLEM ?CAN'T-CLOSE problem closing



0
   OTHER_TOKEN ABORT_FRACTAL
   OTHER_TOKEN CONTINUE_FRACTAL 
   OTHER_TOKEN SUSPEND_FRACTAL
DROP


0
   OTHER_TOKEN NO_SOUND
   OTHER_TOKEN INVERTED_SOUND
   OTHER_TOKEN OTHER_INVERTED_SOUND
   OTHER_TOKEN NORMAL_SOUND
DROP



\ target data structures

FVARIABLE B 
FVARIABLE Y
VARIABLE K




DECIMAL
H: %  100 */  ;

CREATE FRACTAL-DATA   \ ====== DATA WRITTEN TO FRACTAL FILE ====== 

CREATE ARRANGEDATA
CREATE XHOME  XRES 40 %  DUP ,
CREATE XSIZE  XRES 20 %  DUP ,
CREATE YHOME  YRES 40 %  DUP ,
CREATE YSIZE  YRES 20 %  DUP ,

CREATE MAGNIFYDATA
	>R ROT , SWAP , ,  R> ,


\ TRANSLATED TO/FROM FLOATING POINT VARIABLES ON FILE SAVE/LOAD
CREATE FX1'  	 COMMON_FLOAT
CREATE FY1'  	 COMMON_FLOAT
CREATE FXRANGE'  COMMON_FLOAT
CREATE FYRANGE'  COMMON_FLOAT


VARIABLE SOUND-TYPE
SOUND-TYPE ON

DECIMAL
 4 EQU LIMIT
40 EQU #ITERATIONS
 2 EQU LINESKIP

VARIABLE INTERRUPTED_AT_LINE
VARIABLE INTERRUPTED_AT_PASS
VARIABLE INTERRUPTED_AT_PIXEL
VARIABLE FRACTALTYPE             0 FRACTALTYPE !

4 CELLS ALLOT   		\ SPARE DATA SPACE

HERE FRACTAL-DATA - CONSTANT FRACTAL-DATA-SIZE  \ ===== END FRACTAL FILE ======



CREATE ZOOMDATA   HERE	
0 	,  
XRES 1- ,    
0 	,  
YRES 1- ,           HERE SWAP -  CONSTANT BOXDATASIZE


CREATE UNZOOMDATA
XRES 40 %  ,
XRES 20 %  ,
YRES 40 %  ,
YRES 20 %  ,





\ NUMBER FORMAT DEPENDING ON FLOATING POINT OPTION
FVARIABLE FX1
FVARIABLE FY1
FVARIABLE FXRANGE
FVARIABLE FYRANGE

CREATE FOCUSDATA
VARIABLE XHOME'	
VARIABLE XSIZE'
VARIABLE YHOME'
VARIABLE YSIZE'


VARIABLE MOVE/RESIZE
8 EQU STEPSIZE		\ DEFAULT SNAP

VARIABLE nPASSES
VARIABLE CONTINUE?
VARIABLE REPLY


\ ================================================================

1 SECTION

0 0 IN/OUT
: WAIT  ( -- )	
	BEGIN ?TERMINAL 
	NOT WHILE WAITING 
	REPEAT ;

1 0 IN/OUT
: >DIALOG ( N -- )	
	#LINES 1- !XY  ;


0 0 IN/OUT
: WIPE_DIALOG ( -- )
	CHARS/LINE 1 DO
		I >DIALOG PICKCHAR
		DUP  0=  SWAP  BL =   OR
		NOT  IF  BL PUTCHAR  THEN
	LOOP  ;

0 0 IN/OUT
: DIALOG  ( -- ) 
	WIPE_DIALOG
	2 >DIALOG ;

: BEGIN_DIALOG  ( -- X Y ATTR )
	?XY @ATTR 
	NORMAL DIALOG  ;

\ leaves last dialog visible.
: END_DIALOG    ( X Y ATTR -- )
	!ATTR !XY  ;


: TELL ( N1 N2 ADDR -- N1' N2' )
	?XY
	ROT COUNT TUCK TYPE
	-ROT 1+ !XY 
	ROT MAX  SWAP 1+  ; 	




\ TRUE: OK
\ 2 1 IN/OUT
\ : CHECK_UPPERLEFT ( X Y -- F )
\	OR 0< NOT  ;

\ TRUE: OK
\ : CHECK_BOTTOMRIGHT ( X Y XS YS -- F )
\	ROT  + YRES U< 
\	-ROT + XRES U<   
\	AND  ;

0 0 IN/OUT
: FLUSH_KB ( -- )
	BEGIN ?TERMINAL 
	WHILE XKEY DROP 
	REPEAT ;





: EXPAND ( X Y XS YS -- X Y XS YS )
	>R >R >R  3 - R> 2- R> 6 + R> 4 + ;

: CONTRACT ( X Y XS YS -- X Y XS YS )
	>R >R >R  3 + R> 2+ R> 6 - R> 4 - ;



: (FRAMESOUT,DOTTED)  ( X Y XS YS -- X' Y' XS' YS' )
	0 ?DO
		EXPAND
		2OVER 2OVER XFRAME,DOTTED
	LOOP   ;

: (FRAMESIN,DOTTED)  ( X Y XS YS -- X' Y' XS' YS' )
	0 ?DO
		2OVER 2OVER XFRAME,DOTTED
		CONTRACT
	LOOP   ;

: (FRAMESOUT)  ( X Y XS YS -- X' Y' XS' YS' )
	0 ?DO
		EXPAND
		2OVER 2OVER XFRAME
	LOOP   ;

: (FRAMESIN)   ( X Y XS YS -- X Y XS YS )
	0 ?DO
		2OVER 2OVER XFRAME
		CONTRACT
	LOOP   ;



: FRAMESIN   ( X Y XS YS -- )
	(FRAMESIN) 2DROP 2DROP ;

: FRAMESOUT  ( X Y XS YS N -- )
	(FRAMESOUT) 2DROP 2DROP  ;

: FRAMESOUT,DOTTED  ( X Y XS YS N -- )
	(FRAMESOUT,DOTTED) 2DROP 2DROP  ;

: FRAMESIN,DOTTED  ( X Y XS YS N -- )
	(FRAMESIN,DOTTED) 2DROP 2DROP  ;


: ZANY_FRAMY ( x y xs ys -- )   
	BEGIN
	2 0 DO
		2OVER 2OVER  3 FRAMESOUT
	LOOP
	?TERMINAL UNTIL 
	2 FRAMESOUT  ;


DECIMAL
\ : PUMP ( x y xs ys -- )
\	40 0 DO
\		?TERMINAL IF LEAVE THEN
\		10  (FRAMESOUT)
\		10  (FRAMESIN)  
\		5   (FRAMESOUT)
\	5 +LOOP
\	2DROP 2DROP  ;
\
\ : INZANY_FRAMY ( x y xs ys -- )   
\	BEGIN
\		2OVER 2OVER PUMP
\		2OVER 2OVER  40 FRAMESOUT,DOTTED
\		2OVER 2OVER  40 FRAMESOUT  
\	?TERMINAL UNTIL
\	2DROP 2DROP  
\	FLUSH_KB  ;

: INZANY_FRAMY ( x y xs ys -- )   
	2 (FRAMESOUT) 			
	2 (FRAMESIN)  			\ ?TERMINAL NOT IF
	4 (FRAMESOUT)			
	4 (FRAMESIN)			?TERMINAL NOT IF
	2OVER 2OVER 50 FRAMESOUT,DOTTED		
	2OVER 2OVER 50 FRAMESOUT,DOTTED
					THEN \ THEN
	FLUSH_KB
	2DROP 2DROP  ;


0 0 IN/OUT
: WELCOME ( -- )
	CHARS/LINE 38 - 2/   #LINES 5 - 2/  
	2DUP !XY XY>ADDR 
	0 0

	"  Orbic v1.0  fractilus mandelbrotis "	TELL
	"  Dwarf Data's  NoCreditWare  <Issue "	TELL
	"  ever so silliusware> Copyfree 1991 "	TELL
	"  Go Ply and Multiforth general-dis- "	TELL
	"  claimer-fabrilationphasedand-final "	TELL

	XY>ADDR 
	INZANY_FRAMY 
	FLUSH_KB ;

\ plytimul




2 SECTION


1 0 IN/OUT
: TOGGLE ( ADDR -- )  
	DUP @ 0= <- ;

1 0 IN/OUT
: IN/OUT?  ( F -- )
	IF ." in" ELSE ." out" THEN  ;





3 SECTION


2 0 IN/OUT
: WHATSOUND ( TYPE PITCH -- )
	SWAP INVERTED_SOUND = 
	IF   #ITERATIONS SWAP -	THEN 
	PITCH ;




\ =====================================================================
\	         INTER SEGMENT MEMORY ALLOCATION
\ =====================================================================

XRES 8 / YRES * CONSTANT B/SCR
VARIABLE SCREENBASE

HEX
CREATE DP-THERE  01000 ,   ( allocation unit is PARAGRAPH )
0 1 IN/OUT
: THERE		( -- PARAGRAPH )	?CS: DP-THERE @ +  ;

1 0 IN/OUT
: THALLOT	( PARAGRAPHS -- )	DP-THERE +!  ;

1 1 IN/OUT
: PARAGRAPHS    ( N -- N )		1- 4 >> 1+ ;


\ check if content of ADDR is zero. If, write the next available
\ paragraph to ADDR and allocate N paragraphs.
2 0 IN/OUT
: ?THALLOT      ( N ADDR -- )		
	DUP @  0= IF
		THERE OVER !
		OVER THALLOT
	THEN 2DROP  ;





2 0 IN/OUT
: ?ALLOT      ( N ADDR -- )		
	DUP @  0= IF
		HERE OVER !
		OVER ALLOT
	THEN 2DROP  ;


\ ------------------ SCREEN SAVE / SCREEN RESTORE -------------------

0 0 IN/OUT
: SAVE_VIDEO ( -- )
	B/SCR PARAGRAPHS SCREENBASE ?THALLOT  \ allocate only first time
	GRAFSEG 0  SCREENBASE @ 0  B/SCR CMOVEL  ;

0 0 IN/OUT
: RESTORE_VIDEO  ( -- )
	SCREENBASE @ 0  GRAFSEG 0  B/SCR CMOVEL  ;





\ =====================================================================
\	             MANDELBROT PIXEL ROUTINE 
\ =====================================================================



( N N -- )
( -- FLOAT )
: th	>R S>F	R> S>F	F/	;


( N -- )
( -- FLOAT )
: >X	XHOME @ -	S>F
	FXRANGE F@ F*
	FX1 F@ F+	;	

( N -- )
( -- FLOAT )
: >Y  	YHOME @ -	S>F
	FYRANGE F@ F*
	FY1 F@ F+	;


( -- K )
( FLOATX FLOATY -- )
: MANDEL(X,Y)
	FDUP B F!   Y F!
	FDUP
	#ITERATIONS DUP K !
	0 DO
		FOVER FOVER F^2
		Y F@ F^2 
		FOVER FOVER F+
		F>S  LIMIT >
		IF	FDROP FDROP FDROP
			I K ! LEAVE 
		THEN
		F- F+ FSWAP
		Y F@ F*	F2*
		B F@ F+ Y F!
	LOOP
	FDROP  FDROP
	K @  ;






0 0 IN/OUT
: DEFAULT_PARAMETERS ( -- )
	-5 2 th 	FX1 F!
	-5 2 th 	FY1 F!
	 5 XSIZE @ th FXRANGE F!
	 5 YSIZE @ th FYRANGE F!  ;






\ -------------- buffered console input ------------

1 1 IN/OUT
: PROCESS_BACKSPACE  ( ADDR -- ADDR )
	DUP TIB U>
	IF
		1-
		?XY SWAP 1- SWAP !XY
		BL PUTCHAR
	THEN  ;

2 1 IN/OUT
: PROCESS_KEY  ( ADDR ASC -- ADDR )
	DUP BS  = IF  DROP PROCESS_BACKSPACE  ELSE
		      DUP EMIT  OVER C!  1+   THEN  ;

0 0 IN/OUT
: QUERY  ( -- )
	TIB
	BEGIN 	WAIT XKEY 
		DUP ENTER <> WHILE
		PROCESS_KEY REPEAT
	DROP  ( RETURN )
	0 OVER C!
	TIB - >TIB ! ;










: QUITMENU     ( -- )   
	REMOVE-MENU AFTER-SELECTION !  ;

: QUITPROG     ( -- )
	QUITMENU
	FALSE CONTINUE? !  ;


0 1 IN/OUT
CODE SP@  
	SP AX MOV  
	RET   
END-CODE


\     FX1 F@  XSIZE @ S>F FXRANGE F@ F/ F+ F. ." /"
\     FY1 F@  YSIZE @ S>F FYRANGE F@ F/ F+ F.



: STATUSLINE	( -- )
	BEGIN_DIALOG
	." code:" ?CS: HEX 4 U.R
	." , dictionary pointer:" HERE 4 U.R
	." , stack:" SP@ 4 U.R
	." , depth:" DECIMAL DEPTH 4 U.R
	." , used:"  HERE 5 U.R
	." , free:"  FREE 5 U.R
	." , 8087:" EM/87 @ IN/OUT?
	END_DIALOG ;



VARIABLE WALKING_LIGHT
CTABLE WALKCHAR   
	ASCII / C,  
	ASCII \ C,

: WAITING  ( -- )
	?XY @ATTR NORMAL
	0 WALKING_LIGHT @  
	0 OVER 1+ #LINES MOD
	DUP WALKING_LIGHT !
	TUCK !XY 
	1 AND WALKCHAR PUTCHAR
	!XY SPACE  
	!ATTR !XY  ;

' WAITING MENUS-IDLE !


1 0 IN/OUT
: INFORM  ( N -- )
	>R
	BEGIN_DIALOG
	R> NOW IT'S DECIMAL U.
	END_DIALOG  ;

1 0 IN/OUT
: INFORM_ON/OFF  ( F -- )
	>R
	BEGIN_DIALOG
	R>  NOW IT'S IN/OUT?
	END_DIALOG ;


1 0 IN/OUT
: CHANGE_LINESKIP ( N -- )
	DUP EQU LINESKIP 
	INFORM  ;	
	
: +LINESKIP ( -- )
	LINESKIP 1+ 
	CHANGE_LINESKIP  ;

: -LINESKIP ( -- )
	LINESKIP 1- 1 MAX
	CHANGE_LINESKIP  ;



DECIMAL
1 0 IN/OUT
: CHANGE_ITERATIONS  ( N -- )
	DUP EQU #ITERATIONS
	INFORM  ;

: +ITERATIONS  ( -- )
	#ITERATIONS 10 + 
	CHANGE_ITERATIONS  ;

: -ITERATIONS ( -- )
	#ITERATIONS 10 - 10 MAX
	CHANGE_ITERATIONS  ;

: XITERATIONS ( -- )
	#ITERATIONS 1 XOR
	CHANGE_ITERATIONS  ;

: 40ITERATIONS  ( -- )
	40 CHANGE_ITERATIONS  ;

: 70ITERATIONS  ( -- )
	70 CHANGE_ITERATIONS  ;

: 100ITERATIONS  ( -- )
	100 CHANGE_ITERATIONS  ;

: 400ITERATIONS  ( -- )
	400 CHANGE_ITERATIONS  ;

: 1000ITERATIONS  ( -- )
	1000 CHANGE_ITERATIONS  ;

\ : N-ITERATIONS   ( -- )
\	BEGIN_DIALOG
\	QUERY TIB READ#  
\	CHANGE_ITERATIONS  DROP 
\ 	END_DIALOG  ;


1 0 IN/OUT
: CHANGE_SOUND  ( N -- )
	DUP SOUND-TYPE !
	INFORM_ON/OFF ;

: SOUND_INVERT  ( -- )
	INVERTED_SOUND CHANGE_SOUND ;

: SOUND_ON  ( -- )
	NORMAL_SOUND CHANGE_SOUND  ;

: SOUND_OFF  ( -- )
	NO_SOUND CHANGE_SOUND  ;





\ FLOAT NUMBER CONVERSION
DECIMAL

2 0 IN/OUT
: EXTERNAL>INTERNAL  ( ADDR ADDR -- )
	>R 
	10 +   ( END OF COMMON FLOAT NUMBER ) 
	>R
	0 S>F  R>
	8 0 DO
		1- DUP >R
		C@ S>F F+
		256 S>F F/
		R> 
	LOOP
	CELL -
	@   \   16384 -   ( error catch compensation ) 
	S>F F+
	R> F!  ;


2 0 IN/OUT
: INTERNAL>EXTERNAL ( ADDR ADDR -- )
	>R
	F@  16384 S>F F+  ( error catch )
	FDUP F>S  DUP  16384 - R@  !
	S>F F-
	R> CELL +
	8 0 DO
		>R
		256 S>F F*
		FDUP F>S  
		DUP R@ C!
		S>F F-
		R> 1+
	LOOP
	DROP FDROP  ;


0 0 IN/OUT
: EXPORT_FLOATS  ( -- )
	FX1 	FX1'  	 INTERNAL>EXTERNAL
	FY1 	FY1'  	 INTERNAL>EXTERNAL
	FXRANGE FXRANGE' INTERNAL>EXTERNAL
	FYRANGE FYRANGE' INTERNAL>EXTERNAL  ;

0 0 IN/OUT
: IMPORT_FLOATS  ( -- )
	FX1' 	 FX1  	 EXTERNAL>INTERNAL
	FY1' 	 FY1  	 EXTERNAL>INTERNAL
	FXRANGE' FXRANGE EXTERNAL>INTERNAL
	FYRANGE' FYRANGE EXTERNAL>INTERNAL  ;


0 EQU 8087_PRESENT  \ AVOID 8087 RE-INIT 
: 8087_ON   ( -- )
	8087_PRESENT 	
	IF 
		EXPORT_FLOATS
		ENABLE 		
		IMPORT_FLOATS  
		EM/87 @
		INFORM_ON/OFF
	ELSE 
		BEGIN_DIALOG
		SILLY
		END_DIALOG
	THEN	;


: 8087_OFF   ( -- )
	EXPORT_FLOATS
	DISABLE 		
	IMPORT_FLOATS
	EM/87 @
	INFORM_ON/OFF	;





5 SECTION

\ scan string ADDR,CNT for ASC found, truncate (including ASC),
\ append ADDR1, update CNT to reflect new string size.
\ ADDR must guarantee trailing slack space to accomodate appended string
: FORCE  ( ADDR CNT ADDR1 ASC -- ADDR CNT' )
	>R
	COUNT
	2OVER  R> SCAN  DROP    ( ADDR CNT ADDR CNT ADDR )
	2DUP + >R			( END OF NEW STRING )
	SWAP CMOVE
	DROP R> OVER -	;		( NEW LENGTH )




\ ---- FILE SAVE ----

: SAVE_DATA  ( SEG OFF N -- F )
	0 DO
		LCOUNT PUT
		IF 0= LEAVE THEN
	LOOP   0= NIP   ;

0 1 IN/OUT
: SAVE_BENCH ( -- F )
	DIALOG  WRITING IMAGE-DATA
	SCREENBASE @ 0  B/SCR SAVE_DATA
	DIALOG  WRITING OBJECT-DATA
	EXPORT_FLOATS
	?CS: FRACTAL-DATA FRACTAL-DATA-SIZE SAVE_DATA
	OR  ;


: SAVE_FRACTAL  ( -- )
	BEGIN_DIALOG
	SAVE FILESPEC
	QUERY TIB READ$
	DUP IF
		EXTENSION ASCII . FORCE
		2DUP FRACTALFILE FILENM
		FRACTALFILE MAKE-FILE
		DUP ?CAN'T-CREATE
		0= IF
			FRACTALFILE TOFILE 
			SAVE_BENCH ?CAN'T-WRITE
			ENDTO ?CAN'T-CLOSE
		THEN
	THEN	2DROP DROP  
	DIALOG DONE
	WAIT 
	WIPE_DIALOG 
	END_DIALOG  ;



\ ---- FILE LOAD ----

: LOAD_DATA  ( SEG OFFS N -- F )
	0 DO
		2DUP
		GET  IF 2DROP 0= LEAVE THEN
		-ROT C!L  1+
	LOOP   0=  NIP  ;


0 1 IN/OUT
: LOAD_BENCH  ( -- F )	
	DIALOG   LOADING IMAGE-DATA 

	SCREENBASE @ 0  B/SCR  LOAD_DATA
	DIALOG LOADING OBJECT-DATA

	?CS: FRACTAL-DATA  FRACTAL-DATA-SIZE LOAD_DATA  OR
	IMPORT_FLOATS   ;


\ set file name in handle to string.ORB
2 0 IN/OUT
: FRACTALNAME  ( ADDR CNT -- )
	EXTENSION ASCII . FORCE
	FRACTALFILE FILENM  ;


0 0 IN/OUT
: (LOAD_FRACTAL)  ( -- )
	FRACTALFILE OPEN-FILE-R/O
	DUP ?CAN'T-OPEN
	0= IF
		FRACTALFILE FROMFILE LOAD_BENCH
		?CAN'T-READ  ENDFROM
	THEN 
	LINESKIP nPASSES !  ;






\ : LOAD_FRACTAL  ( -- )
\	BEGIN_DIALOG LOAD FILESPEC 
\	QUERY TIB READ$  
\	DUP IF  
\		2DUP  
\	FRACTALNAME  (LOAD_FRACTAL)  ;
\		THEN  
\	2DROP DROP  
\	QUITMENU
\	DIALOG DONE
\	WAIT
\	WIPE_DIALOG
\	END_DIALOG  ;


FALSE #IF

\ EPSON PRINTER PLOTTING

DECIMAL

: DELAY  ( -- )
	20 0 DO LOOP ;

\ SET PRINTER TO GRAF MODE AND PRINT THE NEXT N CHARS AS BIT MAP

: nPATTERNS  ( N -- )
	27 DOS-EMIT 	ASCII L DOS-EMIT
	DELAY
	DUP DOS-EMIT	>< DOS-EMIT  
	DELAY ;

: SET_SPACING ( -- )  
	27 DOS-EMIT
	DELAY
	ASCII 3 DOS-EMIT
	DELAY
	24 DOS-EMIT  
	DELAY ;

\ FROMON PIXEL(X,Y), PLOT XS HORIZONTAL PIXELS, 8 BIT HIGH , TO PRINTER 
: GDUMPLINE ( X Y XS -- )
	SET_SPACING
	DUP nPATTERNS
	ROT SWAP RANGE
	?DO
	   0
	   OVER 8 RANGE DO
		 2*  J I ?DOT
		 0<> 1 AND OR  
	      LOOP
	   DOS-EMIT
	   DELAY
	LOOP	
	DROP 

	\ 5 0 DO				\ 10 works on LQ
	\ 0 0 DO LOOP
	\ LOOP
	13 DOS-EMIT  \ CR
	DELAY
	10 DOS-EMIT  \ LF
	DELAY ;

		
: (GDUMP) ( X Y XS YS -- )
	PRINTER
	0 ?DO
		3DUP GDUMPLINE
		SWAP 8 + SWAP
	8 +LOOP
	2DROP DROP
	CONSOLE  ;


: GDUMP  ( -- )
	XHOME @ YHOME @
	XSIZE @ YSIZE @
	(GDUMP)  ;

#THEN

\ --------------------------------------------------------------------
: DOFILE  ( -- )
	HERE CURRENTITEM @ CELL +  COUNT 
	TUCK HERE SWAP CMOVE FRACTALNAME
	QUITMENU  ;



1 0 IN/OUT
: MAKE-FILESMENU ( ADDR -- )
	>R
	0 , 0 , 0 ,	\ height width choice

	WILDCARD COUNT FRACTALFILE FILENM
	FRACTALFILE NORMAL-FILE SEARCH-FIRST
	BEGIN

	0=		 	( more filenames available )
	R@ @  #LINES 2-  <  	( still room for more filenames )
	AND

	WHILE
		['] DOFILE ,		\ set execution address
		>FILENAME
		DUP BEGIN COUNT 0= UNTIL	\ scan to end of filename
		1- OVER -  
		
		4 -   				\ truncate - remove .ORB

		1 R@ +!				\ count item
		R@ CELL + 2DUP @ MAX <-		\ longest item

		DUP C,				\ set item length
		HERE OVER ALLOT			\ allocate string space
		SWAP  CMOVE			\ move filename into

		SEARCH-NEXT
	REPEAT
	R> DROP ;


2 0 IN/OUT
: PICKFILE  ( x y -- )
	HERE DUP >R
	MAKE-FILESMENU
	R@ DOMENU
	R> HERE - ALLOT ;



: LOAD_FRACTAL  ( -- ) 
	BEGIN_DIALOG
	14 0 PICKFILE  
	(LOAD_FRACTAL)
	WIPE_DIALOG
	END_DIALOG  ;


\ find out name of fractal type N
\ 0 1 IN/OUT NEED #FRACTALS
\ 1 2 IN/OUT
\ : FRACTALNAME  ( N -- ADDR CNT )
\	FRACTALNAMES
\	#FRACTALS ROT
\	DO  @  LOOP  
\	CELL +  COUNT  ; 

\ : OTHERFRACTAL  ( -- )
\	BEGIN_DIALOG
\	FRACTALTYPE DUP @ 1+
\	#FRACTALS MOD TUCK <-
\	NOW FRACTALNAME TYPE
\	END_DIALOG ;





7 SECTION
2 0 IN/OUT
: DOTTED_DOT  ( X Y -- )	
	2DUP - 4 AND   ( DOT DENSITY )
	IF 2DUP XDOT THEN  2DROP   ;

: DOTTED_XHVECTOR ( X Y XS -- )	
	0 DO 
		2DUP DOTTED_DOT
		SWAP 1+ SWAP 
	LOOP 2DROP  ;

: DOTTED_XVVECTOR ( X Y YS -- )
	0 DO 
		2DUP DOTTED_DOT
		1+ 
	LOOP 2DROP  ;

: XFRAME,DOTTED ( X Y XS YS -- ) 
	(FRAME) 
	DOTTED_XHVECTOR 
	DOTTED_XVVECTOR 
	DOTTED_XVVECTOR 
	DOTTED_XHVECTOR ;


0 0 IN/OUT
: PUT_BOX ( -- ) 
	XHOME' @ YHOME' @
	XSIZE' @ YSIZE' @ 
	MOVE/RESIZE @ 
	IF  
		XFRAME,DOTTED  
	ELSE  
		XFRAME  
	THEN   ;




: MATCH  ( ADDR ADDR CNT -- F )
	COMPARE ?DUP NIP  ;

: ZOOM_BOX ( -- )
	FOCUSDATA ZOOMDATA
	2DUP BOXDATASIZE MATCH
	IF DROP UNZOOMDATA THEN
	SWAP BOXDATASIZE CMOVE  ;


2 0 IN/OUT
: REDUCE_BOX  ( ADDR MIN -- )
	OVER @		
	STEPSIZE - 	
	MAX <-  ;

2 0 IN/OUT
: EXTEND_BOX  ( ADDR MIN -- )
	OVER @		
	STEPSIZE + 	
	MIN <-  ;

: BOX_XSMALLER 		XSIZE' 2 REDUCE_BOX  ;
: BOX_YSMALLER		YSIZE' 2 REDUCE_BOX  ;
: BOX_UP		YHOME' 0 REDUCE_BOX  ;
: BOX_LEFT		XHOME' 0 REDUCE_BOX  ;

: BOX_DOWN	YHOME' 	YRES 1- YSIZE' @ - EXTEND_BOX ;
: BOX_RIGHT	XHOME'	XRES 1- XSIZE' @ - EXTEND_BOX ;
: BOX_XBIGGER	XSIZE'	XRES 1- XHOME' @ - EXTEND_BOX ;
: BOX_YBIGGER	YSIZE'	YRES 1- YHOME' @ - EXTEND_BOX ;

: SHRINK_BOX	
	STEPSIZE	 	BOX_YSMALLER BOX_RIGHT
	DUP 2* EQU STEPSIZE 	BOX_XSMALLER
	DUP 2/ EQU STEPSIZE	BOX_DOWN
	EQU STEPSIZE  ;

: GROW_BOX
	STEPSIZE	 	BOX_YBIGGER BOX_LEFT
	DUP 2* EQU STEPSIZE 	BOX_XBIGGER
	DUP 2/ EQU STEPSIZE	BOX_UP
	EQU STEPSIZE  ;

: BOX_LEFT_UP   BOX_LEFT BOX_UP  ;
: BOX_RIGHT_UP  BOX_RIGHT BOX_UP ;
: BOX_LEFT_DOWN BOX_LEFT BOX_DOWN ;
: BOX_RIGHT_DOWN BOX_RIGHT BOX_DOWN ;


CREATE-LOOKUP BOXKEYS
	ASCII 7 ,	' BOX_LEFT_UP ,
	ASCII 8 ,	' BOX_UP ,
	ASCII 9 ,	' BOX_RIGHT_UP ,
	ASCII 1 ,	' BOX_LEFT_DOWN ,
	ASCII 2 ,	' BOX_DOWN ,
	ASCII 3 ,	' BOX_RIGHT_DOWN ,
	ASCII 6 ,	' BOX_RIGHT ,
	ASCII 4 ,	' BOX_LEFT ,
	ASCII + ,	' GROW_BOX ,
	ASCII - ,	' SHRINK_BOX ,
	ASCII * ,	' ZOOM_BOX ,
END-LOOKUP






8 SECTION

0 0 IN/OUT
: EDIT_BOX  ( -- )
	BEGIN  WAIT XKEY 
	DUP ENTER <>
	WHILE 
		BOXKEYS LOOKUP
		?DUP IF PUT_BOX EXECUTE PUT_BOX THEN
	REPEAT 
	DROP  ;

1 0 IN/OUT
: USEBOX ( ADDR -- )
	FOCUSDATA BOXDATASIZE CMOVE  ;

1 0 IN/OUT
: USEDBOX ( ADDR -- )
	FOCUSDATA SWAP BOXDATASIZE CMOVE  ;

0 0 IN/OUT
: MAGNIFYBOX ( -- )
	MOVE/RESIZE OFF
	MAGNIFYDATA USEBOX  ;

0 0 IN/OUT
: ARRANGEBOX ( -- )
	MOVE/RESIZE ON
	ARRANGEDATA USEBOX  ;

: NEWBOX ( ADDR ADDR FADDR -- )
	>R @ SWAP @ th  
	R@ F@ F* R> F!	;

0 0 IN/OUT
: ARRANGED ( -- )
	XSIZE' XSIZE FXRANGE NEWBOX
	YSIZE' YSIZE FYRANGE NEWBOX
	ARRANGEDATA USEDBOX  ;

0 0 IN/OUT
: MAGNIFIED ( -- )
	XHOME' @ >X    FX1 F!
	YHOME' @ >Y    FY1 F!
	XSIZE XSIZE' FXRANGE NEWBOX
	YSIZE YSIZE' FYRANGE NEWBOX
	MAGNIFYDATA USEDBOX  ;




: MAGNIFY ( -- )
	BEGIN_DIALOG  ." pick, using numeric keypad"
	ARRANGEBOX PUT_BOX  
	FOCUSDATA MAGNIFYDATA BOXDATASIZE CMOVE
	MAGNIFYBOX PUT_BOX
	EDIT_BOX
	MAGNIFIED PUT_BOX
	DIALOG ." place, using numeric keypad"
	ARRANGEBOX 
	EDIT_BOX
	ARRANGED PUT_BOX
	WIPE_DIALOG
	END_DIALOG 
	QUITMENU  ;

: ARRANGE ( -- )   MAGNIFY  ;


DECIMAL
: BIGGER_STEPS  ( -- )
	32 DUP EQU STEPSIZE INFORM  ;

: MEDIUM_STEPS  ( -- )
	8 DUP EQU STEPSIZE INFORM  ;

: SMALLER_STEPS ( -- )
	2 DUP EQU STEPSIZE INFORM  ;



0 0 IN/OUT
: MENU_MODIFIED ( -- )   
	MENUCHANGE POP DROP   
	TRUE MENUCHANGE PUSH  ;


: +BOXSET    9 OTHERBOXSET  MENU_MODIFIED  ;
: -BOXSET   -9 OTHERBOXSET  MENU_MODIFIED  ;






9 SECTION

DECIMAL

: BEGIN_HELP   ( -- X Y X Y N N )
	?XY 2SWAP
	2DUP !XY XY>ADDR 
	0 0   ;

: END_HELP ( X Y X Y N N -- )
	XY>ADDR 
	ZANY_FRAMY
	!XY  ;


: MAINHELP ( -- )
	6 17 BEGIN_HELP
	"  Menu system uses all four cursor keys. " TELL
	"  Select DRAW or quit menus to draw (or  " TELL
	"  re-draw) the current fractal. Select   " TELL
	"   DISC then LOAD to view ORB files or   " TELL
	"      type ORBIC FILENAME on entry.      " TELL
	END_HELP  ;

: SETUPHELP ( -- )
	38 2 BEGIN_HELP
	"   Use numeric keypad keys 1-9 + - X and ENTER before  " TELL
	"    or after drawing to move, size and set the pick    " TELL
	"    and place boxes. Start in the pick box with the    " TELL
	"  minus key. No checking is done to ensure that values " TELL
	"   set with the boxes correspond to a visible fractal. " TELL
	END_HELP  ;

: LTDHELP ( -- )
	6 17 BEGIN_HELP
	"  Drawing is currently suspended at  " TELL
	"  the end of a line. Limited options " TELL
	"   available. (To maximize drawing   " TELL
	"  speed a key-press is only checked- " TELL
	"      for at the end of a line).     " TELL
	END_HELP  ;

: 8087HELP ( -- )
	56 8 BEGIN_HELP
	"  Floating point emulation is 48 bit, " TELL
	"  with an 8087 fitted it's 64 bit in  " TELL
	"  hardware. Drawing is on average 7x  " TELL
	"    faster with an 8087 installed.    " TELL
	END_HELP  ;

: CHANGEHELP ( -- )
	29 8 BEGIN_HELP
	"  Internal gubbins of  " TELL
	"  Orbic. Varying line- " TELL
	"  skip can give weird  " TELL
	"    sound effects.     " TELL
	END_HELP  ;

: DEPTHHELP ( -- )
	53 18 BEGIN_HELP
	"  Iteration depth limit. Detail at the  " TELL
	"  expense of speed, esp. in 'sea' which " TELL
	"  appears black if even, white if odd.  " TELL
	"   High for deep zooms, low for draft.  " TELL
	END_HELP  ;

: SNAPHELP ( -- )
	19 13 BEGIN_HELP
	"  SNAP relates to the number  " TELL
	"  of pixels a box (or cursor) " TELL
	"  moves for every key-press.  " TELL
	END_HELP  ;

: SOUNDHELP ( -- )
	54 13 BEGIN_HELP
	"  Orbic translates colour information " TELL
	"   into pitch. WOBBLY inverts pitch,  " TELL
	"   OFF stops transmission to Codec.   " TELL
	"  Use ALT-LTRL, ALT-SCROL for volume. " TELL
	END_HELP  ;


MENU (CHANGEMENU)
        ' +BOXSET		ITEM" next box type"
	' -BOXSET		ITEM" prev box type"  
	' +LINESKIP		ITEM"  lineskip up"
	' -LINESKIP		ITEM" lineskip down"
	' STATUSLINE		ITEM"  statusline"
	' CHANGEHELP     	ITEM"     help"
ENDMENU

: CHANGEMENU ( -- )   
	10 3  (CHANGEMENU)  ;



MENU (SOUNDMENU)
	' SOUND_ON		ITEM" normal"
	' SOUND_INVERT		ITEM" wobbly"
	' SOUND_OFF		ITEM"  off"
	' SOUNDHELP     	ITEM"  help"
ENDMENU

: SOUNDMENU ( -- )   
	10 3  (SOUNDMENU)  ;




MENU (FILESMENU)
	' LOAD_FRACTAL		ITEM" load"
        ' SAVE_FRACTAL		ITEM" save"   
ENDMENU

: FILESMENU    ( -- )   
	10 3  (FILESMENU)   ;


MENU (DEPTHMENU)
	' 40ITERATIONS		ITEM"  40"
	' 70ITERATIONS		ITEM"   70"
	' 100ITERATIONS		ITEM" 100"
	' 400ITERATIONS		ITEM"  400"
	' 1000ITERATIONS	ITEM" 1000"
	' XITERATIONS		ITEM"  xor"
	' +ITERATIONS		ITEM"   +"
	' DEPTHHELP     	ITEM" help"
ENDMENU

: DEPTHMENU    ( -- )   
	16 2  (DEPTHMENU)   ;


MENU (SNAPMENU)
	' SMALLER_STEPS		ITEM"  fine"
	' MEDIUM_STEPS  	ITEM" medium"
	' BIGGER_STEPS  	ITEM" coarse"
	' SNAPHELP	     	ITEM"  help"
ENDMENU

: SNAPMENU ( -- )   
	15 2  (SNAPMENU)  ;




MENU (SETUPMENU)
	' ARRANGE 		ITEM"   go"
	' DEPTHMENU		ITEM"  depth"
	' SNAPMENU		ITEM"  snap"
	' SETUPHELP     	ITEM"  help"
ENDMENU

: SETUPMENU  ( -- )    
	10 3  (SETUPMENU)  ;


MENU (8087MENU)
	' 8087_ON 		ITEM"  on"
	' 8087_OFF		ITEM"  off"
	' 8087HELP		ITEM" help"
ENDMENU

: 8087MENU  ( -- )    
	10 3  (8087MENU)  ;




MENU (MAINMENU)
	' QUITMENU	ITEM"  draw" 
	' FILESMENU	ITEM"  disc"
	' SETUPMENU	ITEM"  ready" ( boxes, iterations )
	' SOUNDMENU	ITEM" sound" ( sound )
	' 8087MENU	ITEM"  8087"
	' CHANGEMENU	ITEM" change" ( lineskip, boxtype, statusline )
\	' GDUMP		ITEM"  epson"
	' MAINHELP	ITEM"  help"
\	' OTHERFRACTAL  ITEM" fractal"
	' QUITPROG	ITEM"  exit"
ENDMENU



MENU (LIMITEDMENU)         
	' QUITMENU	ITEM"  draw"
	' DEPTHMENU	ITEM" depth"
	' SAVE_FRACTAL	ITEM"  save"
	' SOUNDMENU	ITEM" sound" 
	' 8087MENU	ITEM"  8087"
	' CHANGEMENU	ITEM" change" ( lineskip, boxtype, statusline )
\	' GDUMP		ITEM" epson"
	' LTDHELP	ITEM"  help"
ENDMENU


0 0 IN/OUT
: LIMITEDMENU  ( -- )
	SAVE_VIDEO
	5 5 (LIMITEDMENU)
	WIPE_DIALOG
	RESTORE_VIDEO  ;


: MAINMENU   ( -- passes true | false )   ( false: QUIT )

	nPASSES OFF		( default redraw to whole fractal )

	CONTINUE? DUP ON
	SAVE_VIDEO	\ *******
	5 5 (MAINMENU)
	WIPE_DIALOG
	RESTORE_VIDEO 
	@  DUP IF nPASSES @ SWAP THEN   ;



: REPLY1   QUITMENU  CONTINUE_FRACTAL REPLY !   ;
: REPLY2   QUITMENU  SUSPEND_FRACTAL REPLY !   ;
: REPLY3   QUITMENU  ABORT_FRACTAL REPLY !   ;

MENU (INTMENU)
	' REPLY1		ITEM" draw"
	' REPLY2		ITEM" hold"
	' REPLY3		ITEM" abort"
ENDMENU

DECIMAL
0 1 IN/OUT
: INTMENU ( -- F ) 
	CONTINUE_FRACTAL REPLY !
	10 3  (INTMENU)    REPLY @   ;






: WHAT'S_ON?  ( N PASS LINE -- N ) 
	INTERRUPTED_AT_LINE !
	INTERRUPTED_AT_PASS !
	INTERRUPTED_AT_PIXEL !
	QUIET
	SAVE_VIDEO
	FLUSH_KB
	INTMENU  >R
	RESTORE_VIDEO
	DROP R@ ABORT_FRACTAL =
	R> SUSPEND_FRACTAL = 
	IF  LIMITEDMENU THEN ;


\  n=0: draw all passes
\  n=lineskip: return immediately
\  0<n<lineskip:
\

: MANDELBROT ( n -- )   \  n: pass number to start with
	FALSE
	LINESKIP ROT ?DO
		YHOME @ YSIZE @ RANGE
		DO				\ WAITING
			I >Y
			XHOME @ XSIZE @ RANGE J +	
			DO
				I >X
				FOVER
				MANDEL(X,Y)
				SOUND-TYPE @ 
					?DUP IF 
					OVER WHATSOUND THEN 
				#COLORS 1- AND I J  !DOT
			LINESKIP +LOOP
			FDROP
			?TERMINAL IF  0 I J WHAT'S_ON?  THEN
			DUP IF LEAVE THEN 
		LOOP
		DUP IF LEAVE THEN
	LOOP DROP
	INTERRUPTED_AT_LINE OFF  \ 2nd-inner loop 
	INTERRUPTED_AT_PASS OFF  \ outer loop
	INTERRUPTED_AT_PIXEL OFF \ innermost loop 
	QUIET  ;



\ : WIPE_WINDOW_QUICK ( -- )
\	YHOME @ YSIZE @ RANGE
\	DO
\		XHOME @ XSIZE @ RANGE
\		DO   I J -DOT   LOOP
\	LOOP  ;



\ : WIPE_WINDOW ( -- )
\	FALSE
\	LINESKIP 0 DO
\		YHOME @ YSIZE @ RANGE
\		DO
\			XHOME @ XSIZE @ RANGE J +	
\			DO
\				I J -DOT
\			LINESKIP +LOOP
\			?TERMINAL IF  0 I J WHAT'S_ON?  THEN
\			DUP IF LEAVE THEN 
\		LOOP
\		DUP IF LEAVE THEN
\	LOOP DROP ;



DECIMAL


\ TABLE FRACTALCODE       \ execution addresses of fractal types
\  ' MANDELBROT ,    stack effect of MANDELBROT has been changed 
\  ' WIPE_WINDOW_QUICK ,
\  ' WIPE_WINDOW ,
\ no code in between here please
\
\ CREATE  KNOWN_FRACTALS  \ linked list containing fractal type names
\ ADD_FRACTAL Mandelbrot
\ ADD_FRACTAL QuickWiper
\ ADD_FRACTAL WindowWiper





\ find out the number of installed fractal types
\ 0 1 IN/OUT
\ : #FRACTALS  ( -- N )
\	KNOWN_FRACTALS  
\	['] FRACTALCODE - 2/  ;


\ generate fractal of type FRACTALTYPE
\ 0 0 IN/OUT
\ : GENERATE_FRACTAL ( -- )
\	FRACTALTYPE @
\	FRACTALCODE EXECUTE ;





DECIMAL
: MAIN
	128 SET-DTA	
	SETUP-VID 				\ DIAGNOSE
	SOUND-INIT
	8087?  EQU 8087_PRESENT
	DEFAULT_PARAMETERS

	SAVE_VIDEO
	1STPAR READ$  
	DUP IF  
		2DUP FRACTALNAME  (LOAD_FRACTAL)
	ELSE
		WELCOME
	THEN  	2DROP DROP
	RESTORE_VIDEO


	BEGIN       
		MAINMENU    ( npasses true | false )
	WHILE     
\		GENERATE_FRACTAL
		MANDELBROT
	REPEAT


	DEPTH 1- ?DUP 	
	IF
		BEGIN_DIALOG 
		REVERSE STACK-ERROR .  WAIT
		END_DIALOG  
	THEN
	UNSETUP-VID
	0 0 DO LOOP   ;


 


\ HEX
\ U: DIAGNOSE  ( -- )
\	F000 0    ?CS: HERE     
\	[DECIMAL] 16 16 * CELL *   
\	CMOVEL
\
\	TXT
\	" first 256 pointers:"  COUNT DOS-TYPE
\
\	DOS-CR
\	HERE
\	16 0 DO   
\	  16 0 DO
\	    DUP @  HEX ADDR DOS-TYPE  BL DOS-EMIT  2+
\	  LOOP
\	LOOP  DROP
\
\	DOS-CR
\	GRAFSEG              " VIDEO PAGE FOUND AT PARAGRAPH "  DOS-REPORT
\	GRAFSEG 2500 +       " THAT'S UP TO (EXCL) PARAGRAPH "  DOS-REPORT 
\	?CS:                 " ORBIC  RESIDES  IN  PARAGRAPH "  DOS-REPORT
\	?CS: 4096 2500 + +   " USING MEMORY UP TO  PARAGRAPH "  DOS-REPORT
\	XKEY DROP  GRAF	;


\ U: DOS-REPORT  ( N $ -- )
\	DOS-CR
\	COUNT DOS-TYPE
\	HEX ADDR DOS-TYPE
\	ASCII h DOS-EMIT ;

\ U: ADDR  ( N -- ADDR CNT )
\	0 <# # # # # #> ;

\ HEX
\ U: DOS-CR   0D DOS-EMIT  0A DOS-EMIT  ;



INCLUDE FORTHLIB
NOMAP
END
