\ CFORTH LIBRARY : EMS INTERFACE
\
\
\ EMS            ( -- F )         test EMS available, init
\ ?EMS           ( -- F )         is EMS available ? must check. Done by EMS
\ EMS-STATUS     ( -- N )         return EMS status of most recent request
\ EMS-STATUS?    ( -- )           ask EMS for status
\ EMS-PAGE-FRAME ( -- ADDR )  *   where find we data ?
\ EMS-PAGE       ( -- ADDR )  *   where find we data ( EQU )
\ EMS-AVAILABLE  ( -- PAGES ) *   #pages remaining for allocation
\ EMS-ALLOC      ( PAGES -- HANDLE  ) *   ALLOCATE n PAGES
\ EMS-MAP        ( LOG PHYS HAND -- ) *
\ EMS-DEALLOC    ( HANDLE -- ) *  RELEASE HANDLE
\ EMS-VERSION    ( -- N )      *  Bits 7...4 Version, 3...0 Subversion
\ * : function returns EMS status.

HEX
04000 CONSTANT BYTES/FRAME
HERE EQU EMS-PAGE

\ test the expanded memory system to see if it is present.  This MUST be
\ successful BEFORE any other expanded memory operations may done.

{{

CREATE EMSNAME ," EMMXXXX0"


CODE ?EMS   ( --- F )           \ true  = EMS is present
                                \ false = no EMS present
    HEX   35 # AH MOV
          67 # AL MOV         ( get interrupt vector to EMS driver )
          21 INT
          0A # DI MOV             ( ES:DI gottaB EMMXXXX0 )

          EMSNAME # SI  MOV       ( DS:SI )
          8 # CX MOV
          REPE   BYTE CMPS               ( STRING COMPARE )

          SI POP
          =0 IF,
                TRUE # AX MOV      AX PUSH     SI JMPI
            ELSE,
               FALSE # AX MOV      AX PUSH     SI JMPI
            THEN,
    END-CODE




HERE EQU EMS-STATUS    \ tricky

\ Get status of the expanded memory system
HEX
CODE EMS-STATUS? ( -- )
                SI POP
                40 #  AH MOV       \ REQUEST STATUS CODE
                67 INT

L: (EMS-STATUS) AH AL MOV          \ AH = STATUS OF EMS
                AH AH XOR
                AX EMS-STATUS [] MOV  \ here is the trick
                SI JMPI
END-CODE




\ emm status codes :
\        0  there is no problem.
\       80  serious emm software problem.
\       81  serious emm hardware problem.
\       82  the emm system is busy.
\       83  emm can't find the handle specified.
\       84  invalid function code passed to emm.
\       85  no handles are currently available.
\       86  a mapping context restoration error detected.
\    87|88  requested pages exceeds available pages.
\       89  could not allocate any pages.
\       8A  logical page to map is not in allocated range.
\       8B  physical page specified is not valid.
\       8C  the mapping context save area is full.
\       8D  attempt to save context of already saved handle.
\       8E  attempt to restore context without saving first.
\       8F  subfunction passed is not defined.







CODE EMS-PAGE-FRAME ( --- ADDR )
                SI POP
                41 # AH MOV
                67 INT
                BX PUSH
                (EMS-STATUS) JMP
END-CODE




\ return the number of 16k pages that are available for allocation

CODE EMS-AVAILABLE     ( --- PAGES )
                SI POP
                42 # AH MOV
                67 INT
                BX PUSH                 \ unallocated pages dx
                (EMS-STATUS) JMP
                END-CODE




CODE EMS-TOTAL    ( --- PAGES )
                SI POP
                42 # AH MOV
                67 INT
                DX PUSH                    \ dx = total pag
                (EMS-STATUS) JMP
                END-CODE




\ Allocates the number of pages you specify, and returns a handle to the
\ pages if successful.

CODE EMS-ALLOC       ( PAGES --- HANDLE )
		SI POP
		BX POP			\ number of pages to allocate
		43 # AH MOV		\ allocate pages function
		67 INT
		DX PUSH
                (EMS-STATUS) JMP
		END-CODE		\ in the range 1 to 255




CODE EMS-MAP  ( log-page phy-page handle --- )
		SI POP
		DX POP		       \ emm handle
		AX POP		       \ physical page
		BX POP		       \ logical page
                44 # AH  MOV           \ map pages function
		67 INT
                (EMS-STATUS) JMP
		END-CODE


CODE EMS-DEALLOC ( HANDLE --- )
		SI POP
                DX POP                  \ emm handle
		45 # AH MOV		\ deallocate pages function
		67 INT
                (EMS-STATUS) JMP
		END-CODE



CODE EMS-VERSION ( --- VERSION )
    SI POP
    46 # AH MOV
    67 INT
    DX DX XOR
    AL DL MOV
    DX PUSH
    (EMS-STATUS) JMP
    END-CODE


: EMS  ( -- F )
    ?EMS  DUP  IF    ( FOUND  DRIVER )
     EMS-PAGE-FRAME EQU EMS-PAGE
        ( EMS SEGMENT + STATUS )
     EXIT THEN     ;


0 EQU EMS-STATUS    \ resolve trickyness
0 EQU EMS-PAGE

DECIMAL
}} #IF CR .( EMS Interface                             ) LIBSTATS  #THEN
