
FORTH   DECIMAL

DEPTH 1 = #IF
}}  #IF CR .( MAIN program                              )  LIBSTATS #THEN #ELSE
CR .( )
CR .(  MAIN: STACK IS NOT BALANCED )
CR .( )
NOMAP END  #THEN


FIND FORTHLIB  #IF  DROP      CR CR
CR .( ͸)
CR .(     2nd inclusion      FORTHLIB.4TH        2nd inclusion ۳)
CR .( ͸͵) #ELSE
                       CREATE FORTHLIB
CR .( ͵)
CR .(                        FORTHLIB.4TH                          )
CR .( ͵) #THEN


\ ------------------------------------------------------------------------
{{
\                pick out library modules by keyword
\


UNDEF REPORT-ERROR                      INCLUDE       ERR.LIB  #THEN
FIND  MENUS     #IF  DROP               INCLUDE     MENUS.LIB  #THEN
FIND  DOSINT    #IF  DROP               INCLUDE    DOSINT.LIB  #THEN
FIND  SFP       #IF  DROP               INCLUDE       SFP.LIB  #THEN
FIND  NPU8087   #IF  DROP		INCLUDE   NPU8087.LIB  #THEN

FIND  SOUND     #IF  DROP               INCLUDE     SOUND.LIB  #THEN
FIND  STRINGS   #IF  DROP               INCLUDE   STRINGS.LIB  #THEN

UNDEF #IN                               INCLUDE    NUM-IN.LIB  #THEN
UNDEF NUMBER?                           INCLUDE    NUMBER.LIB  #THEN
UNDEF CONVERT                           INCLUDE   CONVERT.LIB  #THEN
UNDEF WORD                              INCLUDE      WORD.LIB  #THEN
UNDEF Y/N                               INCLUDE        YN.LIB  #THEN
UNDEF SHELL                             INCLUDE     SHELL.LIB  #THEN

UNDEF ISIN  1 1 IN/OUT  REQUIRE SIN  #THEN
UNDEF ICOS  1 1 IN/OUT  REQUIRE COS  #THEN
UNDEF  COS  1 1 IN/OUT  REQUIRE SIN  #THEN
UNDEF  SIN                              INCLUDE      TRIG.LIB  #THEN

?DEFINE PUSH
?DEFINE POP        EITHER #IF           INCLUDE     STACK.LIB  #THEN
?DEFINE TICKS
?DEFINE STOPWATCH  EITHER #IF           INCLUDE      TIME.LIB  #THEN

INCLUDE HARDWARE.LIB

\ ------------------------------------------------------------------------


{{        ( command line parameters )
                                                                        HEX

( WON'T READ OVER END OF LINE )
U: READ$     ( ADDR -- ADDR' ADDR CNT )
     -LEADING     DUP SKIPPAR     SWAP 2DUP -  ;

1 2 IN/OUT NEED READ#
U: +-READ#  ( ADDR -- ADDR' N )
       -LEADING     DUP C@
       ASCII - =
       IF
           1+  READ#  NEGATE
      ELSE  READ# THEN  ;


U: READ#     ( ADDR -- ADDR' N )
         -LEADING
         0 BEGIN
               >R COUNT  CAPITALIZE  DIGIT
                BASE @  2DUP U<
           WHILE
              R> * +
           REPEAT     2DROP
           1-  SKIPPAR
           R>    ;

U: READD#    ( ADDR -- ADDR' D )
         -LEADING
         0. BEGIN
              >R >R COUNT CAPITALIZE  DIGIT
              BASE @  2DUP U<
            WHILE
               R> R>
               ROT T* DROP
               ROT 0 D+
            REPEAT     2DROP
            1- SKIPPAR
            R> R>   ;

U: #PARAMETERS ( ADDR -- N )
           0 SWAP
           BEGIN   -LEADING
                   DUP  SKIPPAR
                   TUCK -
           WHILE
                   SWAP 1+ SWAP
           REPEAT
           DROP   ;


( ADDR -- ADDR )
UNDEF -LEADING
CODE -LEADING
       AX BX XCHG
       BEGIN,
       020 # [BX] BYTE CMP
        =0 WHILE,
         BX INC
        REPEAT,
        AX BX XCHG
        RET
END-CODE
#THEN

UNDEF SKIPPAR
( ADDR -- ADDR' )
CODE SKIPPAR
       AX BX XCHG
       BEGIN,
       020 # [BX] BYTE CMP
        >U WHILE,
         BX INC
        REPEAT,
        AX BX XCHG
        RET
END-CODE
#THEN


}}  #IF CR .( command line parameters                   ) LIBSTATS  #THEN




\ ------------------------------------------------------------------------
\
\                            character conversion
\
{{                                                                      DECIMAL
UNDEF ALPHANUMERIC
1 1 IN/OUT  NEED ALPHABETIC        1 1 IN/OUT  NEED NUMERIC
: ALPHANUMERIC  ( ASC -- F ) DUP NUMERIC  SWAP ALPHABETIC  OR  ;  #THEN

UNDEF NUMERIC               1 1 IN/OUT   NEED DIGIT   #THEN
FIND USER  #IF DROP
U: NUMERIC  ( ASC -- F )      DIGIT LOCALBASE @ U<  ;        #THEN
U: NUMERIC  ( ASC -- F )      DIGIT BASE @ U<  ;

UNDEF ALPHABETIC
 1 1 IN/OUT   NEED CAPITAL       1 1 IN/OUT   NEED SMALL-LETTER
: ALPHABETIC ( ASC -- F )    DUP SMALL-LETTER SWAP CAPITAL OR ;   #THEN

\ convert all small chars in a string to capitals
U: $CAPITALIZE ( ADDR CNT -- )   0 ?DO DUP DUP C@ CAPITALIZE C<- 1+ LOOP DROP ;

UNDEF CAPITALIZE                    1 1 IN/OUT   NEED SMALL-LETTER
: CAPITALIZE ( ASC -- ASC )      DUP SMALL-LETTER IF  95 AND  THEN  ; #THEN


U: CAPITAL  ( ASC -- F )          ASCII A  ASCII Z WITHIN  ;
U: SMALL-LETTER  ( ASC -- F )     ASCII a  ASCII z WITHIN  ;
U: PRINTABLE  ( ASC -- F )        BL 127 WITHIN   ;     #THEN
U: WITHIN   ( N LO HI -- F )      >R OVER U>  SWAP  R>  U> OR  NOT   ;
U: DIGIT    ( ASC -- N )          ASCII 0 -   DUP 9 U> IF  7 - THEN  ;



}}  #IF CR .( character conversion                      )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{
        U: #BITS   ( N -- N )
         0   BEGIN SWAP ?DUP   WHILE  DUP 1- AND SWAP 1+  REPEAT  ;

        U: CELLS    ( N -- N )   2*  ;

        U: .S  ( -- )        DEPTH  0  ?DO  I PICK U.  LOOP  ;

DECIMAL
        \ LONG ADDRESS INTO  SEGM OFFS. OFFSET GUARANTEED 0...F
        U: LONG>SEG  ( D -- Seg Offs )               16 UM/MOD  SWAP  ;
        U: SEG>LONG  ( Seg Offs -- 20bitaddress )  0 ROT  16 UM*  D+  ;


}}  #IF CR .( #BITS CELLS  .S  SEG>LONG LONG>SEG        )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

INCLUDE NUMBERS.LIB

\ ------------------------------------------------------------------------
                                                                       HEX
{{
FIND USER
#IF  DROP
    U: HEX     10 LOCALBASE ! ;
    U: DECIMAL 0A LOCALBASE ! ;
    U: BINARY  02 LOCALBASE ! ;
    U: OCTAL   08 LOCALBASE ! ;
#ELSE
    PRIMITIVE U: HEX     10 BASE ! ;
    PRIMITIVE U: DECIMAL 0A BASE ! ;
    PRIMITIVE U: BINARY  02 BASE ! ;
    PRIMITIVE U: OCTAL   08 BASE ! ;
#THEN

}} #IF  CR .( radix switch                              )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

\ ADDR is the start of a table with the format
\   0,1    16bit  number of table entries
\   2,3    16bit  entry id
\   4,5    16bit  entry response if matching id
\  [2-5] form one entry which is repeated [0-1] times


{{
U: LOOKUP   ( N ADDR -- N | 0 )
      SKIM 0 ?DO
        2DUP @ = IF  NIP 2+ @ 0  LEAVE THEN
         2+ 2+  LOOP
      IF DROP 0 THEN  ;

}} #IF  CR .( associative lookup                        )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{                                                                      DECIMAL

\ Ŀ
\  TRIPLE LENGTH + MIXED MODE 
\ 
\
\      UM/MOD   ( D N -- R Q )
\      UM*      ( N N -- D )

        U: UD*/    ( D N N -- D )
              UD*/MOD  ROT  DROP   ;
        U: UD*/MOD ( D N N -- REM D )
           >R T* R> UD/MOD  ;
        U: T*      ( D N -- T )
                ROT OVER  UM*  2SWAP  UM*  0  -ROT  D+   ;
        U: UD/MOD  ( T N -- R D )
              DUP >R   UM/MOD  R>  SWAP >R  UM/MOD R>   ;
        U: M+!     ( N ADDR -- )
              >R S>D R@  2@  D+  R>  2!  ;
        U: D+!     ( D ADDR -- )
              DUP >R     2@  D+  R>  2!  ;
        U: *PI      ( N -- N*PI )
             355 113 */  ;

}} #IF  CR .( triple length arithmetic                  )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

INCLUDE DMATH.LIB

\ ------------------------------------------------------------------------

{{
\ Ŀ
\  SINGLE MATH 
\ 
UNDEF U2/   CODE U2/   ( N -- N )
   SI POP   AX POP   AX 1 SHR   AX PUSH    SI JMPI   END-CODE  #THEN
UNDEF C>S   CODE C>S    ( 8 to 16 BIT SIGN EXTENSION )
   SI POP   AX POP  CBW  AX PUSH   SI  JMPI    END-CODE  #THEN


}} #IF  CR .( single length arithmetic                  )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

UNDEF <#           INCLUDE FORM#.LIB       #THEN
UNDEF -TRAILING    INCLUDE TRAILING.LIB    #THEN

\ ------------------------------------------------------------------------


?DEFINE EXPECT ?DEFINE QUERY EITHER  ?DEFINE IN$   EITHER
 #IF   INCLUDE LINE-IN.LIB   #THEN

\ ------------------------------------------------------------------------


{{
                                                                     HEX


U: ?KEY        ?TERMINAL DUP  IF DROP KEY THEN      ;


UNDEF XKEY
FIND EXTENDED-KEY #IF DROP #ELSE  0 CONSTANT EXTENDED-KEY #THEN
: XKEY  ( -- N )
	       BEGIN ?TERMINAL UNTIL
	       KEY DUP EXTENDED-KEY = 
		?TERMINAL AND IF
               DROP KEY FF00 OR  THEN  ;
#THEN


UNDEF ATKEY
CR .( ----- obsolete use of ATKEY. Using XKEY instead -----)
: ATKEY       XKEY   ;
#THEN


FIND PAUSE  #IF  DROP
U: KEY         BEGIN ?TERMINAL UNTIL  00 08 BDOS   ;
U: ?TERMINAL   00 0B BDOS  0<> ;

#ELSE
U: KEY         00 08 BDOS ;
U: ?TERMINAL   00 0B BDOS  0<> ;
#THEN


                                                                      HEX
1 1 IN/OUT NEED SHIFTKEY
U: ?RSHIFT     1 SHIFTKEY  ;
U: ?LSHIFT     2 SHIFTKEY  ;
U: ?SHIFT      3 SHIFTKEY  ;
U: ?CTRL       4 SHIFTKEY  ;
U: ?ALT        8 SHIFTKEY  ;
U: ?LCTRL    100 SHIFTKEY  ;
U: ?LALT     200 SHIFTKEY  ;

FIND PAUSE  #IF DROP
U: SHIFTKEY   PAUSE   0 0417  @L  AND  0<>   ;    #ELSE
U: SHIFTKEY           0 0417  @L  AND  0<>   ;    #THEN



}} #IF  CR .( keyboard                                  )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{

\ UNDEF FRAME     ( ascii based )         INCLUDE     FRAME.LIB  #THEN
\ UNDEF BOX       ( ascii based )         INCLUDE       BOX.LIB  #THEN

U: SPACES       DUP 0>  IF 0 DO SPACE LOOP EXIT THEN DROP  ;
U: SPACE        BL EMIT ;
U: EMITS ( ASCII N -- )     0 ?DO DUP EMIT LOOP DROP ;


U: TYPEZ ( ADDR -- )
        DUP    BEGIN COUNT
        0= UNTIL 1-
        OVER - TYPE  ;

}} #IF  CR .( console output related                    )  LIBSTATS #THEN



\ -------------------------------------------------------------------

         (  Character Output,  pick the good screen driver. )


( may be some space for optimizing )                                    HEX
UNDEF CS:TYPE   2 0 IN/OUT NEED TYPE   : CS:TYPE  TYPE   ; #THEN

TRUE  ( assume DOS )
FIND  WINDOWS     #IF 2DROP  FALSE      INCLUDE   WINDOWS.DRV  #THEN
FIND  IBMMINI     #IF 2DROP  FALSE      INCLUDE   IBMMINI.DRV  #THEN
FIND  IBM         #IF 2DROP  FALSE      INCLUDE       IBM.DRV  #THEN
FIND  BIOS        #IF 2DROP  FALSE      INCLUDE      BIOS.DRV  #THEN
FIND  GRAFEMIT    #IF 2DROP  FALSE      INCLUDE  GRAFEMIT.DRV  #THEN


FIND  SIRTEXT     #IF 2DROP  FALSE      INCLUDE   SIRTEXT.DRV  #THEN

FORTH
( having exhausted all resources, we fall back to handle based I/O )
DUP CONSTANT    DOS-VIDEO-OUT   ( some things don't make sense with DOS )

NOT #IF ( DOS ... , )                   INCLUDE    COMMON.DRV  #THEN

\ ------------------------------------------------------------------------

FIND  GRAFIX      #IF  DROP             INCLUDE    GRAFIX.LIB  #THEN
FIND  HERC        #IF  DROP             INCLUDE      HERC.LIB  #THEN
FIND  MCGA        #IF  DROP             INCLUDE      MCGA.LIB  #THEN
FIND  EGA         #IF  DROP             INCLUDE       EGA.LIB  #THEN
FIND  VGA         #IF  DROP             INCLUDE       VGA.LIB  #THEN
FIND  CGA640      #IF  DROP             INCLUDE    CGA640.LIB  #THEN
FIND  CGA320      #IF  DROP             INCLUDE    CGA320.LIB  #THEN
FIND  HERCULES    #IF  DROP             INCLUDE  HERCULES.LIB  #THEN
FIND  CHARGRAF    #IF  DROP             INCLUDE  CHARGRAF.LIB  #THEN
FIND  SIRIUS      #IF  DROP             INCLUDE    SIRIUS.LIB  #THEN

\ ------------------------------------------------------------------------

UNDEF DDA                               INCLUDE       DDA.LIB  #THEN
UNDEF MDDA                              INCLUDE      MDDA.LIB  #THEN

DECIMAL
U: CR  13 EMIT 10 EMIT  ;


DOS-VIDEO-OUT
     ?DEFINE DOS-EMIT  OR   
     ?DEFINE DOS-TYPE  OR 
#IF                   INCLUDE   DOSEMIT.DRV  #THEN


DOS-VIDEO-OUT NOT #IF
	FIND SETUP-VID    
	#IF DROP #ELSE        
	REQUIRE OMISSION:SETUP-VID 
	#THEN
#THEN


\ ------------------------------------------------------------------------




{{
HEX

\ DETERMINE THE PAGE-ZERO ADDRESS OF THE CURRENTLY ACTIVE DISPLAY ADAPTER
\ FOR DIRECT SCREEN WRITES.   SUPPORTING DESQVIEW

FIND DVAPI   #IF   DROP
U: ADAPTER ( -- ADDR ) B000 0 449 C@L 7 <> IF DROP B800 THEN DV-BUFFER ; #ELSE
U: ADAPTER ( -- ADDR ) B000 0 449 C@L 7 <> IF DROP B800 THEN           ; #THEN


\ NUMBER OF CHARS / ROW  AND COLUMNS, SUPPORTED BY CURRENT SCREEN MODE
U: SCREENSIZE  ( -- COL ROW )    0 044A @L    0 0484 C@L 1+
        DUP 10 U<  ( funny screen ) IF  DROP  19  THEN     ;



\ ------- DESQVIEW SUPPORT ( SETUP-VID USES - VIA ADAPTER - ) --------
FIND  DVAPI     #IF  DROP               INCLUDE     DVAPI.LIB  #THEN


HEX
UNDEF MODE    ( video mode via BIOS )
CODE MODE
        AH AH XOR
        HEX 10  INT
        RET
     END-CODE
#THEN

U: MODE?     ( -- N )
        0 449  C@L   ;





}} #IF  CR .( video I/O                                 )  LIBSTATS #THEN

\ ------------------------------------------------------------------------
{{
U: ERASE    0 FILL  ;
U: BLANK   BL FILL  ;

UNDEF FILL
   CODE FILL  BX POP AX POP CX POP DI POP LOOP IF,
  DX DS <SEG DX ES >SEG REPZ BYTE STOS THEN,
  BX JMPI END-CODE
#THEN


UNDEF LFILL ( SEG OFFS N BYTE -- )
   CODE LFILL
   BX POP
   AX POP
   CX POP
   DI POP
   ES POPSEG
   LOOP IF,
     REPZ BYTE
     STOS
   THEN,
   BX JMPI
   END-CODE
#THEN

UNDEF LFILLW ( SEG OFFS N WORD -- )
   CODE LFILLW
   BX POP
   AX POP
   CX POP
   DI POP
   ES POPSEG
   LOOP IF,
     REPZ
     STOS
   THEN,
   BX JMPI
   END-CODE
#THEN




}} #IF  CR .( block fill                                )  LIBSTATS #THEN

\ ------------------------------------------------------------------------
                                                                        HEX
{{

UNDEF BDOS
CODE BDOS  ( 2 -- 1 )
        FIND PAUSE #IF DROP  CALL' PAUSE #THEN
        AL AH MOV
        BX DX MOV
        21 INT
        AH AH XOR
        RET
END-CODE #THEN



UNDEF BYE
   FIND bye  #IF  DROP   #ELSE
   CODE bye     HEX
       4C00 # AX MOV
        21 INT
    END-CODE    #THEN
   CODE BYE        ' bye JMP

END-CODE  #THEN

UNDEF RETURN   CODE RETURN     AX POP AX POP 4C # AH  MOV  21 INT
END-CODE  #THEN



}} #IF  CR .( DOS process control                       )  LIBSTATS #THEN

\ ---------------------------------------------------------------------

{{

                                                                        HEX
\ brings back location of dos busy flag. Execute once, then use the
\ address brought back by this function to determine with a C@L whether
\ DOS fns may be used right after the memory read.
\ this feature is undocumented is seems to be disfunctional with DOS 4.0x
UNDEF DOS-BUSY-FLAG    \ use INT 28 for same purpose
CODE  DOS-BUSY-FLAG    ( -- SEG ADDR )
     SI POP
     34 # AH MOV
     21 INT
     ES PUSHSEG
     BX PUSH
     SI JMPI
END-CODE
#THEN

UNDEF TSR     ( RETCODE -- )
MEMEND 1-  4 >>  0FFF AND  1+  CONSTANT paragraphs
CODE TSR
      AX POP                   ( waste return address )
      AX POP                   ( RETURN CODE )
      paragraphs # DX MOV      ( SIZE IN PARAGRAPHS )
      31 # AH MOV
      21 INT
      END-CODE
#THEN


UNDEF SET-HANDLER
CODE SET-HANDLER  ( seg offset intnumber -- )
 SI POP AX POP DX POP BX POP 
 DS PUSHSEG BX DS >SEG
 25 # AH MOV  21 INT   ( set interrupt vector call )
 DS POPSEG SI JMPI  END-CODE
#THEN


UNDEF GET-HANDLER
CODE GET-HANDLER ( intnumber -- seg offset )
          35 # AH MOV  21 INT  ( get interrupt vector call )
 BX AX MOV  BX ES <SEG  
 RET  END-CODE
#THEN
}}  #IF CR .( tsr and interrupt support                 ) LIBSTATS  #THEN


\ ------------------------------------------------------------------------
{{

U: SEARCH-ENVIRONMENT  ( addr cnt -- seg addr true | false )
        >R  ?CS: SWAP
        ENVIRONMENT
        BEGIN
           LCOUNT                       ( another string ? )
           IF
              1- 2OVER
              2OVER R@
              COMPAREL      ( TRUE | OFFS 0 )
              DUP >R
              ?DUP 0= IF + THEN
              R>
           ELSE
              FALSE TRUE            ( exit search because of no more strings )
           THEN
        NOT WHILE
           0 ADVANCEL
        REPEAT
        R> DROP  DUP >R
        IF ASCII = ADVANCEL  2SWAP 2DUP   THEN
        2DROP 2DROP R>     ;

U: ENVIRONMENT ( -- SEG ADDR )            [HEX]  02C @ 0  ;
U: ADVANCEL ( SEG ADDR ASC -- SEG ADDR )  >R BEGIN LCOUNT  R@ = UNTIL R> DROP ;

}}  #IF CR .( environment                               )  LIBSTATS  #THEN

\ ------------------------------------------------------------------------

{{
UNDEF CMOVE    CODE CMOVE
    BX POP  CX POP DI POP SI POP
    LOOP IF,
        AX DS     <SEG AX    ES >SEG    REPZ BYTE MOVS
    THEN,
  BX JMPI
END-CODE  #THEN

UNDEF CMOVE>
   CODE CMOVE>
        BX POP         \  return address
        AX POP         \  cnt
        DI POP         \  dest
        SI POP         \  src
        LOOP IF,
           AX CX MOV     AX DEC
           AX SI ADD
           AX DI ADD
           STD
           AX DS <SEG
           AX ES >SEG
           REPZ BYTE MOVS
           CLD
        THEN,
        BX JMPI
    END-CODE
  #THEN


UNDEF CMOVEL
CODE CMOVEL   ( SEG ADDR SEG ADDR N -- )
        BX POP
        CX POP
        DI POP
        ES POPSEG
        SI POP
        AX DS   <SEG
        DS POPSEG

        LOOP IF,
          REPZ BYTE MOVS
        THEN,
        AX DS >SEG
        BX JMPI
END-CODE
#THEN



UNDEF SCAN
\ ADDR COUNT ASCII -- ADDR CNT
\ returns addr,cnt of first occurance of ASCII
CODE SCAN    ( d c a -- n n )
   BX POP
   AX POP
   CX POP
   LOOP IF,
      DI POP
      DX DS <SEG
      DX ES >SEG
      REPNZ BYTE SCAS
      =0 IF,
         CX INC
         DI DEC
      THEN,
      DI PUSH
   THEN,
   CX PUSH
   BX JMPI
   END-CODE
#THEN


UNDEF SCANL
\ SEG ADDR COUNT ASCII -- SEG ADDR CNT
\ returns addr,cnt of first occurance of ASCII
CODE SCANL    ( s addr c a -- s addr c )
   BX POP
   AX POP
   CX POP
   LOOP IF,
     DI POP
     ES POPSEG
     REPNZ BYTE SCAS
     =0 IF,
        CX INC
        DI DEC
     THEN,
     ES PUSHSEG
     DI PUSH
   THEN,
   CX PUSH
   BX JMPI
   END-CODE
#THEN



UNDEF SKIP
CODE SKIP
   BX POP
   AX POP
   CX POP
   LOOP IF,
     DI POP
     DX DS <SEG
     DX ES >SEG
     REPZ BYTE SCAS
     =0 ~ IF,
        CX INC
        DI DEC
     THEN,
     DI PUSH
   THEN,
   CX PUSH
   BX JMPI
END-CODE
#THEN


UNDEF COMPARE
CODE COMPARE    ( addr addr c -- -1 | OFFS 0 )
         BX POP
         CX POP
         DI POP
         SI POP
         LOOP IF,
            CX DX MOV
            DS PUSHSEG
            ES POPSEG
            REPE BYTE CMPS
            =0 ~ IF,
              CX DX SUB
              CX CX XOR
              CX INC
              DX DEC
              DX PUSH
            THEN,
         THEN,
         CX DEC
         CX PUSH
         BX JMPI
END-CODE
#THEN

UNDEF COMPAREL
CODE COMPAREL   ( S O S O C -- -1 | OFFS 0 )
         AX DS <SEG
         BX POP
         CX POP
         DI POP
         ES POPSEG
         SI POP
         DS POPSEG
         LOOP IF,
            CX DX MOV
            REPE BYTE CMPS
            =0 ~ IF,
              CX DX SUB
              CX CX XOR
              CX INC
              DX DEC
              DX PUSH
            THEN,
         THEN,
         CX DEC
         CX PUSH
         AX DS >SEG
         BX JMPI
END-CODE
#THEN

U: LCOUNT  ( SEG ADDR -- SEG ADDR' N )
        1+ 2DUP 1- C@L  ;


}}  #IF CR .( block move, scan, skip, compare           )  LIBSTATS  #THEN

\ ------------------------------------------------------------------------

{{                                                                        HEX
U: ALLOT  DP +! ;
U: HERE  DP @ ;
U: PAD   DP @ 80 + ;

\ return the amount of available memory   ( bytes )
U: FREE   ( -- n )    MEMEND  rssize dssize + -  DP @ -  ;

U: C,  DP @ C! 1 DP +! ;
U: ,   DP @ !  2 DP +! ;



}} #IF  CR .( memory allocation                         )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{

U: 2ROT  5 ROLL 5 ROLL ;
U: PLUCK 2 PICK  ;

U: SKIM  ( ADDR -- ADDR' N )     DUP 2+ SWAP @  ;

UNDEF ROLL
   CODE ROLL
       BX POP
         DI POP
         AX SS <SEG
         AX ES >SEG
         DI CX MOV
         CX INC
         DI 1 SHL
         SP DI ADD
         DI SI MOV
         SI DEC
         SI DEC
         SS: [DI] PUSH
         STD
         CLI
         REPZ MOVS
         STI
         CLD
         SP INC
         SP INC
       BX JMPI
   END-CODE

#THEN

UNDEF 2SWAP
CODE  2SWAP
           SI POP
           AX POP   BX POP   CX POP   DX POP
           BX PUSH  AX PUSH  DX PUSH  CX PUSH
           SI JMPI
END-CODE   #THEN


UNDEF ROL     CODE ROL
      SI POP   AX POP   AX 1 ROL   AX PUSH   SI JMPI
END-CODE     #THEN


UNDEF ROR    CODE ROR
      SI POP   AX POP   AX 1 ROR   AX PUSH   SI JMPI
END-CODE     #THEN


UNDEF DEPTH
   CODE DEPTH  S0 [] AX MOV  SP AX SUB  AX 1 SAR   RET END-CODE
#THEN

U: 3DUP                         DUP  2OVER  ROT  ;

PRIMITIVE
U: 2OVER                           3 PICK 3 PICK ;


UNDEF 2R@
CODE  2R@
        SI POP
        2 +[BP] PUSH
        [BP] PUSH
        SI JMPI
        END-CODE
#THEN


}} #IF  CR .( stack handling                            )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{
                                                                          HEX
U: */MOD >R M* R> M/MOD ;
U: MU/MOD >R 0 R@ UM/MOD R> SWAP >R UM/MOD R> ;

}} #IF  CR .( mixed mode arithmetic                     ) LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{                                                                        HEX
UNDEF (do)
   CODE (do)
      8000 # DX MOV
      AX DX SUB
      CX DX ADD
      BP DEC
      BP DEC
      DX [BP] MOV
      RET
#THEN

UNDEF (?do)
   CODE (?do)
      8000 # DX MOV
      AX DX SUB
      CX DX ADD
      BP DEC
      BP DEC
      DX [BP]  MOV
      AX CX CMP
      RET
#THEN

}} #IF  CR .( loops                                     ) LIBSTATS #THEN


{{
UNDEF DEBUG
        CODE DEBUG
        3 INT
        RET
END-CODE
#THEN

HEX
UNDEF INT21
CODE INT21  ( DX CX BX AX -- DX CX BX AX )
        SI POP
        AX POP
        BX POP
        CX POP
        DX POP
        21 INT
        DX PUSH
        CX PUSH
        BX PUSH
        AX PUSH
        SI JMPI
END-CODE
#THEN


}} #IF  CR .( interrupts                                ) LIBSTATS #THEN



\ ------------------------------------------------------------------------

}} #IF
       CR .(                                           Ĵ)
       CR .(                     included from library ) LIBSTATS #THEN
       CR .( Ĵ)
       CR .(                       object size total   ) HERE 256 - 5 U.R
                                                           .(  bytes       )
FIND HIHERE  #IF    DROP
       CR .( ĳ)
       CR .(  last code address upwards                )   HERE    5 U.R
                                                           .(              )
       CR .(  memory allocation downwards              ) HIHERE    5 U.R
                                                           .(              )
       CR .(  MEMEND                                   ) MEMEND 1- 5 U.R
                                                           .(              )
           #ELSE
       CR .(            scratch data space below stack )
                   MEMEND rssize dssize + -  HERE -  5 U.R .(  bytes       )
      #THEN
       CR .( )
 {{


           