32 MSDOS
INCLUDE IBMMINI
INCLUDE DOSINT
HANDLE INPUT


4 CONSTANT LINKSIZE


\ ---------------------------------------------------------------
\                     file parameters
\ ---------------------------------------------------------------

VARIABLE CURRENTFILE

H: FILEPARAMETER
        CREATE  CURRENTFILE @ DUP ,
                CELL + CURRENTFILE !
        DOES>   @ CURRENTFILE @ +  ;

FILEPARAMETER LASTLINE                  \ seg of last line in file
FILEPARAMETER LASTLINE_A                \ off to last line in file
FILEPARAMETER 1STLINE                  \ seg of 1st line in file
FILEPARAMETER 1STLINE_A                \ off to 1st line in file
FILEPARAMETER START_OF_FILE         \ seg to read file into
FILEPARAMETER START_OF_FILE_A       \ off to read file into
FILEPARAMETER LINES_IN_FILE
FILEPARAMETER WINDOWHEIGHT
FILEPARAMETER TOPLINE


H: FILEDATA   CREATE DOES> CURRENTFILE !  ;
FILEDATA FILE1


HEX
: NEWFILE  ( -- )
        ?CS: LASTLINE
        2DUP 1STLINE 2!  LASTLINE 2!
        0 LINES_IN_FILE !
        #LINES  WINDOWHEIGHT !
        0 TOPLINE !
        ?CS: 1000 +  0  START_OF_FILE 2!   ;




\ ---------------------------------------------------------------
\                          general
\ ---------------------------------------------------------------
CODE NOOP  RET  END-CODE




\ ---------------------------------------------------------------
\                        screen job
\ ---------------------------------------------------------------

: CR/LF  ( -- )
        ?XY  WINDOWHEIGHT @ 1- U<
        NOT IF 0 DUP CHARS/LINE
               WINDOWHEIGHT @ 1 SCROLL
               0 WINDOWHEIGHT @ 1- AT
        ELSE   CR
        THEN   DROP  ;


TABLE CONTROLCHAR
( 00-03 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,
( 04-07 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,
( 08-11 )    ' NOOP ,        ' NOOP ,        '  CR/LF ,      ' NOOP ,
( 12-15 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,
( 16-19 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,
( 20-23 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,
( 24-27 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,
( 28-31 )    ' NOOP ,        ' NOOP ,        ' NOOP ,        ' NOOP ,


: DIRECT-EMIT ( asc -- )
        DUP BL U< IF CONTROLCHAR EXECUTE
                ELSE  EMIT  THEN   ;




\ ---------------------------------------------------------------
\                            links
\ ---------------------------------------------------------------


: LINE1  ( ADDR -- ADDR SEG )      LINKSIZE + 2@     0 TOPLINE  !  ;
: +LINE  ( SEG OFF -- SEG OFF )    LINKSIZE + 2@L   ;
: -LINE  ( SEG OFF -- SEG OFF )               2@L   ;

HEX
: NORMALIZE  ( seg off -- seg off )
        DUP 0< IF  8000 - SWAP 0800 + SWAP  THEN   ;

\ : -NORMALIZE  ( seg off -- seg off )
\         DUP 0< IF  8000 + SWAP 0800 - SWAP  THEN   ;

: LINK  ( addr offs -- )
        0 DUP  2OVER LINKSIZE +  2!L
        LASTLINE 2@  2OVER   2OVER
        LINKSIZE + 2OVER 2SWAP  2!L 2!L
        LASTLINE 2!
        1 LINES_IN_FILE +!  ;




\ ---------------------------------------------------------------
\                          file read
\ ---------------------------------------------------------------


: GETLINE    ( SEG OFFS -- SEG OFFS F )
           BEGIN
              GET    ( asc 0 | err )
              IF
                 FALSE FALSE
              ELSE
                 DUP CONTROL J =
                 DUP 0= >R
                 IF
                    DROP TRUE
                 THEN
                 R>
              THEN
           WHILE
              DUP  2OVER C!L
              DROP
              1+
           REPEAT    ;


: GETFILE ( -- )
        START_OF_FILE 2@
        BEGIN
           NORMALIZE
           2DUP
           LINKSIZE 2* +
           2DUP
           2+            ( ROOM FOR LINE LEN )
           GETLINE
        WHILE
           2SWAP 2OVER 2OVER
           ROT SWAP - -ROT -
           4 << +  2- -ROT !L      ( store line len )
           2SWAP LINK
        REPEAT
        2DROP 2DROP 2DROP  ;




\ ---------------------------------------------------------------
\                        file display
\ ---------------------------------------------------------------


: .LINE ( SEG OFFS -- )
        2DUP 2+
        2SWAP @L
        CHARS/LINE MIN
        0 DO
          LCOUNT DIRECT-EMIT
         LOOP  2DROP  ;



: .SCREEN  ( SEG OFF -- )
        CLS
        WINDOWHEIGHT @  0 DO
           2DUP LINKSIZE 2* +
           CR/LF .LINE
           +LINE
           2DUP OR
           0= IF LEAVE THEN
        LOOP
        2DROP  ;



\ ---------------------------------------------------------------
\                         interaction
\ ---------------------------------------------------------------
 : UP    ( SEG OFF -- SEG OFF )
        TOPLINE @
        IF
           -LINE
           2DUP .SCREEN
           -1 TOPLINE +! 
        THEN ;


: DOWN  ( SEG OFF -- SEG OFF )
        TOPLINE @
        WINDOWHEIGHT @ +
        LINES_IN_FILE @ U<
        IF
           +LINE
           2DUP .SCREEN
           1 TOPLINE +!
        THEN  ;



VARIABLE STOP
: DONE  STOP ON  ;


INCLUDE KEYCODES
CREATE SCROLLKEYS  0 ,
         C-UP ,        '  UP ,
         C-DOWN ,      ' DOWN ,
         ESC ,         ' DONE ,
HERE SCROLLKEYS 2+ -  4 /   SCROLLKEYS !





: BROWSE   ( -- )
        LASTLINE LINE1
        2DUP .SCREEN

        BEGIN
           ATKEY SCROLLKEYS LOOKUP
           ?DUP IF EXECUTE THEN
           0 0 AT
             ." Lines: "  LINES_IN_FILE @ .
             ." Top: "    TOPLINE @ .
        STOP @ UNTIL
        2DROP   ;



HEX
: MAIN          SETUP-VID
                1STPAR READ$ INPUT FILENM DROP   \ read name from cmdline
                INPUT  OPEN-FILE-R/O             \ attempt opening
                0= IF
                  FILE1 NEWFILE
                  INPUT FROMFILE
                     GETFILE                  KEY DROP
                     STOP OFF
                     BROWSE
                  ENDFROM
                THEN
                UNSETUP-VID  ;

INCLUDE FORTHLIB
END
