32 MSDOS
INCLUDE IBMMINI
INCLUDE DOSINT
INCLUDE KEYCODES

HANDLE INPUT


4 CONSTANT LINKSIZE

0 0 2CONSTANT STATUSPOS
CHARS/LINE CONSTANT STATUSLEN


\ ---------------------------------------------------------------
\                     file parameters
\ ---------------------------------------------------------------

VARIABLE CURRENTFILE

1 1 IN/OUT
H: FILEPARAMETER
        CREATE  CURRENTFILE @ DUP ,
                CELL + CURRENTFILE !
        DOES>   @ CURRENTFILE @ +  ;


FILEPARAMETER LISTNAME              \ filename
FILEPARAMETER LASTLINE              \ seg of last line in file
FILEPARAMETER LASTLINE_A            \ off to last line in file
FILEPARAMETER 1STLINE               \ seg of 1st line in file
FILEPARAMETER 1STLINE_A             \ off to 1st line in file
FILEPARAMETER START_OF_FILE         \ seg to read file into
FILEPARAMETER START_OF_FILE_A       \ off to read file into

FILEPARAMETER LINES_IN_FILE
FILEPARAMETER TOPLINE

FILEPARAMETER WINDOWHEIGHT
FILEPARAMETER WINDOWWIDTH
FILEPARAMETER WINDOWTOP
FILEPARAMETER WINDOWLEFT
FILEPARAMETER RIGHTPAN



1 0 IN/OUT
H: FILEDATA   CREATE DOES> CURRENTFILE !  ;
FILEDATA FILE1


HEX
0 0 IN/OUT
: NEWFILE  ( -- )
        INPUT LISTNAME !
        ?CS: LASTLINE
        2DUP 1STLINE 2!  LASTLINE 2!
        ?CS: 1000 +  0  START_OF_FILE 2!

        0 LINES_IN_FILE !
        0 TOPLINE !

        1 WINDOWTOP !
        #LINES WINDOWTOP @ - WINDOWHEIGHT !
        0 WINDOWLEFT !
        CHARS/LINE WINDOWLEFT @ -  WINDOWWIDTH !
        0 RIGHTPAN !  ;



\ ---------------------------------------------------------------
\                          windows
\ ---------------------------------------------------------------
: RESIZEWINDOW   ;
: MOVEWINDOW     ;


\ ---------------------------------------------------------------
\                        menu stuff
\ ---------------------------------------------------------------

H: MENUDATA  CREATE ,  DOES> @ +  ;
  0    DUP MENUDATA MENUHEIGHT
CELL + DUP MENUDATA MENUWIDTH
CELL + DUP MENUDATA MENUITEMS
DROP

: EMITS ( N ASC -- )  SWAP 0 ?DO  DUP EMIT LOOP  DROP  ;

: ROOF  ( N -- )
        ?XY ROT MENUWIDTH @
        ASCII  EMIT
        ASCII  EMITS
        ASCII  EMIT
        !XY   ;

: FLOOR ( N -- )
        >R ?XY
        2DUP R@  MENUHEIGHT @ 1+ + !XY
        R> MENUWIDTH @
        ASCII  EMIT
        ASCII  EMITS
        ASCII  EMIT
        !XY   ;

: ITEMCOUNT ( ADDR -- ADDR' CNT )   MENUHEIGHT COUNT  ;
: +ITEM    ( ADDR -- ADDR )         ITEMCOUNT + ;

: .ITEM    ( ADDR N -- )
        DUP ?XY
        2DUP >R >R
        1+ ROT + !XY
        OVER MENUITEMS
        SWAP 0 ?DO +ITEM LOOP
        SWAP MENUWIDTH @
        SWAP   ASCII  EMIT
        ITEMCOUNT TUCK TYPE
        - SPACES  ASCII  EMIT
        R> R> !XY   ;


: .ITEMS  ( ADDR -- )
        DUP ROOF
        DUP @ 0 ?DO
           DUP I .ITEM  LOOP
        FLOOR  ;


: .REV-ITEM ( ADDR N -- )
        REVERSE .ITEM NORMAL  ;

VARIABLE MENUDONE
: UP-ITEM      1- OVER @ MOD  ;
: DOWN-ITEM    1+ OVER @ MOD  ;
: BACK-ITEM    MENUDONE ON    ;
: SELECT-ITEM  ENTER MENUDONE !  ;

CREATE MENUKEYS 0 ,
        C-UP ,     '  UP-ITEM  ,
        C-DOWN ,   ' DOWN-ITEM ,
        ESC  ,     ' BACK-ITEM ,
        ENTER ,    ' SELECT-ITEM ,
HERE MENUKEYS 2+ -  4 / MENUKEYS !


: CHOOSE-ITEM  ( ADDR N -- N )
        MENUDONE OFF

        2DUP  REVERSE .ITEM  NORMAL
        BEGIN  ATKEY MENUKEYS LOOKUP

        ?DUP IF
           >R 2DUP .ITEM
           R> EXECUTE 2DUP .REV-ITEM
        THEN

        MENUDONE @ UNTIL
        MENUDONE @ ENTER = IF DUP MENUDONE ! THEN
        2DROP  ;

: SAVEWINDOW ( ADDR -- MANY )
        ?XY SWAP  ROT TUCK
        MENUWIDTH @ 2+ RANGE  2SWAP
        MENUHEIGHT @ 2+ RANGE
        ?DO
           2DUP >R >R
           ?DO
              I J PICKCHAR
           LOOP
           R> R>
        LOOP  2DROP   ;


: RESTOREWINDOW ( MANY ADDR -- )
        ?XY SWAP  ROT TUCK
        MENUWIDTH @ 2+ OVER + 1-  2SWAP
        MENUHEIGHT @ 2+ OVER + 1-
        ?DO
           2DUP >R >R
           ?DO
              I J PUTCHAR
           -1 +LOOP
           R> R>
        -1 +LOOP  2DROP   ;




: DOMENU   ( ADDR -- )
         DUP >R SAVEWINDOW
         R@ .ITEMS
         R@ 0
         2DUP .REV-ITEM
         CHOOSE-ITEM

         MENUDONE @
         TRUE <>
         IF
           R@ MENUDONE @ 0 ?DO +ITEM LOOP
         @ EXECUTE
         ELSE
                ( ESCAPE PRESSED )
         THEN
         R> RESTOREWINDOW ;


H: MENU   ( -- ADDR )   ( COMPILE )
          ( -- )        ( RUN )
        CREATE HERE
          0 ,    ( number of items in menu )
          0 ,    ( window width )
        DOES>
          DOMENU   ;

H: ENDMENU  ( N -- )    DROP   ;

H: ITEM ( ADDR ADDR -- ADDR )
        ,
        HERE
        0 C,   ( LEN )
        ,"
        HERE OVER -
        1- DUP ROT C!
        OVER MENUWIDTH @
        MAX
        OVER MENUWIDTH !
        DUP MENUHEIGHT DUP @
        1+ SWAP !  ;


MENU WINDOWMENU
    ' RESIZEWINDOW ITEM  Resize
    ' MOVEWINDOW   ITEM   Move
ENDMENU

MENU MAINMENU
    ' WINDOWMENU   ITEM    Window manager
    ' bye          ITEM      eXit lister
    ' RESIZEWINDOW ITEM  not defined item 1
    ' MOVEWINDOW   ITEM  not defined item 2
    ' RESIZEWINDOW ITEM  not defined item 3
    ' MOVEWINDOW   ITEM  not defined item 4
    ' RESIZEWINDOW ITEM  not defined item 5
    ' MOVEWINDOW   ITEM  not defined item 6
    ' RESIZEWINDOW ITEM  not defined item 7
    ' MOVEWINDOW   ITEM  not defined item 8
ENDMENU

DECIMAL
: MENUS     20 10 AT  MAINMENU  ;


\ ---------------------------------------------------------------
\                            links
\ ---------------------------------------------------------------


1 2 IN/OUT : LINE1  ( ADDR -- ADDR SEG )      LINKSIZE + 2@     0 TOPLINE  !  ;
2 2 IN/OUT : +LINE  ( SEG OFF -- SEG OFF )    LINKSIZE + 2@L   ;
2 2 IN/OUT : -LINE  ( SEG OFF -- SEG OFF )               2@L   ;

HEX
2 2 IN/OUT : NORMALIZE  ( seg off -- seg off )
        DUP 0< IF  8000 - SWAP 0800 + SWAP  THEN   ;

2 0 IN/OUT : LINK  ( addr offs -- )
        0 DUP  2OVER LINKSIZE +  2!L
        LASTLINE 2@  2OVER   2OVER
        LINKSIZE + 2OVER 2SWAP  2!L 2!L
        LASTLINE 2!
        1 LINES_IN_FILE +!  ;




\ ---------------------------------------------------------------
\                          file read
\ ---------------------------------------------------------------


: GETLINE    ( SEG OFFS -- SEG OFFS F )
           BEGIN
              GET    ( asc 0 | err )
              IF
                 FALSE FALSE
              ELSE
                 DUP CONTROL J =
                 DUP 0= >R
                 IF
                    DROP TRUE
                 THEN
                 R>
              THEN
           WHILE
              1 SWAP
              2OVER C!L
              +
           REPEAT

           DUP IF
              DROP 2DUP 1- C@L
              ENTER = IF 1- THEN
              TRUE
           THEN
              ;


0 0 IN/OUT : GETFILE ( --  
 )
        START_OF_FILE 2@
        BEGIN
           NORMALIZE
           2DUP
           LINKSIZE 2* +
           2DUP
           2+            ( ROOM FOR LINE LEN )
           GETLINE
        WHILE
           2SWAP 2OVER 2OVER
           ROT SWAP - -ROT -
           4 << +  2- -ROT !L      ( store line len )
           2SWAP LINK
        REPEAT
        2DROP 2DROP 2DROP  ;



\ ---------------------------------------------------------------
\                         statusline
\ ---------------------------------------------------------------
0 0 IN/OUT : .STATUS ( -- )
           REVERSE
              STATUSPOS AT
              STATUSLEN SPACES
              STATUSPOS AT
              ." File: "  LISTNAME @ .FILENAME SPACE
              ."  Lines: "  LINES_IN_FILE @ .
              ."  Top: "    TOPLINE @ .
              ."  Pan: "    RIGHTPAN @ .
              ."  Depth: "  DEPTH .
           NORMAL ;


\ ---------------------------------------------------------------
\                        file display
\ ---------------------------------------------------------------


2 1 IN/OUT : .LINE ( SEG OFFS -- N )
        2DUP 2+
        RIGHTPAN @ +
        2SWAP @L
        RIGHTPAN @ -
        0 MAX
        WINDOWWIDTH @ MIN
        DUP >R
        0 ?DO
          LCOUNT EMIT
         LOOP  2DROP
         R>  ;


0 2 IN/OUT
: EACH_LINE ( -- N1 N2 )
        WINDOWTOP @
        WINDOWHEIGHT @
        RANGE  ;

: PUTLINE  ( ADDR OFF N -- ADDR OFF N )
        WINDOWLEFT @ SWAP !XY
        2DUP +LINE 2SWAP
        LINKSIZE 2* + .LINE  ;

2 0 IN/OUT : .SCREEN  ( SEG OFF -- )
        EACH_LINE ?DO
           I PUTLINE
           WINDOWWIDTH @ SWAP - SPACES
           2DUP OR  0=
           IF LEAVE THEN
        LOOP
        2DROP  ;

\ ---------------------------------------------------------------
\                         interaction
\ ---------------------------------------------------------------


: UPS    ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        TOPLINE @
        MIN MIN
        ?DUP IF
                DUP NEGATE TOPLINE +!
                0 ?DO  -LINE  LOOP
                2DUP .SCREEN
        THEN ;

: UP    ( SEG OFF -- SEG OFF )        1 UPS    ;
: PG-UP    ( SEG OFF -- SEG OFF )     WINDOWHEIGHT @ 1- UPS    ;


: DOWNS  ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        LINES_IN_FILE @
        OVER
        TOPLINE @ +
        -  MIN  MIN
        ?DUP IF
                DUP TOPLINE +!
                0 ?DO  +LINE  LOOP
                2DUP .SCREEN
        THEN ;

: DOWN  ( SEG OFF -- SEG OFF )        1 DOWNS  ;

: PG-DOWN  ( SEG OFF -- SEG OFF )     WINDOWHEIGHT @ 1- DOWNS  ;


: RIGHT ( SEG OFF -- SEG OFF )  1 RIGHTPAN +!   2DUP  .SCREEN  ;
: LEFT  ( SEG OFF -- SEG OFF )  RIGHTPAN DUP @ 1- 0 MAX <- 2DUP .SCREEN  ;


VARIABLE STOP
: DONE  STOP ON  ;

CREATE SCROLLKEYS  0 ,
         C-UP ,        '  UP ,
         C-DOWN  ,     ' DOWN ,
         C-RIGHT ,     ' RIGHT ,
         C-LEFT ,      ' LEFT ,
         PAGE-UP   ,   ' PG-UP   ,
         PAGE-DOWN ,   ' PG-DOWN ,
         F1 ,          ' MENUS ,
         ESC ,         ' DONE ,

HERE SCROLLKEYS 2+ -  4 /   SCROLLKEYS !


0 0 IN/OUT : BROWSE   ( -- )
        STOP OFF
        LASTLINE LINE1
        2DUP .SCREEN

        BEGIN
           .STATUS
           ATKEY SCROLLKEYS LOOKUP
            ?DUP IF EXECUTE THEN
        STOP @ UNTIL
        2DROP   ;




: restorescreen ( -- )
        0 #LINES 1- DO
        0 CHARS/LINE 1- DO
            I J  PUTCHAR
        -1 +LOOP
        -1 +LOOP ;

: savescreen    ( -- many )
           #LINES 0 DO
           CHARS/LINE 0 DO
             I J PICKCHAR
           LOOP
           LOOP ;


: MAIN
        SETUP-VID
        1STPAR READ$ INPUT FILENM DROP   \ read name from cmdline
        INPUT  OPEN-FILE-R/O             \ attempt opening
        0= IF
              savescreen
              FILE1 NEWFILE
              INPUT FROMFILE
              GETFILE
              CLS BROWSE
              restorescreen
           ENDFROM
        THEN
        UNSETUP-VID  ;

INCLUDE FORTHLIB
END
