
128 MSDOS
\ INCLUDE IBMMINI
INCLUDE SIRTEXT            
INCLUDE DOSINT
INCLUDE KEYCODES

ESC CONSTANT EXTENDED-KEY


HANDLE INPUT

4 CONSTANT LINKSIZE

0 0 2CONSTANT STATUSPOS
CHARS/LINE CONSTANT STATUSLEN


FALSE CONSTANT DON'T-REMOVE-MENU
TRUE  CONSTANT       REMOVE-MENU
      VARIABLE    AFTER-SELECTION

CODE NOOP RET END-CODE


0 EQU BOXSET
0 EQU #BOXCHARS


CTABLE BOXCHARS
    ," ͻ ͼ"
    ," Ŀ "
    ," ͸ ;"
    ," ķ Ľ"
    ,"  "
    ,"  "
    ,"  "
    ,"    "
    ,"    "
    ,"  "
    ,"    "
    ,"        "
    ,"  "
    ,"    "
    ,"        "
    ,"  "
    ,"    "
    ,"        "
    ,"  "
    ,"    "
    ,"        "
    ," oo oo"


  HERE   ' BOXCHARS -    EQU #BOXCHARS


1 0 IN/OUT
( N -- )
: OTHERBOXSET
        BOXSET +
        #BOXCHARS MOD
        EQU BOXSET  ;


1 1 IN/OUT
( N -- N )
: BOXCHAR
        BOXSET + BOXCHARS  ;


\ maybe executed by any item code to close remove window after selection
: QUITMENU  ( -- )
        REMOVE-MENU AFTER-SELECTION ! ;


2 1 IN/OUT
( -- ADDR )             \ compile time
( n addr -- 0 | addr )  \ run time
H: TRANSLATE
        CREATE HERE  0 ,
        DOES> LOOKUP  ;

H: END-TRANSLATE ( ADDR -- )
        HERE OVER CELL + -
        CELL 2* / SWAP ! ;


\ ---------------------------------------------------------------
\                     file parameters
\ ---------------------------------------------------------------

VARIABLE CURRENTFILE

1 1 IN/OUT
H: FILEPARAMETER
        CREATE  CURRENTFILE @ DUP ,
                CELL + CURRENTFILE !
        DOES>   @ CURRENTFILE @ +  ;


FILEPARAMETER LISTNAME              \ filename
FILEPARAMETER LASTLINE              \ seg of last line in file
FILEPARAMETER LASTLINE_A            \ off to last line in file
FILEPARAMETER 1STLINE               \ seg of 1st line in file
FILEPARAMETER 1STLINE_A             \ off to 1st line in file
FILEPARAMETER START_OF_FILE         \ seg to read file into
FILEPARAMETER START_OF_FILE_A       \ off to read file into

FILEPARAMETER LINES_IN_FILE
FILEPARAMETER TOPLINE

FILEPARAMETER WINDOWHEIGHT
FILEPARAMETER WINDOWWIDTH
FILEPARAMETER WINDOWTOP
FILEPARAMETER WINDOWLEFT
FILEPARAMETER RIGHTPAN

FILEPARAMETER CURRENTMENU




1 0 IN/OUT
H: FILEDATA
        CREATE CURRENTFILE @ ALLOT
        DOES> CURRENTFILE !  ;

FILEDATA FILE1


HEX
0 0 IN/OUT
: NEWFILE  ( -- )
        INPUT LISTNAME !
        ?CS: LASTLINE
        2DUP 1STLINE 2!  LASTLINE 2!
        ?CS: 1000 +  0  START_OF_FILE 2!

        0 LINES_IN_FILE !
        0 TOPLINE !

        1 WINDOWTOP !
        #LINES WINDOWTOP @ - WINDOWHEIGHT !
        0 WINDOWLEFT !
        CHARS/LINE WINDOWLEFT @ -  WINDOWWIDTH !
        0 RIGHTPAN !  ;


\ ---------------------------------------------------------------
\                        menu stuff
\ ---------------------------------------------------------------

H: MENUDATA  DUP CONSTANT CELL +   ;

     0
        MENUDATA MENUHEIGHT
        MENUDATA MENUWIDTH
        MENUDATA MENUCHOICE
        MENUDATA MENUITEMS
     DROP


2 0 IN/OUT
: EMITS ( N ASC -- )  SWAP 0 ?DO  DUP EMIT LOOP  DROP  ;


1 0 IN/OUT
: ROOF  ( ADDR -- )
        ?XY
        0 BOXCHAR EMIT
        ROT MENUWIDTH + @   1 BOXCHAR  EMITS
        2 BOXCHAR  EMIT
        !XY   ;

1 0 IN/OUT
: FLOOR ( ADDR -- )
        >R  ?XY
        2DUP    R@ MENUHEIGHT + @ 1+ +  !XY
        6 BOXCHAR EMIT                        ( bottom left corner )
        R>  MENUWIDTH + @  7 BOXCHAR EMITS    ( bottom )
        8 BOXCHAR EMIT                        ( bottom right corner )
        !XY   ;


1 2 IN/OUT
: $ITEM ( ADDR -- ADDR' CNT )   CELL +  COUNT  ;


1 1 IN/OUT
: +ITEM ( ADDR -- ADDR )        $ITEM + ;


2 0 IN/OUT
: .ITEM    ( ADDR N -- )
        DUP ?XY
        2DUP >R >R
           ROT + 1+ !XY                ( put cursor to item location )

           OVER MENUITEMS +              ( locate first menu item )
           SWAP 0 ?DO
                +ITEM
           LOOP

           3 BOXCHAR EMIT
           $ITEM  TUCK TYPE
           SWAP MENUWIDTH + @
           SWAP - SPACES
           5 BOXCHAR EMIT
        R> R> !XY
        NORMAL  ;


2 0 IN/OUT
: .MENU  ( ADDR n -- )
        OVER ROOF
        OVER MENUHEIGHT + @ 0 ?DO
           2DUP I TUCK =
           IF REVERSE THEN
           .ITEM
        LOOP  DROP
        FLOOR  ;


H: MENUMESSAGE 1+ DUP CONSTANT ;
     0
        MENUMESSAGE SELECT
        MENUMESSAGE ESCAPE
     DROP


( ADDR N -- ADDR N F )
: ITEM-UP
        1- OVER MENUHEIGHT
        + @ MOD  FALSE   ;

( ADDR N -- ADDR N F )
: ITEM-DOWN
        1+ OVER MENUHEIGHT
        + @ MOD  FALSE   ;

( ADDR N -- ADDR N F )
: ITEM-BACK
        2DUP SWAP MENUCHOICE
        + !    ESCAPE  ;

( ADDR N -- ADDR N F )
: ITEM-SELECT
        2DUP SWAP MENUCHOICE
        + !    SELECT  ;


TRANSLATE MENUKEYS
        C-UP ,     ' ITEM-UP ,
        C-DOWN ,   ' ITEM-DOWN ,
        ESC  ,     ' ITEM-BACK ,
        C-LEFT ,   ' ITEM-BACK ,
        ENTER ,    ' ITEM-SELECT ,
        C-RIGHT ,  ' ITEM-SELECT ,
        F1  ,      ' ITEM-SELECT ,

	CONTROL E ,  ' ITEM-UP ,
	CONTROL X ,  ' ITEM-DOWN ,	
	CONTROL S ,  ' ITEM-BACK ,
	CONTROL D ,  ' ITEM-SELECT , 
END-TRANSLATE


( ADDR N N -- ADDR N N )
: DIFFERENT-ITEM
        >R  OVER R>  .ITEM    ( normal intensity old item )
        2DUP REVERSE .ITEM    ( reverse the now current item )
        DUP ;

( N MADDR N XADDR -- ADDR N F )
: MENUKEY-VALID
        EXECUTE  >R          ( execute key action, save menu message )
        ROT 2DUP <>
        IF  DIFFERENT-ITEM  THEN
        DROP  R>  ;


VARIABLE SCRATCH
2 1 IN/OUT
: SEARCH-HOTKEY  ( addr asc -- f )
        SCRATCH !
        FALSE SWAP
        DUP MENUITEMS +
        OVER MENUHEIGHT + @
        0 ?DO
           DUP
           $ITEM 0 ?DO
              COUNT SCRATCH @ =
              IF
                 2DROP
                 I OVER MENUCHOICE + !
                 NIP TRUE SWAP DUP DUP
                 LEAVE
              THEN
           LOOP DROP
           >R OVER R> SWAP
           IF
              LEAVE
           THEN
           +ITEM
        LOOP  DROP
        DROP ;



2 1 IN/OUT
( ADDR N -- msg )  \ msg =  SELECT or ESCAPE
: CHOOSE-ITEM      \ last item always in MENUCHOICE
        BEGIN
           TUCK
           ATKEY DUP >R
           MENUKEYS
           DUP IF
              MENUKEY-VALID
           ELSE
              2DROP
              SWAP                         \   ADDR N
              OVER R@ CAPITALIZE           \   ADDR N ADDR ASC
              SEARCH-HOTKEY                \   ADDR N F
              IF                           \   ADDR N
                   OVER                    \ 1 ADDR N ADDR
                   MENUCHOICE + @          \   ADDR N N'
                   SWAP                    \   ADDR N' N
                   2DUP <>                 \ 3 ADDR N' N F
                 IF  DIFFERENT-ITEM  THEN  \ 3 ADDR N' N
                 DROP                      \ 2 ADDR N'
                 SELECT                    \ 3 ADDR N' SEL
              ELSE                         \
                  FALSE
              THEN
           THEN
           R> DROP
        ?DUP UNTIL ( menu message )
        -ROT  2DROP  ;


( lastcolumn 1stcolumn lastline 1stline -- many )
: SAVESCREENAREA
        ?DO
           2DUP >R >R
           ?DO
              I J PICKCHAR
           LOOP
           R> R>
        LOOP  2DROP ;

: RESTORESCREENAREA  ( many 1stcolumn lastcolumn 1stline lastline -- )
        ?DO
           2DUP >R >R
           ?DO
              I J PUTCHAR
           -1 +LOOP
           R> R>
        -1 +LOOP  2DROP   ;


: SAVEWINDOW ( ADDR -- MANY )
        ?XY SWAP  ROT TUCK
        MENUWIDTH + @ 2+ RANGE  2SWAP
        MENUHEIGHT + @ 2+ RANGE
        SAVESCREENAREA  ;


: RESTOREWINDOW ( MANY ADDR -- )
        ?XY SWAP  ROT TUCK
        MENUWIDTH + @ 2+ OVER + 1-  2SWAP
        MENUHEIGHT + @ 2+ OVER + 1-
        RESTORESCREENAREA  ;


: DOITEM ( ADDR N MSG -- ADDR N )
        NIP OVER
        MENUCHOICE + @

        SWAP SELECT =
        IF
           OVER MENUITEMS +
           OVER 0 ?DO +ITEM LOOP
           @ EXECUTE
        THEN    ;


: DOMENU   ( X Y ADDR -- )
        DON'T-REMOVE-MENU AFTER-SELECTION !
        >R  ?XY 2SWAP !XY
        R@  SAVEWINDOW
        R@ DUP MENUCHOICE + @
        2DUP  .MENU
        BEGIN
           OVER CURRENTMENU !
           AFTER-SELECTION @
           IF
              FALSE DUP
           ELSE
              2DUP CHOOSE-ITEM
              DUP ESCAPE <>
           THEN
        WHILE
           DOITEM
        REPEAT
        DROP 2DROP
        R> RESTOREWINDOW
        !XY  ;


H: MENU   ( -- ADDR )   ( COMPILE )
          ( -- )        ( RUN )
        CREATE HERE
          0 ,    ( menu height )
          0 ,    ( window width )
          0 ,    ( menu choice )
        DOES>
          DOMENU   ;

H: ENDMENU  ( N -- )    DROP   ;

H: ITEM" ( ADDR ADDR -- ADDR )
        ,
        HERE
        0 C,   ( LEN )
        ,"
        HERE OVER -
        1- DUP ROT C!
        OVER MENUWIDTH + @
        MAX
        OVER MENUWIDTH + !
        DUP MENUHEIGHT + DUP @
        1+ SWAP !  ;





VARIABLE STOP
: DONE  STOP ON  ;


\ ---------------------------------------------------------------
\                          windows
\ ---------------------------------------------------------------

0 0 IN/OUT
( -- )
: REDRAWMENU
        CURRENTMENU @
        DUP MENUCHOICE +
        @ .MENU   ;


: NEXTBOXSET   ( -- )    9 OTHERBOXSET  REDRAWMENU ;
: PREVBOXSET   ( -- )   -9 OTHERBOXSET  REDRAWMENU ;

: SELFBOXSET   ( -- )
        BOXSET  ['] BOXCHARS +
        9 0 DO
           DUP C@
           BEGIN
              DUP
              ATKEY >R
              R@ C-LEFT  = IF 1- ELSE
              R@ C-RIGHT = IF 1+ THEN THEN
              TUCK <>
              IF
                 2DUP C<-
                 REDRAWMENU
              THEN
              R> DUP ESC =
              SWAP ENTER = OR
           UNTIL
           DROP 1+
        LOOP
        DROP  ;


: RESIZEWINDOW ( -- )   ;
: MOVEWINDOW   ( -- )   ;
: ZOOMWINDOW   ( -- )   ;
: HIDEWINDOW   ( -- )   ;
: OPENFILES    ( -- )   ;
: QUITFILES    ( -- )   ;
: COLORSTAT    ( -- )   ;
: COLORTEXT    ( -- )   ;
: COLORMENUS   ( -- )   ;
: EXITPROG     ( -- )   DONE QUITMENU   ;

\ ---------------------------------------------------------------
\                           menus
\ ---------------------------------------------------------------


DECIMAL


\ ---------------------------------------------------------------------
MENU (BOXMENU)          ' NEXTBOXSET     ITEM"    Next set"
                        ' PREVBOXSET     ITEM"  Previous set "
                        ' SELFBOXSET     ITEM"   Make self"
                        ' NOOP           ITEM"      Ĵ"
                        ' QUITMENU       ITEM"     <"         ENDMENU
: BOXMENU      ( -- )    34 1 (BOXMENU)   ;
\ ---------------------------------------------------------------------
MENU (WINDOWMENU)       ' RESIZEWINDOW   ITEM"  Resize "
                        ' MOVEWINDOW     ITEM"   Move"
                        ' ZOOMWINDOW     ITEM"   Zoom"
                        ' HIDEWINDOW     ITEM"   Hide"
                        ' NOOP           ITEM"    Ĵ"
                        ' QUITMENU       ITEM"   <"           ENDMENU
: WINDOWMENU   ( -- )	34 1 (WINDOWMENU)  ;
\ ---------------------------------------------------------------------
MENU (COLORMENU)        ' COLORSTAT      ITEM"  Statusline "
                        ' COLORTEXT      ITEM"  Foreground"
                        ' COLORMENUS     ITEM"    Menus"
                        ' NOOP           ITEM"     Ĵ"
                        ' QUITMENU       ITEM"    <"          ENDMENU
: COLORMENU    ( -- )   34 1 (COLORMENU)  ;
\ ---------------------------------------------------------------------
MENU (DISPLAYMENU)	' COLORMENU      ITEM"  Colors setup"
                        ' WINDOWMENU     ITEM"  Windows setup "
                        ' BOXMENU        ITEM"   Boxes setup"
                        ' NOOP           ITEM"       Ĵ"
                        ' QUITMENU       ITEM"      <"        ENDMENU
: DISPLAYMENU  ( -- )	18 1  (DISPLAYMENU)  ;
\ ---------------------------------------------------------------------
MENU (FILESMENU)        ' OPENFILES      ITEM"  Open file "
                        ' QUITFILES      ITEM"  Quit file"
                        ' NOOP           ITEM"     Ĵ"
                        ' QUITMENU       ITEM"    <"          ENDMENU
: FILESMENU    ( -- )	18 1  (FILESMENU)  ;
\ ---------------------------------------------------------------------
MENU (MAINMENU)         ' EXITPROG       ITEM"   eXit program"
                        ' FILESMENU      ITEM"    Files menu"
                        ' DISPLAYMENU    ITEM"  Display options "
                        ' NOOP           ITEM"       Ĵ"
                        ' QUITMENU       ITEM"      <"        ENDMENU
: MAINMENU     ( -- )	 0 1  (MAINMENU)  ;
\ ---------------------------------------------------------------------







\ ---------------------------------------------------------------
\                            links
\ ---------------------------------------------------------------


1 2 IN/OUT
( ADDR -- ADDR SEG )
: LINE1
        LINKSIZE + 2@
        0 TOPLINE  !  ;

2 2 IN/OUT
( SEG OFF -- SEG OFF )
: +LINE
        LINKSIZE + 2@L   ;

2 2 IN/OUT
( SEG OFF -- SEG OFF )
: -LINE
        2@L   ;

HEX
2 2 IN/OUT
( seg off -- seg off )
: NORMALIZE
        DUP 0< IF
           8000 - SWAP
           0800 + SWAP
        THEN   ;

2 0 IN/OUT
( addr offs -- )
: LINK
        0 DUP  2OVER LINKSIZE +  2!L
        LASTLINE 2@  2OVER   2OVER
        LINKSIZE + 2OVER 2SWAP  2!L 2!L
        LASTLINE 2!
        1 LINES_IN_FILE +!  ;




\ ---------------------------------------------------------------
\                          file read
\ ---------------------------------------------------------------


: GETLINE    ( SEG OFFS -- SEG OFFS F )
        BEGIN
           GET    ( asc 0 | err )
           IF
              FALSE FALSE
           ELSE
              DUP CONTROL J =
              DUP 0= >R
              IF
                 DROP TRUE
              THEN
              R>
           THEN
        WHILE
           1 SWAP
           2OVER C!L
           +
        REPEAT

        DUP IF
           DROP 2DUP 1- C@L
           ENTER = IF 1- THEN
           TRUE
        THEN   ;

0 0 IN/OUT : GETFILE ( -- )
        START_OF_FILE 2@
        BEGIN
           NORMALIZE
           2DUP
           LINKSIZE 2* +
           2DUP
           2+            ( ROOM FOR LINE LEN )
           GETLINE
        WHILE
           2SWAP 2OVER 2OVER
           ROT SWAP - -ROT -
           4 << +  2- -ROT !L      ( store line len )
           2SWAP LINK
        REPEAT
        2DROP 2DROP 2DROP  ;



\ ---------------------------------------------------------------
\                         statusline
\ ---------------------------------------------------------------
0 0 IN/OUT : .STATUS ( -- )
        REVERSE
           STATUSPOS !XY
           STATUSLEN SPACES
           STATUSPOS !XY
           ." File: "  LISTNAME @ .FILENAME SPACE
           ."  Lines: "  LINES_IN_FILE @ .
           ."  Top: "    TOPLINE @ .
           ."  Pan: "    RIGHTPAN @ .
           ."  Depth: "  DEPTH .
        NORMAL ;


\ ---------------------------------------------------------------
\                        file display
\ ---------------------------------------------------------------


2 1 IN/OUT : .LINE ( SEG OFFS -- N )
        2DUP 2+
        RIGHTPAN @ +
        2SWAP @L
        RIGHTPAN @ -
        0 MAX
        WINDOWWIDTH @ MIN
        DUP >R
        0 ?DO
          LCOUNT EMIT
        LOOP  2DROP
        R>  ;


0 2 IN/OUT
: EACH_LINE ( -- N1 N2 )
        WINDOWTOP @
        WINDOWHEIGHT @
        RANGE  ;

: PUTLINE  ( ADDR OFF N -- ADDR OFF N )
        WINDOWLEFT @ SWAP !XY
        2DUP +LINE 2SWAP
        LINKSIZE 2* + .LINE  ;

2 0 IN/OUT : .SCREEN  ( SEG OFF -- )
        EACH_LINE ?DO
           I PUTLINE
           WINDOWWIDTH @ SWAP - SPACES
           2DUP OR  0=
           IF LEAVE THEN
        LOOP
        2DROP  ;

\ ---------------------------------------------------------------
\                         interaction
\ ---------------------------------------------------------------


: UPS    ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        TOPLINE @
        MIN MIN
        ?DUP IF
                DUP NEGATE TOPLINE +!
                0 ?DO  -LINE  LOOP
                2DUP .SCREEN
        THEN ;


( SEG OFF -- SEG OFF )
: UP    1 UPS    ;


( SEG OFF -- SEG OFF )
: PG-UP
        WINDOWHEIGHT @ 1- UPS    ;

: DOWNS  ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        LINES_IN_FILE @
        OVER
        TOPLINE @ +
        -  MIN  MIN
        ?DUP IF
                DUP TOPLINE +!
                0 ?DO  +LINE  LOOP
                2DUP .SCREEN
        THEN ;

( SEG OFF -- SEG OFF )
: DOWN  1 DOWNS  ;

( SEG OFF -- SEG OFF )
: PG-DOWN
        WINDOWHEIGHT @ 1- DOWNS  ;


( SEG OFF -- SEG OFF )
: RIGHT
        1 RIGHTPAN +!
        2DUP  .SCREEN  ;

( SEG OFF -- SEG OFF )
: LEFT
        RIGHTPAN DUP @ 1-
        0 MAX <- 2DUP .SCREEN  ;


TRANSLATE SCROLLKEYS
        C-UP ,        ' UP ,
        C-DOWN  ,     ' DOWN ,
        C-RIGHT ,     ' MAINMENU ,
        PAGE-UP   ,   ' PG-UP   ,
        PAGE-DOWN ,   ' PG-DOWN ,
        F1 ,          ' MAINMENU ,
        ESC ,         ' MAINMENU ,
        TAB> ,        ' RIGHT ,
        C-LEFT ,      ' LEFT ,

	CONTROL R ,   ' PG-UP ,
	CONTROL C ,   ' PG-DOWN ,
	CONTROL X ,   ' DOWN ,
	CONTROL E ,   ' UP ,

        CONTROL-D ,   ' MAINMENU ,
END-TRANSLATE


0 0 IN/OUT
: BROWSE   ( -- )
        STOP OFF
        LASTLINE LINE1
        2DUP .SCREEN

        BEGIN
           .STATUS
           ATKEY SCROLLKEYS
           ?DUP IF EXECUTE THEN
        STOP @ UNTIL
        2DROP   ;


: savescreen    ( -- many )
        CHARS/LINE 0
        #LINES 0
        SAVESCREENAREA ;

: restorescreen ( many -- )
        0 CHARS/LINE 1-
        0 #LINES 1-
        RESTORESCREENAREA  ;


: MAIN
        SETUP-VID
        1STPAR READ$ INPUT FILENM DROP   \ read name from cmdline
        INPUT  OPEN-FILE-R/O             \ attempt opening
        0= IF
              savescreen
              FILE1 NEWFILE
              INPUT FROMFILE
              GETFILE
              CLS BROWSE
              restorescreen
           ENDFROM
        THEN
        UNSETUP-VID  ;

INCLUDE FORTHLIB
END
                                                                                                                          