\ GENERATE A NUMBER OF INTERRUPT HANDLERS,
\ HAVE THEM EXECUTE COMMON CODE, AND
\ DISPERSE AGAIN TO EXECUTE THEIR ORIGINAL HANDLERS.


128 MSDOS

10 CONSTANT #HANDLERS
VARIABLE LOG 
VARIABLE OLDVECTORS
VARIABLE NEWHANDLERS
VARIABLE BYTES/HANDLER

L: COMMON
	BX PUSH
	DS PUSHSEG
        AH AL XCHG
	AX BX MOV
        AX CS <SEG
	LOG [] AX ADD
	AX DS >SEG
	[BX] AL MOV
	AL INC
	=0 IF,
	   AL DEC
	THEN,
	AL [BX]  MOV
	DS POPSEG
	BX POP
	RET
END-CODE


H: MAKEHANDLER   ( N -- )
   ASM  AX PUSH
	DUP # AL MOV
	COMMON CALL
	AX POP
	4 *  OLDVECTORS @ +  JMPF[]   
    ;

H: MAKEHANDLERS ( N -- )
	0 DO  I MAKEHANDLER LOOP  ;

: SHADOW  ( N -- )
	>R   0 0  ?CS: OLDVECTORS @ 
	R>   4 *  CMOVEL  ;

: REVECTOR  ( N -- )
	?CS: NEWHANDLERS @  ROT 0 DO
	2DUP 0 I 4 *  2!L
	BYTES/HANDLER @ + LOOP
	2DROP    ;

: RESTORE ( N -- )
	>R  ?CS: OLDVECTORS @ 0 0
	R>  4 *  CMOVEL  ;


: REPORT1  ( SEG N -- )
      256 0 DO
       OVER I C@L
       ?DUP IF  
          OVER CR ." INT " .  ."  FN " I .   ." TIMES " .
       THEN
      LOOP  2DROP  ;

: REPORT  ( N -- )
        ?CS: LOG # +
        SWAP 0 DO
  	  DUP I REPORT1  16 +
        LOOP DROP  ;


: CLEAR1LOG ( SEG -- )
      0 SWAP
      256 0 DO
         2DUP I C!L  
      LOOP  2DROP  ;

: CLEARLOG ( N -- )
	?CS: LOG @ +
        SWAP 0 DO
          DUP CLEAR1LOG
          16 +  LOOP
        DROP  ;

: CLEARLOGX ( N -- )
    ?CS: LOG @ +
    SWAP 0 DO
      16 0 DO
       16 0 DO
        0 OVER I C!L
       LOOP
     1+ LOOP
    LOOP
    DROP  ;



: MAIN
        #HANDLERS CLEARLOGX
        #HANDLERS SHADOW
	#HANDLERS REVECTOR
	KEY DROP
	#HANDLERS RESTORE 
	#HANDLERS REPORT  ;



HERE OLDVECTORS !     #HANDLERS 4 * ALLOT
HERE NEWHANDLERS !    #HANDLERS MAKEHANDLERS
HERE NEWHANDLERS @ -  #HANDLERS /  BYTES/HANDLER !
HERE NEGATE 15 AND ALLOT  \ paragraph boundary
HERE 16 / LOG !         (  #HANDLERS 256 * ALLOT  )

INCLUDE FORTHLIB
END


