PROGRAM bar_graph_example(INPUT,OUTPUT);

(*$LINESIZE:110*)
(*$PAGESIZE:44*)

(*****************************************************************************)
(*									     *)
(*			CHARACTER GRAPHICS EXAMPLE			     *)
(*			      FIGURE NO. 2				     *)
(*				BAR.PAS					     *)
(*									     *)
(*	By : David Hollifield						     *)
(*	Date : September 24, 1982					     *)
(*									     *)
(*****************************************************************************)

(*$page+*)

CONST

(*****************************************************************************)
(*									     *)
(*	Definition of Graphic Characters that are to be used in the	     *)
(*			following example				     *)
(*          								     *)
(*****************************************************************************)

	r_vert_line = ''   ;	l_vert_line = ''   ;	top_hor_line = ''   ;
		top_left_crnr = ''     ;	top_right_crnr = ''   ;
		bot_left_crnr = ''	;	bot_right_crnr = ''   ;

(*****************************************************************************)
(*									     *)
(*			    VT52 display definitions			     *)
(*									     *)
(*****************************************************************************)

	escape = chr(27);
	clear_screen = escape * 'E';
	put_crsr = escape * 'Y';

	graph_title = 'T O T A L  S A L E S';
	num_of_bars = 12;

(*page+*)


TYPE
	row_type = 1..24 ;

	col_type = 1..80 ;

	bar_data_record = RECORD
				row : row_type ;
				col : col_type ;
				lbl : string (3);
			  END;

	bar_data_array = array [1..12] of bar_data_record;

CONST
	bar_pos = bar_data_array (bar_data_record(13,15,'JAN'),
				  bar_data_record( 6,20,'FEB'),
				  bar_data_record( 8,25,'MAR'),
				  bar_data_record( 9,30,'APR'),
				  bar_data_record( 9,35,'MAY'),
				  bar_data_record(10,40,'JUN'),
				  bar_data_record(15,45,'JUL'),
				  bar_data_record(14,50,'AUG'),
				  bar_data_record(14,55,'SEP'),
				  bar_data_record(15,60,'OCT'),
				  bar_data_record(16,65,'NOV'),
				  bar_data_record(16,70,'DEC'));

(*$page+*)


PROCEDURE put_cursor(x : row_type; y : col_type; const out_str : string);

(*****************************************************************************)
(*									     *)
(*		This procedure places the cursor at the			     *)
(*		specified row and column and outputs the		     *)
(*		desired graphics character				     *)
(*									     *)
(*****************************************************************************)

CONST
	scr_off = 31;

BEGIN
	write(OUTPUT,put_crsr , chr (x + scr_off) , chr (y + scr_off));
	write(OUTPUT,out_str);
END;

(*$page+*)


PROCEDURE draw_graph;

(*****************************************************************************)
(*									     *)
(*		This procedure will perform the following :		     *)
(*									     *)
(*		o	clear the screen				     *)
(*		o	draw the right side of graph			     *)
(*			from row 1 column 80 to row 20			     *)
(*			column 80					     *)
(*		o	draw the bottom of graph from 			     *)
(*			row 21 column 80 to row 21 column 1		     *)
(*		o	place the title onto the graph			     *)
(*									     *)
(*****************************************************************************)

VAR
	i,j : integer;

BEGIN
	writeln(OUTPUT,clear_screen);

	for i := 1 to 20 do
		put_cursor(i,80,r_vert_line);

	for i := 80 downto 1 do
		put_cursor(21,i,top_hor_line);

	put_cursor(4,26,graph_title);
END;

(*$page+*)


PROCEDURE draw_bars;

(*****************************************************************************)
(*									     *)
(*		This procedure will draw the bars using bar_pos		     *)
(*									     *)
(*****************************************************************************)

VAR
     gr_ch : string (2);
     i,j : integer;
     gr_lbl : string (3);

BEGIN
     for i := 1 to num_of_bars do
	BEGIN
		  gr_ch := top_left_crnr * top_right_crnr;
			  put_cursor(bar_pos[i].row,bar_pos[i].col,gr_ch);
		  
		  gr_ch := l_vert_line * r_vert_line;	
			  for j := bar_pos[i].row + 1 to 18 do
				put_cursor(j,bar_pos[i].col,gr_ch);

		  gr_ch := bot_left_crnr * bot_right_crnr;	       
			  put_cursor(19,bar_pos[i].col,gr_ch);

		  gr_lbl := bar_pos[i].lbl;		  
		  put_cursor(22,bar_pos[i].col,gr_lbl);
	END;
END;
		
(*$page+*)


(*****************************************************************************)
(*									     *)
(*				MAIN PROGRAM				     *)
(*									     *)
(*****************************************************************************)

BEGIN
	draw_graph;
	draw_bars;
END.
