PROGRAM juggle_example(INPUT,OUTPUT);

(*$LINESIZE:110*)
(*$PAGESIZE:44*)

(*****************************************************************************)
(*									     *)
(*			CHARACTER GRAPHICS EXAMPLE			     *)
(*			        JUGGLE.PAS				     *)
(*									     *)
(*	By : David Hollifield						     *)
(*	Date : September 24, 1982					     *)
(*									     *)
(*****************************************************************************)

(*$page+*)

CONST

(*****************************************************************************)
(*									     *)
(*	Definition of Graphic Characters that are to be used in the	     *)
(*			following example				     *)
(*          								     *)
(*****************************************************************************)

	r_vert_line = ''   ;	l_vert_line = ''   ;	top_hor_line = '';   
	 l_face = ''  ;  r_face = ''  ;  l_side = ''  ;  r_side = '' ;
	l_hand_down = '' ; l_hand_up = '' ; l_arm = ''  ;  l_shldr = '' ;
	r_hand_down = '' ; r_hand_up = ''  ;  r_arm = ''  ;  r_shldr = '';
	l_foot = ''  ;  r_foot = ''  ;  ball = ''  ;  bot_hor_line = '';

(*****************************************************************************)
(*									     *)
(*			    VT52 display definitions			     *)
(*									     *)
(*****************************************************************************)

	escape = chr(27);
	clear_screen = escape * 'E';
	put_crsr = escape * 'Y';
	disable_crsr = escape * 'x5';
	enable_crsr = escape * 'y5';

(*****************************************************************************)
(*									     *)
(*			     Program Constants				     *)
(*									     *)
(*****************************************************************************)

	graph_title = 'MAGNIFICO';
	no_juggle_balls = 18 ;
	no_tossed_balls = 4 ;
	no_dropped_balls = 13 ;
	no_of_times_to_juggle = 3;
	toss_wait = 5000;
	juggle_wait = 3000;

(*page+*)


TYPE
	word_ads_type = ADS of word;
	row_type = 1..24 ;
	col_type = 1..80 ;
	juggle_row_pos_array = array[1..no_juggle_balls] of word;
	juggle_col_pos_array = array[1..no_juggle_balls] of word;
	tossed_row_pos_array = array[1..no_tossed_balls] of word;
	tossed_col_pos_array = array[1..no_tossed_balls] of word;
	drop_row_pos_array   = array[1..no_dropped_balls] of word;
	drop_col_pos_array   = array[1..no_dropped_balls] of word;

CONST (* for ball position arrays *)
	juggle_row_pos = juggle_row_pos_array(12,
					      11,
					      10,
					       9,
					       8,
					       7,
					       7,
					       8,
					       9,
					      10,
					      11,
					      12,
					      12,
					      11,
					      10,
					      10,
					      11,
					      12);					

	juggle_col_pos = juggle_col_pos_array(44,
					      44,
					      44,
					      43,
					      42,
					      41,
					      40,
					      39,
					      38,
					      37,
					      37,
					      37,
					      38,
					      39,
					      40,
					      41,
					      42,
					      43);
	
	tossed_row_pos = tossed_row_pos_array(14,
					      13,
					      12,
					      12);

	tossed_col_pos = tossed_col_pos_array(48,
					      47,
					      46,
					      45);


	drop_row_pos   =  drop_row_pos_array(13,
	       				     14,
				             13,
				             12,
				             12,
				             13,
				             14,
				             15,
				             16,
				             17,
				             17,
				             17,
				             17);

	drop_col_pos   =  drop_col_pos_array(36,
					     35,
					     34,
					     33,
					     32,
					     31,
					     30,
					     29,
					     28,
					     28,
					     27,
					     26,
					     25);


(*$page+*)

VAR
	juggle_address_array : array[1..no_juggle_balls] of word_ads_type;
	tossed_address_array : array[1..no_tossed_balls] of word_ads_type;
	drop_address_array : array[1..no_dropped_balls] of word_ads_type;
	keypress : boolean;
	char_set_base : word;

(*$page+*)

FUNCTION DOSXQQ(COMMAND, PARAMETER : WORD) : BYTE;EXTERN;  (* keypress *)

FUNCTION chk_scr_buff(scr_buff_add : word_ads_type) : boolean;

(*****************************************************************************)
(*									     *)
(*		This function checks the specified sreen buffer		     *)
(*		address to see if a ball is turned on or not.  		     *)
(*		If it is chk_scr_buff will return a "true" value	     *)
(*									     *)
(*****************************************************************************)

CONST
	display_mask = 2#1110111111111111;
	ball_ptr     = 2#0100000010101111; 
			   
VAR
	scr_contents : word;

BEGIN
	scr_contents := ball_ptr + char_set_base;
	if scr_buff_add^ = display_mask and scr_contents then
		chk_scr_buff := true
			else
				chk_scr_buff := false;
END (* chk_scr_buff *);

(*$page+*)


PROCEDURE calc_char_set_base;

(*****************************************************************************)
(*									     *)
(*		This procedure finds where the character set		     *)
(*		resides in memory.  It accomplishes this in 		     *)
(*		the following manner :					     *)
(*									     *)
(*		o	after the screen has been cleared		     *)
(*		o	look at location F0000 hex (screen 		     *)
(*			buffer ram) for the address of a 		     *)
(*			space						     *)
(*		o	subtract 20 hex from these contents		     *)
(*			to get the character set base			     *)
(*									     *)
(*****************************************************************************)

CONST
	attribute_mask = 2#0000011111111111;

VAR
	screen_address : ADS of word;

BEGIN
	screen_address.s := 16#F000 ; screen_address.r := 16#0000 ;
	char_set_base := (screen_address^ and attribute_mask) - 16#20;
END (* calc_char_set_base *);	


PROCEDURE wait(count : integer);

(*****************************************************************************)
(*									     *)
(*		Wait routine to slow PASCAL down enough to		     *)
(*		         see the juggler juggle				     *)
(*									     *)
(*****************************************************************************)

VAR
	i : integer;

BEGIN
	for i := count downto 1 do ;
END (* wait *);


PROCEDURE put_cursor(x : row_type; y : col_type; const out_str : string);

(*****************************************************************************)
(*									     *)
(*		This procedure places the cursor at the			     *)
(*		specified row and column and outputs the		     *)
(*		desired graphics character				     *)
(*									     *)
(*****************************************************************************)

CONST
	scr_off = 31;

BEGIN
	write(OUTPUT,put_crsr , chr (x + scr_off) , chr (y + scr_off));
	write(OUTPUT,out_str);
END;

(*$page+*)


PROCEDURE draw_box(col_strt, col_end : col_type; top_row, bot_row : row_type);

(*****************************************************************************)
(*									     *)
(*			      Box drawing procedure	 		     *)
(*									     *)
(*			This procedure will draw a box using		     *)
(*			the parameters passed to it as end-		     *)
(*			points of the resulting box			     *)
(*									     *)
(*****************************************************************************)

VAR
	i : integer;

BEGIN
	for i := col_strt to col_end do
		put_cursor(top_row,i,top_hor_line);
 
	for i := top_row to bot_row do
		put_cursor(i,col_end + 1,l_vert_line);

	for i := col_end downto col_strt do
		put_cursor(bot_row,i,bot_hor_line);

	for i := bot_row downto top_row do
		put_cursor(i,col_strt - 1,r_vert_line);
END (* put_cursor *);

(*$page+*)


PROCEDURE draw_juggler;

(*****************************************************************************)
(*									     *)
(*		      This procedure will draw the juggler		     *)
(*		      at the specified x,y coordinates using		     *)
(*		      the graphic characters defined by gr_ch		     *)
(*									     *)
(*****************************************************************************)

VAR
     gr_ch : lstring (10);

BEGIN
	  gr_ch := l_face * r_face ;	       
		  put_cursor(12,40,gr_ch);

	  gr_ch := l_hand_down * l_arm * l_shldr * l_side * r_side *
				r_shldr * r_arm * r_hand_up;
	  	  put_cursor(13,37,gr_ch);

	  gr_ch := l_foot * r_vert_line * l_vert_line * r_foot;
		  put_cursor(14,39,gr_ch);
END (* draw_juggler *);
		
(*$page+*)

PROCEDURE draw_ball(scr_buff_add : word_ads_type ; display : boolean);

(*****************************************************************************)
(*									     *)
(*		This procedure toggles the display attribute		     *)
(*		at the specified address to either display or		     *)
(*		hide the juggler's balls.				     *)
(*									     *)
(*****************************************************************************)

CONST
	non_display_mask = 2#0001000000000000; (* non-display attribute on  *)
	display_mask     = 2#1110111111111111; (* non-display attribute off *)
	ball_pointer     = 2#0100000010101111; (* ball = character AF hex   *)

VAR
	scr_contents : word ;

BEGIN
	scr_contents := char_set_base + ball_pointer;
	if display then
		scr_buff_add^ := ( display_mask and scr_contents )
		else
			scr_buff_add^ := ( non_display_mask or scr_contents );
END (* draw_ball *);

(*$page+*)


PROCEDURE calc_scr_buff_addrs;

(*****************************************************************************)
(*									     *)
(*		This procedure uses the position arrays to		     *)
(*		calculate the addresses in which the characters		     *)
(*		lie in the screen buffer segment, and draws the		     *)
(*		balls invisibly onto the screen for later use		     *)
(*		in the animation sequence.				     *)
(*									     *)
(*****************************************************************************)

CONST
	screen_buffer_segment = 16#F000;

VAR
	i : integer;

BEGIN
	for i := 1 to no_juggle_balls do
		begin
			juggle_address_array[i].s := screen_buffer_segment;		 
			juggle_address_array[i].r := 
				( ( juggle_row_pos[i] - 1 ) * 16#A0 ) +
					( ( juggle_col_pos[i] - 1 ) * 2 );
		end (* for *) ;

	for i := 1 to no_tossed_balls do
		begin
			tossed_address_array[i].s := screen_buffer_segment;
			tossed_address_array[i].r := 
				( ( tossed_row_pos[i] - 1 ) * 16#A0 ) +
					( ( tossed_col_pos[i] - 1 ) * 2 );
		end (* for *) ;

	for i := 1 to no_dropped_balls do
		begin
			drop_address_array[i].s := screen_buffer_segment;
			drop_address_array[i].r :=
				( ( drop_row_pos[i] - 1 ) * 16#A0 ) +
					( ( drop_col_pos[i] - 1 )  * 2 );
		end (* for *) ;
END (* calc_scr_buff_adrs *);

(*$page+*)


PROCEDURE animate;

(*****************************************************************************)
(*									     *)
(*		This procedure performs the actual animation		     *)
(*		of the juggling.  It accomplishes this by 		     *)
(*		scanning the ball arrays and seeing if a ball		     *)
(*		is on.  If it is, it turns that position off		     *)
(*		and turns the next position on.				     *)
(*									     *)
(*****************************************************************************)

VAR
	i,j : integer;
	scr_pos_on : boolean;

BEGIN


(******		              Toggle toss array				******)


	i := 1;
	repeat
		scr_pos_on := chk_scr_buff(tossed_address_array[i]);
		if scr_pos_on then
			begin
				draw_ball(tossed_address_array[i],
							false);
				draw_ball(tossed_address_array[i+1],
							true);
				i := i + 1;
			end (* if *);
	i := i + 1;
	until i >= no_tossed_balls;

	if chk_scr_buff(tossed_address_array[no_tossed_balls]) then
	begin
		put_cursor(13,44,r_hand_down);
		draw_ball(tossed_address_array[i],false);
	end (* if *);


(******			       Toggle juggle array			******)

	
	i := 1;
	repeat
		j := i + 1 ; if j > no_juggle_balls then j := 1;
		scr_pos_on := chk_scr_buff(juggle_address_array[i]);
		if scr_pos_on then			
			begin
				if i = 12 then 
					put_cursor(13,37,l_hand_down);
				if i = no_juggle_balls then
					put_cursor(13,44,r_hand_down);

				draw_ball(juggle_address_array[i],
							false);					
				draw_ball(juggle_address_array[j],
							true);

				wait(juggle_wait);

				if i = 12 then 
					put_cursor(13,37,l_hand_up);
				if i = no_juggle_balls then
					put_cursor(13,44,r_hand_up);
				i := i + 1;
			end (* if *);
	i := i + 1;
	until i > no_juggle_balls;

	
(******				Toggle drop array			******)

	i := 1;
	repeat
		scr_pos_on := chk_scr_buff(drop_address_array[i]);
		if scr_pos_on then
			begin
				draw_ball(drop_address_array[i],
							false);
				draw_ball(drop_address_array[i+1],
							true);
			i := i + 1;
			end (* if *);
	i := i + 1;
	until i >= no_dropped_balls;

	draw_ball(drop_address_array[i],false);

END (* animate *);				

(*$page+*)


PROCEDURE toss_one;

(*****************************************************************************)
(*									     *)
(*		This procedure tosses a ball into Mr. Magnifico		     *)
(*									     *)
(*****************************************************************************)

VAR
	i : integer;

BEGIN
	draw_ball(tossed_address_array[1],true);
	wait(toss_wait);
	for i:= 1 to no_tossed_balls do
		begin
			animate;
			wait(toss_wait);
		end (* for *);
	draw_ball(juggle_address_array[1],true);
	put_cursor(13,44,r_hand_up);
	wait(juggle_wait);
END (* toss_one *);

(* $page+ *)

PROCEDURE juggle_em;

(*****************************************************************************)
(*									     *)
(*		This procedure juggles the balls that have		     *)
(*		     been thrown in to Mr. Magnifico			     *)
(*									     *)
(*****************************************************************************)

VAR
	i,j : integer;

BEGIN
	for i := 1 to no_of_times_to_juggle do
		begin
			for j := 1 to no_juggle_balls do
				begin
					animate;
					wait(juggle_wait);
				end (* for j *);
		end (* for i *);
END (* juggle_em *);

(*$page+*)

PROCEDURE drop_one;

(****************************************************************************)
(*									    *)
(*		   This procedure will make Mr. Magnifico		    *)
(*		              drop a ball				    *)
(*									    *)
(****************************************************************************)

VAR
	i : integer;
	scr_pos_on : boolean;

BEGIN
	repeat
		animate;
		wait(toss_wait);		
		scr_pos_on := chk_scr_buff(juggle_address_array[12]);
	until scr_pos_on;

	draw_ball(juggle_address_array[12],false);
	draw_ball(drop_address_array[1],true);
	wait(toss_wait);

	for i := 1 to no_dropped_balls do
		begin
			animate;
			wait(toss_wait);
		end (* for *);
END (* drop_one *);

(*$page+*)


PROCEDURE juggle ;

(*****************************************************************************)
(*									     *)
(*		This procedure makes the juggler actually juggle!	     *)
(*									     *)
(*		It accomplishes this by taking the position arrays	     *)
(*		and calculating the screen buffer word addresses of	     *)
(*		the characters that are to be animated, then accesses	     *)
(*		these addresses and changes the display/non-display	     *)
(*		attribute contained in the upper 5 bits of the MSB.          *)
(*									     *)
(*****************************************************************************)

VAR
	i : integer;

BEGIN
	calc_scr_buff_addrs;

	for i := 1 to no_of_times_to_juggle do
		begin
			toss_one;
			juggle_em;
		end (* for *);

	repeat
		drop_one;
		juggle_em;
		toss_one;
		juggle_em;

		if DOSXQQ(11,0) = 255 then keypress := TRUE;
	until keypress;	

END (* juggle *);

(*$page+*)

(*****************************************************************************)
(*									     *)
(*				MAIN PROGRAM				     *)
(*									     *)
(*****************************************************************************)

BEGIN
	writeln(OUTPUT,disable_crsr);
	writeln(OUTPUT,clear_screen);
	calc_char_set_base;            
	draw_box(24,56,5,23);
	draw_juggler;
	draw_box(32,49,15,17);
	put_cursor(16,37,graph_title);	
	juggle;
	writeln(OUTPUT,enable_crsr);
END.
