PROGRAM man_example(INPUT,OUTPUT);

(*$LINESIZE:110*)
(*$PAGESIZE:44*)

(*****************************************************************************)
(*									     *)
(*			CHARACTER GRAPHICS EXAMPLE			     *)
(*			      FIGURE NO. 2				     *)
(*				MAN.PAS					     *)
(*									     *)
(*	By : David Hollifield						     *)
(*	Date : September 24, 1982					     *)
(*									     *)
(*****************************************************************************)

(*$page+*)

CONST

(*****************************************************************************)
(*									     *)
(*	Definition of Graphic Characters that are to be used in the	     *)
(*			following example				     *)
(*          								     *)
(*****************************************************************************)

	r_vert_line = ''   ;	l_vert_line = ''   ;	top_hor_line = '';   
	 l_face = ''  ;  r_face = ''  ;  l_side = ''  ;  r_side = '' ;
	        l_hand = '' ;  l_arm = ''  ;  l_shldr = ''  ;
		r_hand = ''  ;  r_arm = ''  ;  r_shldr = ''  ;
	l_foot = ''  ;  r_foot = ''  ;  ball = ''  ;  bot_hor_line = '';

(*****************************************************************************)
(*									     *)
(*			    VT52 display definitions			     *)
(*									     *)
(*****************************************************************************)

	escape = chr(27);
	clear_screen = escape * 'E';
	put_crsr = escape * 'Y';

	graph_title = 'MAGNIFICO';

(*page+*)


TYPE
	row_type = 1..24 ;

	col_type = 1..80 ;

(*$page+*)


PROCEDURE put_cursor(x : row_type; y : col_type; const out_str : string);

(*****************************************************************************)
(*									     *)
(*		This procedure places the cursor at the			     *)
(*		specified row and column and outputs the		     *)
(*		desired graphics character				     *)
(*									     *)
(*****************************************************************************)

CONST
	scr_off = 31;

BEGIN
	write(OUTPUT,put_crsr , chr (x + scr_off) , chr (y + scr_off));
	write(OUTPUT,out_str);
END;

(*$page+*)


PROCEDURE draw_box(col_strt, col_end : col_type; top_row, bot_row : row_type);

(*****************************************************************************)
(*									     *)
(*			      Box drawing procedure	 		     *)
(*									     *)
(*			This procedure will draw a box using		     *)
(*			the parameters passed to it as end-		     *)
(*			points of the resulting box			     *)
(*									     *)
(*****************************************************************************)

VAR
	i : integer;

BEGIN
	for i := col_strt to col_end do
		put_cursor(top_row,i,top_hor_line);
 
	for i := top_row to bot_row do
		put_cursor(i,col_end + 1,l_vert_line);

	for i := col_end downto col_strt do
		put_cursor(bot_row,i,bot_hor_line);

	for i := bot_row downto top_row do
		put_cursor(i,col_strt - 1,r_vert_line);
END (* put_cursor *);

(*$page+*)


PROCEDURE draw_juggler;

(*****************************************************************************)
(*									     *)
(*		      This procedure will draw the juggler		     *)
(*		      at the specified x,y coordinates using		     *)
(*		      the graphic characters defined by gr_ch		     *)
(*									     *)
(*****************************************************************************)

VAR
     gr_ch : lstring (10);

BEGIN
	  gr_ch := ball;
		  put_cursor(10,40,gr_ch);
	  
	  gr_ch := ball * '    ' * ball;	
		  put_cursor(11,38,gr_ch);

	  gr_ch := ball * '  ' * l_face * r_face * '  ' * ball;	       
		  put_cursor(12,37,gr_ch);

	  gr_ch := l_hand * l_arm * l_shldr * l_side * r_side *
				r_shldr * r_arm * r_hand;
	  	  put_cursor(13,37,gr_ch);

	  gr_ch := l_foot * r_vert_line * l_vert_line * r_foot;
		  put_cursor(14,39,gr_ch);
END (* draw_juggler *);
		
(*$page+*)


(*****************************************************************************)
(*									     *)
(*				MAIN PROGRAM				     *)
(*									     *)
(*****************************************************************************)

BEGIN
	writeln(OUTPUT,clear_screen);
	draw_box(10,71,5,23);
	draw_juggler;
	draw_box(32,49,15,17);
	put_cursor(16,37,graph_title);	
END.
