10000 'save "ASYNCCOM",a
10100 'Perform various options using asynchronous communications
10200 '
10300 'BEGIN set constants;  all options are zero relative
10400 NMBR.PRMTR.OPTS% =  8 :
      NMBR.DEV.OPTS%   =  1 :
      NMBR.SPD.OPTS%   = 14 :
      NMBR.PRTY.OPTS%  =  4 :
      NMBR.DAT.OPTS%   =  3
10500 NMBR.STP.OPTS%   =  1 :
      NMBR.LN.FD.OPTS% =  1 :
      NMBR.FIL.MODS%   =  1 :
      NMBR.DPLX.OPTS%  =  1 :
      NMBR.FILS%       =  3 :
      MX.LNS%          = 25
10600 '
10700 DIM DEV$( 8 ), SPD$( 14 ),
          PRTY.DSC$( 4 ), DAT$( 3 )
10800 DIM STP$( 1 ), LN.FD.OPT$( 1 ),
          FIL.MOD$( 1 ), DPLX.OPT$( 1 ),
          OPN.FIL%( 3 ), SCRN$( 25 )
10900 '
11000 DEV$(0) = "COM1:  (Port A)" :
      DEV$(1) = "COM2:  (Port B)"
11100 '
11200 SPD$( 0) = "    50 " :
      SPD$( 1) = "    75 " :
      SPD$( 2) = "   110 " :
      SPD$( 3) = "   150 " :
      SPD$( 4) = "   200 " :
      SPD$( 5) = "   300 " :
      SPD$( 6) = "   600 " :
      SPD$( 7) = "  1200 "
11300 SPD$( 8) = "  1800 " :
      SPD$( 9) = "  2000 " :
      SPD$(10) = "  2400 " :
      SPD$(11) = "  3600 " :
      SPD$(12) = "  4800 " :
      SPD$(13) = "  9600 " :
      SPD$(14) = " 19200 "
11400 '
11500 PRTY.DSC$(0) = "SPACE :  Parity Bit Always Transmitted and " +
                              "Received as Space (0 bit)."
11600 PRTY.DSC$(1) = "ODD   :  Odd Transmit/Receive Checking."
11700 PRTY.DSC$(2) = "MARK  :  Parity Bit Always Transmitted and " +
                              "Received as Mark (1 bit)."
11800 PRTY.DSC$(3) = "EVEN  :  Even Transmit and Receive Parity Checking."
11900 PRTY.DSC$(4) = "NONE  :  No Transmit Parity, no receive parity checking."
12000 NO.PRTY% = 4
12100 '
12200 DAT$(0) = " 5 " :
      DAT$(1) = " 6 " :
      DAT$(2) = " 7 " :
      DAT$(3) = " 8 " :
      FV.DAT.BITS% = 0 :
      EGHT.DAT.BITS% = 3
12300 '
12400 STP$(0) = " 1 " :
      STP$(1) = " 2 "
12500 '
12600 LN.FD.OPT$(0) = "SUPPRESS Line Feeds" :
      LN.FD.OPT$(1) = "TRANSMIT Line Feeds"
12700 '
12800 FIL.MOD$(0) = "BINARY Mode (Transmit/Receive a  Binary File)" :
      FIL.MOD$(1) = "ASCII  Mode (Transmit/Receive an ASCII  File)"
12900 '
13000 DPLX.OPT$(0) = "HALF Duplex (Local  Echo)" :
      DPLX.OPT$(1) = "FULL Duplex (Remote Echo)"
13100 '
13200 FALSE% = 0
13300 TRUE% = -1
13400 '
13500 DEV.OPT%     = 0      'COM1:  (Port A)    'assign default parameters
13600 SPD.OPT%     = 5      '300 baud
13700 PRTY.OPT%    = 3      'EVEN parity
13800 DAT.OPT%     = 2      '7 data bits
13900 STP.OPT%     = 0      '1 stop bit
14000 LN.FD.OPT%   = 0      'suppress line feeds
14100 LN.FD.OPT$   = ""
14200 FIL.MOD.OPT% = 1      'ASCII
14300 DPLX.OPT%    = 0      'half duplex
14400 HALF.DPLX%   = TRUE%
14500 '
14600 BELL$ = CHR$(7) :
      CR$ = CHR$(13) :
      XON$ = CHR$(17) :
      XOFF$ = CHR$(19) :
      CTRL.Z$ = CHR$(26) :
      ESC$ = CHR$(27)
14700 UP.CRSR$ = "H":
      DWN.CRSR$ = "P" :
      PRGRM.NM$ = "Asynchronous Communications"
14800 RETURN.TO.EXIT$ = " Press <RETURN> to Exit " :
      ESC.TO.EXIT$ = " Press <ESC> to Exit " :
      PRESS.Y.TO.CONFIRM$ = "Press (Y) to Confirm Exit:  "
14900 PRTY.DAT.ERR$ = "ILLEGAL PARITY/DATA BIT COMBINATION" + CHR$(7)
15000 ERR.LN% = 20 :
      ERR.CL% = 40 - LEN(PRTY.DAT.ERR$)/2
15100 CRSR.ON%  = 1 :
      CRSR.OFF% = 0
15200 COM.FIL% = 1 :
      SCRN%    = 2 :
      DSK.FIL% = 3     'file number for sending or receiving
15300 'END   set constants
15400 '
15500 'BEGIN main line
15600 CLOSE :
      KEY OFF
15700 LOCATE ,, CRSR.OFF%
15800 OPEN "SCRN:" FOR OUTPUT AS #SCRN% :
      WIDTH #SCRN%, 255      ' infinite width to prevent VBASICA from
15900 EXIT.PROG% = FALSE%    '    inserting extra line feeds
16000 SCRN$(22) = "Use UP & DOWN Cursor Keys to Highlight Option" :
      SCRN$(23) = "Press <RETURN> to Select Highlighted Option"
16100 MNU.OPT% = 0
16200 WHILE NOT EXIT.PROG%
16300     GOSUB 17900      'format main menu screen
16400     GOSUB 32700      'display screen
16500     GOSUB 33500      'get option; option is zero relative
16600     MNU.OPT% = OPT%
16700 '   on mnu.opt% + 1 gosub  dsply  chng   emulate  trans  rcv    exit
16800 '                          prmtrs prmrtr tty.term file   file
16900     ON MNU.OPT% + 1 GOSUB  18600, 20600, 36000,   39500, 46900, 55900
17000   WEND
17100 '
17200 CLOSE
17300 END
17400 'END   main line
17500 '
17600 'BEGIN subroutines
17700 '
17800 ' format main menu
17900 '
18000 OPT% = MNU.OPT% :
      NMBR.OPTS% = 5 :
      STRT.LN% = 10 :
      CL% = 25
18100 SCRN$(STRT.LN%    ) = "Display Communication Parameters" :
      SCRN$(STRT.LN% + 1) = "Change Communication Parameters" :
      SCRN$(STRT.LN% + 2) = "Emulate TTY Terminal"
18200 SCRN$(STRT.LN% + 3) = "Transmit a File" :
      SCRN$(STRT.LN% + 4) = "Receive a File" :
      SCRN$(STRT.LN% + 5) = "Quit"
18300 RETURN
18400 '
18500 '
18600 'format & display current communication parameters
18700 '
18800 SPD$ = STR$(VAL(SPD$(SPD.OPT%)))  'STR$ adds extra blank, remove it
18900 STRT.LN% = 10 :
      CL%      = 25
19000 GOSUB 54900
19100 LOCATE STRT.LN%    , CL% :
      PRINT "Device      :  " + DEV$(DEV.OPT%);
19200 LOCATE STRT.LN% + 1, CL% :
      PRINT "Speed (bps) :  " + RIGHT$(SPD$, LEN(SPD$) - 1);
19300 LOCATE STRT.LN% + 2, CL% :
      PRINT "Parity      :  " + LEFT$(PRTY.DSC$(PRTY.OPT%), 5);
19400 LOCATE STRT.LN% + 3, CL% :
      PRINT "Data Bits   :  " + MID$(DAT$(DAT.OPT%), 2, 1);
19500 LOCATE STRT.LN% + 4, CL% :
      PRINT "Stop Bits   :  " + MID$(STP$(STP.OPT%), 2, 1);
19600 LOCATE STRT.LN% + 5, CL% :
      PRINT "Line Feeds  :  " + LEFT$(LN.FD.OPT$(LN.FD.OPT%),8);
19700 LOCATE STRT.LN% + 6, CL% :
      PRINT "Mode        :  " + LEFT$(FIL.MOD$(FIL.MOD.OPT%), 6);
19800 LOCATE STRT.LN% + 7, CL% :
      PRINT "Duplex      :  " + LEFT$(DPLX.OPT$(DPLX.OPT%), 4);
19900 '
20000 LOCATE 22, 40 - LEN(RETURN.TO.EXIT$)/2
20100 COLOR 0,7 :
      PRINT RETURN.TO.EXIT$; :
      COLOR 7,0
20200 GOSUB 55400     'wait for keystroke
20300 RETURN
20400 '
20500 '
20600 'change communication parameters
20700 '
20800 IF OPN.FIL%(COM.FIL%)
         THEN LOCATE 20, 32 :
              PRINT "Please Wait ... "; :
              CLOSE COM.FIL% :
              OPN.FIL%(COM.FIL%) = FALSE%
20900 EXIT.SET.PRMTR% = FALSE%
21000 PRMTR.OPT% = 0
21100 WHILE NOT EXIT.SET.PRMTR%
21200     GOSUB 22300      'format change parameter screen
21300     GOSUB 32700      'display screen
21400     GOSUB 33500      'get option
21500     PRMTR.OPT% = OPT%
21600 '   on prmtr.opt% + 1 gosub chg    chg      chg     chg     chg
21700 '                           dev    speed    parity  dat bts stop bts
21800     ON PRMTR.OPT% + 1 GOSUB 23100, 24100,   25100,  26800,  28500,
                                  29600, 30700,   31700,  35500
21900   WEND  '                   chg    chg      chg     exit
22000 RETURN  '                   ln fd  fil mode dplx
22100 '
22200 '
22300 ' format change parameter screen
22400 '
22500 OPT% = PRMTR.OPT% :
      NMBR.OPTS% = NMBR.PRMTR.OPTS% :
      STRT.LN% = 10 :
      CL% = 30
22600 SCRN$(STRT.LN%    ) = "Change Device" :
      SCRN$(STRT.LN% + 1) = "Change Speed" :
      SCRN$(STRT.LN% + 2) = "Change Parity" :
      SCRN$(STRT.LN% + 3) = "Change Data Bits"
22700 SCRN$(STRT.LN% + 4) = "Change Stop Bits" :
      SCRN$(STRT.LN% + 5) = "Change Line Feed" :
      SCRN$(STRT.LN% + 6) = "Change File Mode" :
      SCRN$(STRT.LN% + 7) = "Change Duplex" :
      SCRN$(STRT.LN% + 8) = "Quit"
22800 RETURN
22900 '
23000 '
23100 ' display device values and get option
23200 '
23300 OPT% = DEV.OPT% :
      NMBR.OPTS% = NMBR.DEV.OPTS% :
      STRT.LN% = 10 :
      CL% = 30
23400 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = DEV$(LN%) :
        NEXT LN%
23500 GOSUB 32700       'display screen
23600 GOSUB 33500       'get option
23700 DEV.OPT% = OPT%
23800 RETURN
23900 '
24000 '
24100 ' display speed values and get option
24200 '
24300 OPT% = SPD.OPT% :
      STRT.LN% = 5 :
      NMBR.OPTS% = NMBR.SPD.OPTS% :
      CL% = 37
24400 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = SPD$(LN%) :
        NEXT LN%
24500 GOSUB 32700     'display screen
24600 GOSUB 33500     'get option
24700 SPD.OPT% = OPT%
24800 RETURN
24900 '
25000 '
25100 ' display parity values and get option
25200 '   if prty is NONE then the nmbr of data bits cannot be 5
25300 '   prty must be NONE if the nmbr of data bits is 8 
25400 '
25500 OPT% = PRTY.OPT% :
      NMBR.OPTS% = NMBR.PRTY.OPTS% :
      STRT.LN% = 10 :
      CL% = 6
25600 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = PRTY.DSC$(LN%) :
        NEXT LN%
25700 GOSUB 32700     'display screen
25800 '
25900 PRMTRS.OK% = FALSE%
26000 WHILE NOT PRMTRS.OK%
26100     GOSUB 33500     'get option
26200     IF (OPT% = NO.PRTY% AND DAT.OPT% = FV.DAT.BITS%)
             OR (OPT% <> NO.PRTY% AND DAT.OPT% = EGHT.DAT.BITS%)
                THEN LOCATE ERR.LN%,ERR.CL% : PRINT PRTY.DAT.ERR$;
                ELSE PRMTRS.OK% = TRUE%
26300   WEND
26400 PRTY.OPT% = OPT%
26500 RETURN
26600 '
26700 '
26800 ' display data bit values and get option
26900 '   if nmbr of data bits is 5 (opt% = 0) then parity cannot be NONE
27000 '   if nmbr of data bits is 8 (opt% = 3) then parity must be NONE
27100 '
27200 OPT% = DAT.OPT% :
      NMBR.OPTS% = NMBR.DAT.OPTS% :
      STRT.LN% = 10 :
      CL% = 40
27300 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = DAT$(LN%) :
        NEXT LN%
27400 GOSUB 32700     'display screen
27500 '
27600 PRMTRS.OK% = FALSE%
27700 WHILE NOT PRMTRS.OK%
27800     GOSUB 33500     'get option
27900     IF (OPT% = FV.DAT.BITS% AND PRTY.OPT% = NO.PRTY%)
             OR (OPT% = EGHT.DAT.BITS% AND PRTY.OPT% <> NO.PRTY%)
                THEN LOCATE ERR.LN%,ERR.CL% : PRINT PRTY.DAT.ERR$;
                ELSE PRMTRS.OK% = TRUE%
28000   WEND
28100 DAT.OPT% = OPT%
28200 RETURN
28300 '
28400 '
28500 ' display stop bit values and get option
28600 '
28700 OPT% = STP.OPT% :
      NMBR.OPTS% = NMBR.STP.OPTS% :
      STRT.LN% = 10 :
      CL% = 40
28800 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = STP$(LN%) :
        NEXT LN%
28900 GOSUB 32700     'display screen
29000 GOSUB 33500     'get option
29100 STP.OPT% = OPT%
29200 RETURN
29300 '
29400 '
29500 ' display line feed values and get option
29600 '
29700 OPT% = LN.FD.OPT% :
      NMBR.OPTS% = NMBR.LN.FD.OPTS% :
      STRT.LN% = 10 :
      CL% = 30
29800 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = LN.FD.OPT$(LN%) :
        NEXT LN%
29900 GOSUB 32700     'display screen
30000 GOSUB 33500     'get option
30100 LN.FD.OPT% = OPT%
30200 IF LN.FD.OPT% = 0
         THEN LN.FD.OPT$ = ""
         ELSE LN.FD.OPT$ = ",LF"
30300 RETURN
30400 '
30500 '
30600 ' display file mode values and get option
30700 '
30800 OPT% = FIL.MOD.OPT% :
      NMBR.OPTS% = NMBR.FIL.MODS% :
      STRT.LN% = 10 :
      CL% = 40 - LEN(FIL.MOD$(0))/2
30900 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = FIL.MOD$(LN%) :
        NEXT LN%
31000 GOSUB 32700     'display screen
31100 GOSUB 33500     'get option
31200 FIL.MOD.OPT% = OPT%
31300 RETURN
31400 '
31500 '
31600 ' display duplex values and get option
31700 '
31800 OPT% = DPLX.OPT% :
      NMBR.OPTS% = NMBR.DPLX.OPTS% :
      STRT.LN% = 10 :
      CL% = 28
31900 FOR LN% = 0 TO NMBR.OPTS% :
          SCRN$(STRT.LN% + LN%) = DPLX.OPT$(LN%) :
        NEXT LN%
32000 GOSUB 32700     'display screen
32100 GOSUB 33500     'get option
32200 DPLX.OPT% = OPT%
32300 IF DPLX.OPT% = 0
         THEN HALF.DPLX% = TRUE%
         ELSE HALF.DPLX% = FALSE%
32400 RETURN
32500 '
32600 '
32700 'display screen
32800 '
32900 GOSUB 54900   'print heading
33000 FOR LN% = 0 TO NMBR.OPTS% :
          LOCATE STRT.LN% + LN%, CL% :
          PRINT SCRN$(STRT.LN% + LN%) :
        NEXT LN%
33100 FOR LN% = 22 TO 23 :
          LOCATE LN%, 40 - LEN(SCRN$(LN%))/2 :
          PRINT SCRN$(LN%); :
        NEXT LN%
33200 RETURN
33300 '
33400 '
33500 'get option
33600 '
33700 EXIT.GET.OPT% = FALSE%
33800 WHILE NOT EXIT.GET.OPT%
33900     LOCATE STRT.LN% + OPT%, CL%     'hi-lite option
34000     COLOR 0,7 :
          PRINT SCRN$(STRT.LN% + OPT%) :
          COLOR 7,0
34100     GOSUB 55400     'wait for keystroke
34200     IF CHAR$ = CR$ THEN EXIT.GET.OPT% = TRUE% : GOTO 35100
34300     IF LEN(CHAR$) > 2 THEN 35100
34400     CHAR$ = RIGHT$(CHAR$, 1)
34500     IF CHAR$ <> UP.CRSR$ AND CHAR$ <> DWN.CRSR$ THEN 35100
34600     OLD.OPT% = OPT%
34700     IF CHAR$ = DWN.CRSR$
            THEN OPT% = (OPT% + 1) MOD (NMBR.OPTS% + 1)
            ELSE OPT% = (OPT% - 1) MOD (NMBR.OPTS% + 1)
34800     IF OPT% < 0 THEN OPT% = NMBR.OPTS%
34900     LOCATE STRT.LN% + OLD.OPT%, CL%  'change old hi-lite option to normal
35000     COLOR 7,0 :
          PRINT SCRN$(STRT.LN% + OLD.OPT%) :
          COLOR 0,7
35100   WEND
35200 RETURN
35300 '
35400 '
35500 'exit set communication parameters
35600 '
35700 EXIT.SET.PRMTR% = TRUE% :
      RETURN
35800 '
35900 '
36000 'emulate very simple TTY terminal
36100 '  display any characters entered from keyboard on screen and send to
36200 '  comms port
36300 '  display any characters received through comms port on screen;
36400 '  if the input buffer becomes more than half full, tell host to stop
36500 '  transmitting (XOFF$); after buffer is emptied, tell host to begin 
36600 '  again (XON$)
36700 '
36800 GOSUB 38700    'display 25th ln
36900 IF NOT OPN.FIL%(COM.FIL%) THEN GOSUB 51300    'open COM file
37000 LOCATE ,, CRSR.ON%
37100 EXIT% = FALSE%
37200 WHILE NOT EXIT%  'loop while checking for keyboard and com input
37300     CHAR$=INKEY$
37400     IF CHAR$ <> ""
             THEN IF CHAR$ = ESC$
                     THEN EXIT%=TRUE% : GOTO 38100 :
                     ELSE PRINT #COM.FIL%, CHAR$; :
                          IF HALF.DPLX% THEN PRINT #SCRN%, CHAR$;
37500     WHILE LOC(COM.FIL%) > 0
37600         IF LOC(COM.FIL%) < 128
                 THEN
                   PRINT #SCRN%,INPUT$(LOC(COM.FIL%), COM.FIL%); :
                   GOTO 38000
37700         PRINT #COM.FIL%,XOFF$;
37800         WHILE LOC(COM.FIL%) > 64 :
                  PRINT #SCRN%,INPUT$(LOC(COM.FIL%), COM.FIL%); :
                WEND
37900         PRINT #COM.FIL%, XON$;
38000       WEND  ' loc(com.fil%) > 0
38100   WEND  ' not exit%
38200 CLS
38300 LOCATE ,,CRSR.OFF%
38400 RETURN
38500 '
38600 '
38700 'display message on 25th line; as lines scroll on screen line 25 
38800 '    will not change
38900 CLS
39000 LOCATE 25, 1 :
      PRINT SCRN$(STRT.LN% + MNU.OPT%);
39100 LOCATE 25, 60 :
      COLOR 0, 7 :
      PRINT ESC.TO.EXIT$; :
      COLOR 7, 0 :
      LOCATE 1, 1
39200 RETURN
39300 '
39400 '
39500 'transmit (up-load) a file
39600 '
39700 EXIT% = FALSE%
39800 WHILE NOT EXIT%
39900     MSSG$ = "Enter Name of File to Transmit" :
          GOSUB 42400    'get name of file to transmit
40000     IF EXIT% THEN GOTO 42000
40100     IF NOT OPN.FIL%(COM.FIL%) THEN GOSUB 51300    'open COM file
40200     GOSUB 54900 :
          MSSG$ = "Transmitting File:  " :
          GOSUB 50300    'display count screen
40300     TERMINATE% = FALSE% :
          GOSUB 44500    'wait for CR from destination
40400     IF TERMINATE% THEN GOTO 42000
40500     CHAR.NMBR# = 0
40600     WHILE (DSK.SIZ% > NMBR.CHARS%) AND NOT TERMINATE%
40700         WHILE LOC(COM.FIL%) > 0 AND NOT TERMINATE% :
                  IF INPUT$(1, #COM.FIL%) = XOFF$
                     THEN GOSUB 45900  ' Wait for XON$
40800           WEND  '  loc(com.fil%) > 0 and not terminate%
40900         IF TERMINATE% THEN GOTO 41300
41000         GOSUB 50800   'display char count
41100         GET #DSK.FIL%, DSK.REC% :
              DSK.REC% = DSK.REC% + 1 :
              DSK.SIZ% = DSK.SIZ% - NMBR.CHARS% :
              PRINT #COM.FIL%, DSK.REC$;
41200         IF INKEY$ = ESC$ THEN GOSUB 52700  'confirm intent
41300       WEND  '  (dsk.siz% > nmbr.chars%) and not terminate%
41400     IF TERMINATE% THEN GOTO 41800
41500     NMBR.CHARS% = DSK.SIZ% :
          GOSUB 50800   'display char count
41600     GET #DSK.FIL%, DSK.REC% :
          DSK.REC% = DSK.REC% + 1
41700     PRINT #COM.FIL%, LEFT$(DSK.REC$, DSK.SIZ%); CTRL.Z$;
                                    ' Last part & to mark EOF
41800     IF TERMINATE%
            THEN MSSG$ = "** Transmission Terminated **"
            ELSE MSSG$ = "** Transmission Completed **"
41900     GOSUB 54000
42000   WEND
42100 RETURN
42200 '
42300 '
42400 'get name of disk file to transmit and check residency
42500 '  check residency by opening file for sequential input; VBASICA
42600 '  will return an error only if a file opened for sequential input 
42700 '  is not resident
42800 '
42900 GOSUB 54900
43000 ON ERROR GOTO 43600
43100 FILE.FOUND% = FALSE%
43200 WHILE NOT FILE.FOUND% AND NOT EXIT%
43300     GOSUB 49400     'get name of file
43400     IF EXIT% THEN 43800
43500     OPEN DSK.FIL$ FOR INPUT AS #DSK.FIL% :
          CLOSE DSK.FIL% :
          FILE.FOUND% = TRUE% :
          GOTO 43800
43600     LOCATE ERR.LN%, 40 - LEN(ER$)/2 :
          PRINT STRING$(LEN(ER$), " ");
43700     ER$ = " FILE <" + DSK.FIL$ + "> NOT FOUND " :
          LOCATE ERR.LN%, 40 - LEN(ER$)/2 :
          COLOR 0,7 :
          PRINT ER$ + CHR$(7); :
          COLOR 7,0 :
          RESUME 43800
43800   WEND
43900 IF FILE.FOUND%
        THEN
          NMBR.CHARS% = 128 :
          OPEN DSK.FIL$ AS #DSK.FIL% LEN = NMBR.CHARS% :
          FIELD #DSK.FIL%, NMBR.CHARS% AS DSK.REC$ :
          DSK.SIZ% = LOF(DSK.FIL%) :
          DSK.REC% = 1
44000 ON ERROR GOTO 0
44100 LOCATE ,,CUR.OFF%
44200 RETURN
44300 '
44400 '
44500 'wait for CR$ from host before beginning transmission
44600 '
44700 MSSG$ = "Waiting for Signal From Destination Before Starting Transmission"
44800 LOCATE 16, 40 - LEN(MSSG$)/2 :
      PRINT MSSG$;
44900 GOSUB 53500
45000 CR% = FALSE%
45100 WHILE NOT TERMINATE% AND NOT CR%
45200     IF LOC(COM.FIL%) > 0
            THEN IF INPUT$(1, #COM.FIL%) = CR$
                    THEN CR% = TRUE%
45300     IF INKEY$ = ESC$ THEN GOSUB 52700  ' confirm intent
45400   WEND
45500 LOCATE 16, 40 - LEN(MSSG$)/2 :
      PRINT STRING$(LEN(MSSG$), " ");
45600 RETURN
45700 '
45800 '
45900 'wait for XON$ from host before continuing transmission
46000 '
46100 XON% = FALSE%
46200 WHILE NOT TERMINATE% AND NOT XON%
46300     WHILE LOC(COM.FIL%) > 0 AND NOT XON% :
              IF INPUT$(1, #COM.FIL%) = XON$ THEN XON% = TRUE% :
            WEND
46400     IF INKEY$ = ESC$ THEN GOSUB 52700  'confirm intent
46500   WEND
46600 RETURN
46700 '
46800 '
46900 'receive (down-load) a file
47000 '
47100 GOSUB 54900
47200 EXIT% = FALSE%
47300 WHILE NOT EXIT%
47400     MSSG$ = "Enter Name of File to Receive" :
          GOSUB 49400        'get name of file
47500     IF EXIT% THEN GOTO 49000
47600     GOSUB 54900 :
          MSSG$ = "   Receiving File:  " :
          GOSUB 50300 :
          OPEN DSK.FIL$ FOR OUTPUT AS #DSK.FIL%
47700     IF NOT OPN.FIL%(COM.FIL%) THEN GOSUB 51300   'open COM file
47800     PAUSE% = FALSE% :
          CHAR.NMBR# = 0 :
          COM.FIL.EOF% = FALSE% :
          TERMINATE% = FALSE% :
          PRINT #COM.FIL%, CR$;       'to begin download
47900     WHILE NOT COM.FIL.EOF% AND NOT TERMINATE%
48000         IF EOF(COM.FIL%)
                 THEN GOSUB 51900 :
                      GOTO 48700
48100         IF LOC(COM.FIL%) < 128 THEN GOTO 48500
48200         PRINT #COM.FIL%, XOFF$;
48300         WHILE LOC(COM.FIL%) > 64 :
                  NMBR.CHARS% = LOC(COM.FIL%) :
                  GOSUB 50800 :
                  PRINT #DSK.FIL%, INPUT$(NMBR.CHARS%, #COM.FIL%); :
                WEND  ' loc(com.fil%) > 64
48400         PRINT #COM.FIL%, XON$;
48500         IF LOC(COM.FIL%) > 0 
                 THEN NMBR.CHARS% = LOC(COM.FIL%) :
                      GOSUB 50800 :
                      PRINT #DSK.FIL%, INPUT$(NMBR.CHARS%, #COM.FIL%);
48600         IF INKEY$ = ESC$ THEN GOSUB 52700  'confirm intent
48700       WEND  '  not com.fil.eof% and not terminate%
48800     IF TERMINATE%
             THEN MSSG$ = "** Reception Terminated **"
             ELSE MSSG$ = "** Reception Completed **"
48900     GOSUB 54000
49000   WEND  '  not exit%
49100 RETURN
49200 '
49300 '
49400 'get name of file
49500 '
49600 CL% = 10 :
      LOCATE 10, CL% :
      PRINT "Enter Name of File (d:filename.ext):                   ";
49700 LOCATE 11, CL% + 16 :
      PRINT "or <RETURN> to Exit"; :
      LOCATE 17, 40 - LEN(MSSG$)/2 :
      PRINT MSSG$; :
      LOCATE 10, CL% + 39, CRSR.ON%
49800 INPUT; "", DSK.FIL$ :
      LOCATE , , CRSR.OFF%
49900 IF DSK.FIL$ = "" THEN EXIT% = TRUE%
50000 RETURN
50100 '
50200 '
50300 'display count screen
50400 '
50500 LOCATE 10, 24 :
      PRINT MSSG$ + DSK.FIL$; :
      LOCATE 12, 24 :
      PRINT " Character Number:           0" :
      GOSUB 53500 :
      RETURN
50600 '
50700 '
50800 'display character count
50900 '
51000 CHAR.NMBR# = CHAR.NMBR# + NMBR.CHARS% :
      LOCATE 12, 44 :
      PRINT USING "##,###,###"; CHAR.NMBR#; :
      RETURN
51100 '
51200 '
51300 'open communication file
51400 '
51500 'COM.FIL$ = LEFT$(DEV$(DEV.OPT%), 5) + SPD$(SPD.OPT%) + "," +
         LEFT$(PRTY.DSC$(PRTY.OPT%), 1)  + "," + DAT$(DAT.OPT%) + "," +
         STP$(STP.OPT%) + LN.FD.OPT$ + "," + LEFT$(FIL.MOD$(FIL.MOD.OPT%),3)
51510 SPD$ = RIGHT$(STR$(VAL(SPD$(SPD.OPT%))), LEN(STR$(VAL(SPD$(SPD.OPT%))))-1)
51520 DAT$ = RIGHT$(STR$(VAL(DAT$(DAT.OPT%))), LEN(STR$(VAL(DAT$(DAT.OPT%))))-1)
51530 STP$ = RIGHT$(STR$(VAL(STP$(STP.OPT%))), LEN(STR$(VAL(STP$(STP.OPT%))))-1)
51550 COM.FIL$=  LEFT$(DEV$(DEV.OPT%), 5) + SPD$ + "," +
         LEFT$(PRTY.DSC$(PRTY.OPT%), 1)  + "," + DAT$ + "," +
         STP$ + LN.FD.OPT$
51600 OPEN COM.FIL$ AS #COM.FIL% :
      OPN.FIL%(COM.FIL%) = TRUE% :
      RETURN
51700 '
51800 '
51900 ' Wait for more characters until Time Out
52000 '
52100 TIME.OUT.CNT% = 0 :
      COM.FIL.EOF% = TRUE%
52200 WHILE COM.FIL.EOF% AND TIME.OUT.CNT% < 1000 AND NOT TERMINATE% :
          TIME.OUT.CNT% = TIME.OUT.CNT% + 1 :
          COM.FIL.EOF% = EOF(COM.FIL%) :
          IF INKEY$ = ESC$ THEN GOSUB 52700
52300   WEND
52400 RETURN
52500 '
52600 '
52700 'confirm intent to exit
52800 '
52900 LOCATE 22, 40 - LEN(PRESS.Y.TO.CONFIRM$)/2, CRSR.ON% :
      PRINT PRESS.Y.TO.CONFIRM$; :
      INPUT; "", CHAR$
53000 LOCATE 22, 40 - LEN(PRESS.Y.TO.CONFIRM$)/2, CRSR.OFF% :
      PRINT STRING$(LEN(PRESS.Y.TO.CONFIRM$) + 10, " ") :
      CHAR$ = LEFT$(CHAR$, 1)
53100 IF CHAR$ = "y" OR CHAR$ = "Y"
         THEN TERMINATE% = TRUE%
         ELSE GOSUB 53600
53200 RETURN
53300 '
53400 '
53500 'print esc mssg
53600 '
53700 LOCATE 22,40 - LEN(ESC.TO.EXIT$)/2 :
      COLOR 0,7 :
      PRINT ESC.TO.EXIT$; :
      COLOR 7,0 :
      RETURN
53800 '
53900 '
54000 ' Function completed
54100 '
54200 CLOSE DSK.FIL%
54300 LOCATE 22,10 :
      PRINT STRING$(60, " "); :
      LOCATE 23,10 :
      PRINT STRING$(60, " ");
54400 LOCATE 22, 40 - LEN(MSSG$)/2 :
      PRINT MSSG$ + BELL$; :
      LOCATE 23, 40 - LEN(RETURN.TO.EXIT$)/2 :
      PRINT RETURN.TO.EXIT$;
54500 GOSUB 55400 :
      CLS
54600 RETURN
54700 '
54800 '
54900 'print heading
55000 '
55100 CLS :
      LOCATE 1, 40 - LEN(PRGRM.NM$)/2 :
      PRINT PRGRM.NM$; :
      RETURN
55200 '
55300 '
55400 'wait for keystroke
55500 '
55600 CHAR$ = "" :
      WHILE CHAR$ = "" :
          CHAR$ = INKEY$ :
        WEND :
      RETURN
55700 '
55800 '
55900 'exit program
56000 '
56100 EXIT.PROG% = TRUE% :
      CLS :
      KEY ON
56200 MSSG$ = "Normal End of Program" :
      LOCATE 10, 40 - LEN(MSSG$)/2 :
      PRINT MSSG$; :
      LOCATE 15, 1, CRSR.ON% :
      RETURN
56300 '
56400 'END   subroutines
56500 'END   ASYNCCOM
56600 END
