#include "stdio.h"

#define fabs(A) (((A)>0.0) ? (A) : -(A))
#define sign(x) ((x == 0.0) ? 1.0 : x/fabs(x))

#define MAXDIM 81
/* MAXDIM = 81 is a little dangerous. If you are storing much else use 41.*/

extern double cos();

/* This program is a test for the program qsol. The program creates an
   orthogonal matrix, a, and a right hand side b. The solution to Ax=b
   is known exactly and subtracted from the x given by qsol.
   The function fabs() is given by a macro to speed things up.
*/
main()
{
	double a[MAXDIM][MAXDIM],b[MAXDIM],x[MAXDIM],z,y,y1;
	double u[MAXDIM],norm;
	double *g[MAXDIM],b1[MAXDIM];
	int i,j,n1,j1,n;

	/* n = dimension of problem <= MAXDIM.	*/

	n=50;  /* With n=50 this code runs in 11.20 sec on an AT. */

	n1=n-1;
	norm=0.0;

	/* Create the matrix and the right hand side. */

	for(i=0;i<n;i++)
	{
		u[i]=cos(3.0+i);
		b[i]=-u[i];
		norm=norm+(u[i]*u[i]);
	}
	for(i=0;i<n;i++)
	{
		for(j=0;j<i;j++)
		{
			a[i][j]=-2.0*u[i]*u[j]/norm;
			a[j][i]=a[i][j];
		}
		a[i][i]=1.0-2.0*u[i]*u[j]/norm;
	}

	/* The qsol function requires an array of pointers to the rows of A. */

	for(i=0;i<n;i++)
	{
		b1[i]=b[i];
		g[i]=a[i];
	}

	/* Solve the system. */

	qsol(g,b1,x,n);

	/* Compute and print the exact residual. */

	z=0.0;
	for(i=0;i<n;i++)
	{	z+=fabs(u[i]-x[i]);
	}
	printf("%30.15e\n",z);
}
