;=======================================================================     
; VT52			VT/52-Terminal Emulator f}r IBM PC 
;			emuliert Screen Codes von:
;			Zenith Z 19, Victor 9000, etc. 
;
;
;			Axel Dahmen, Bergfrede 21, 4236 Hamminkeln
;			01.08.1985
;========================================================================
ESC             equ     1bh    	; Escape
CR              equ     0dh     ; Carrriage Return
DEL             equ     7fh     ; Del
VIDEO_IO        equ     10h     ; Interrupt Video-Ein-/Ausgabe
SET_MODES       equ     0       ; Modus einstellen
CURSOR_TYPE     equ     1       ; Cursorgr|sse einstellen
SET_POSITION    equ     2       ; Cursor Positionieren
SCROLL_UP       equ     6       ; nach oben scrollen
SCROLL_DN       equ     7       ; nach unten scrollen
CLEAR           equ     0600h   ; Sonderfall Scroll: Bereich l|schen
WRITE_CHAR      equ     9       ; Zeichen und Attribut ausgeben
WRITE_TTY       equ     14      ; Zeichen ausgeben
VIDEO_STATE     equ     15      ; Video-Status
KEYBOARD_IO     equ     16h     ; Interrupt Tastatur_Eingabe
KEY_READ        equ     0       ; n{chste Taste von Tastatur lesen
KEY_STATUS      equ     1       ; Abfrage ob Taste gedr}ckt
BRKADR          equ     4*1bh   ; Break_Interrupt Adresse
DOS_CHAR_OUT    equ     4*29h   ; DOS-Zeichenausgabe-Interrupt Adresse
BUFFER_HEAD     equ     041ah   ; Zeiger auf Tastaturpuffer, Anfang
BUFFER_TAIL     equ     041ch   ; und Ende. Wenn gleich, Puffer leer
TRUE            equ     1       ; logisch wahr
FALSE           equ     0       ; logisch falsch
CMD             equ     2       ; Feld f}r Befehlscode
STATUS          equ     3       ; Statusfeld
CHAR            equ     13      ; gelesenes Zeichen
TRANS           equ     14      ; Pufferadresse
ENDADR          equ     14      ; Endeadresse
COUNT           equ     18      ; Byte-Z{hler
;===============================; Vorspann f}r Einheitentreiber
code            segment byte
assume          cs:code,ds:nothing,es:nothing
condev          dd      -1      ; Zeiger auf n{chste Einheit
                dw      1000000000010011b ; Attribut
                dw      strategy; Einheiten-Strategie
                dw      entry   ; Einheiten-Interrupt
                db      "CON     "      ; Einheiten-Name
contbl          dw      con_init; Initialisierung
                dw      exit    ; (Medium }berpr}fen)
                dw      exit    ; (BPB aufbauen)
                dw      cmderr  ; IOCTL (nicht bei Zeichen-Einheit)
                dw      con_read; Eingabe
                dw      con_rdnd; nicht-destruktiver Eingabe ohne Warten
                dw      exit    ; (Eingabe-Status)
                dw      con_flsh; Eingabe-Puffer l|schen
                dw      con_writ; Ausgabe
                dw      con_writ; Ausgabe mit Verify
                dw      exit    ; (Ausgabe-Status)
                dw      exit    ; (Ausgabe rausschreiben)
ptrsav          dd      0       ; Sicherungsbereich f}r Zeiger
;===============================; Variablen
altah           db      0       ; Flag f}r Scan-Code & Ctrl-C
state           dw      char_test ; Zeiger auf die aktuelle Routine
modcol          label   word    ; Label f}r Wort-Adressierung
mode            db      3       ; Bildschirmmodus
maxcol          db      79      ; max. Anzahl Spalten -1
maxrow          db      24      ; max. Anzahl Zeilen -1
curpos          label   word    ; Label f}r Wort-Adressierung
col             db      0       ; aktuelle Spalte
line            db      0       ; aktuelle Zeile
savcr           dw      0       ; Cursorposition merken (ESC j)
conflg          db      0       ; Anzahl Zeichen im Ausgabepuffer
tabptr          dw      0       ; Zeiger auf aktuellen Ausgabepuffer
rev             db      FALSE   ; Flag f}r revers ein/aus
und             db      FALSE   ; Flag f}r unterstreichen ein/aus
wrap            db      TRUE    ; Kennzeichen wrap am Zeilenende
cursor_flag     db      TRUE    ; Flag f}r Cursor ein/aus
cstr            db      0       ; Cursor-Start
cend            db      7       ; Cursor-Ende
cattw           label   word    ; f}r Wort-Adressierung
catt            db      00000111b ; Zeichenattribut
bpag            db      0       ; aktuelle Bildschirmseite
modtbl          db      0,1,2,3,1,1,3,7 ; Wandlung Bildschirmmodi
;=======================================; Sprungtabelle Steuerzeichen
ctltbl          dw      outchr          ; 00, nul
                dw      outchr          ; 01, soh
                dw      outchr          ; 02, stx
                dw      outchr          ; 03, etx
                dw      outchr          ; 04, eot
                dw      outchr          ; 05, enq
                dw      outchr          ; 06, ack
                dw      bell            ; 07, bel
                dw      backspace       ; 08, bs
                dw      hor_tab         ; 09, ht
                dw      line_feed       ; 10, lf
                dw      outchr          ; 11, vt
                dw      outchr          ; 12, ff
                dw      carriage_return ; 13, cr
                dw      outchr          ; 14, so
                dw      outchr          ; 15, si
                dw      outchr          ; 16, dle
                dw      outchr          ; 17, dc1
                dw      outchr          ; 18, dc2
                dw      outchr          ; 19, dc3
                dw      outchr          ; 20, dc4
                dw      outchr          ; 21, nak
                dw      outchr          ; 22, syn
                dw      outchr          ; 23, etb
                dw      passthru        ; 24, can
                dw      outchr          ; 25, em
                dw      outchr          ; 26, sub
                dw      escape          ; 27, esc
                dw      outchr          ; 28, fs
                dw      outchr          ; 29, gs
                dw      outchr          ; 30, rs
                dw      outchr          ; 31, us
;=======================================; Sprungtabelle Escape-Codes
cmdtbl          dw      passthru        ; " "
                dw      passthru        ; "!"
                dw      passthru        ; """
                dw      passthru        ; "#"
                dw      passthru        ; "$"
                dw      passthru        ; "%"
                dw      passthru        ; "&"
                dw      passthru        ; "'"
                dw      foreground      ; "(" h|here Intensit{t ein
                dw      background      ; ")" h|here Intensit{t aus
                dw      passthru        ; "*"
                dw      passthru        ; "+"
                dw      passthru        ; ","
                dw      passthru        ; "-"
                dw      passthru        ; "."
                dw      passthru        ; "/"
                dw      set_underline   ; "0" unterstreichen ein
                dw      reset_underline ; "1" unterstreichen aus
                dw      crs_on          ; "2" Cursor ein
                dw      crs_off         ; "3" Cursor aus
                dw      passthru        ; "4"
                dw      passthru        ; "5"
                dw      passthru        ; "6"
                dw      passthru        ; "7"
                dw      passthru        ; "8"
                dw      passthru        ; "9"
                dw      passthru        ; ":"
                dw      passthru        ; ";"
                dw      passthru        ; "<"
                dw      passthru        ; "="
                dw      passthru        ; ">"
                dw      passthru        ; "?"
                dw      passthru        ; "@"
                dw      cursor_up       ; "A" Cursor nach oben
                dw      cursor_down     ; "B" Cursor nach unten
                dw      cursor_right    ; "C" Cursor nach rechts
                dw      cursor_back     ; "D" Cursor nach links
                dw      clrscr          ; "E" Bildschirm l|schen
                dw      passthru        ; "F"
                dw      passthru        ; "G"
                dw      cursor_home     ; "H" Cursor in Home-Position
                dw      passthru        ; "I"
                dw      era_eop         ; "J" Bildschirmende l|schen
                dw      era_eol         ; "K" Zeilenende l|schen
                dw      ins_line        ; "L" Zeile einf}gen
                dw      del_line        ; "M" Zeile l|schen
                dw      passthru        ; "N"
                dw      passthru        ; "O"
                dw      passthru        ; "P"
                dw      passthru        ; "Q"
                dw      passthru        ; "R"
                dw      passthru        ; "S"
                dw      passthru        ; "T"
                dw      passthru        ; "U"
                dw      passthru        ; "V"
                dw      passthru        ; "W"
                dw      passthru        ; "X"
                dw      pos_cursor      ; "Y" Cursor positionieren
                dw      passthru        ; "Z"
                dw      passthru        ; "["
                dw      passthru        ; "\"
                dw      passthru        ; "]"
                dw      passthru        ; "^"
                dw      passthru        ; "_"
                dw      passthru        ; "`"
                dw      passthru        ; "a"
                dw      era_bop         ; "b" Bildschirmanfang l|schen
                dw      passthru        ; "c"
                dw      passthru        ; "d"
                dw      passthru        ; "e"
                dw      passthru        ; "f"
                dw      passthru        ; "g"
                dw      passthru        ; "h"
                dw      passthru        ; "i"
                dw      save_cursor     ; "j" Cursorposition speichern
                dw      set_saved_pos   ; "k" Cur.pos.wiederherstellen
                dw      era_lin         ; "l" ganze Zeile l|schen
                dw      passthru        ; "m"
                dw      passthru        ; "n"
                dw      era_bol         ; "o" Zeilenanfang l|schen
                dw      ent_rev_mde     ; "p" Revers ein
                dw      exit_rev_mde    ; "q" Revers aus
                dw      passthru        ; "r"
                dw      passthru        ; "s"
                dw      passthru        ; "t"
                dw      passthru        ; "u"
                dw      wrap_eol        ; "v" Wrap ein
                dw      discard_eol     ; "w" Wrap aus
                dw      passthru        ; "x"
                dw      passthru        ; "y"
                dw      reset_all       ; "z" Terminal zur}cksetzen
                dw      passthru        ; "{"
                dw      passthru        ; "|"
                dw      passthru        ; "}"
                dw      passthru        ; "~"
;===============================================; Wandl.tab. Scan-Codes
scan            db      059,2,ESC,"P",000       ; F1
                db      060,2,ESC,"Q",000       ; F2
                db      061,2,ESC,"R",000       ; F3
                db      062,2,ESC,"S",000       ; F4
                db      065,3,ESC,"?","l"       ; F7
                db      066,3,ESC,"?","n"       ; F8
                db      067,3,ESC,"?","m"       ; F9
                db      068,1,010,000,000       ; F10
                db      072,2,ESC,"A",000       ; Cursor nach oben
                db      075,2,ESC,"D",000       ; Cursor nach links
                db      077,2,ESC,"C",000       ; Cursor nach rechts
                db      080,2,ESC,"B",000       ; Cursor nach unten
                db      083,1,127,000,000       ; Del
                db      255                     ; Tabellenende
;=======================================; Einheitentreiber-Strategie
stratp          proc    far
strategy:       mov     word ptr cs:[ptrsav],bx
                mov     word ptr cs:[ptrsav+2],es
                ret
stratp          endp

entry:          push    si              ; Register sichern
                push    ax
                push    cx
                push    dx
                push    di
                push    bp
                push    ds
                push    es
                push    bx
                lds     bx,cs:[ptrsav]  ; BX und DS laden
                mov     cx,word ptr ds:[bx].COUNT       ; Anzahl nach CX
                mov     al,byte ptr ds:[bx].CMD         ; Kommando in AL
                cbw                     ; in Zeiger auf Routine wandeln
                mov     si,offset contbl
                add     si,ax
                add     si,ax
                cmp     al,11           ; max. Anzahl Einheitenroutinen
                ja      cmderr          ; unzul{ssiges Kommando
                les     di,dword ptr ds:[bx].TRANS
                                        ; Pufferadresse nach ES:DI
                assume  ds:code
                push    cs              ; DS = CS
                pop     ds
                jmp     word ptr [si]   ; Routine anspringen
;=======================================; Einheitentreiber -Ausgang
bus_exit:       mov     ah,00000011b    ; Status: busy, ok
                jmp     short err1
cmderr:         mov     al,3            ; Fehler: Unbekanntes Kommando
err_exit:       mov     ah,10000001b    ; Fehlerbit setzen
                jmp     short err1
exitp           proc    far
exit:           mov     ah,00000001b    ; Status: kein Fehler
err1:           lds     bx,cs:[ptrsav]
                mov     word ptr [bx].STATUS,ax
                pop     bx              ; Register wiederherstellen
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     dx
                pop     cx
                pop     ax
                pop     si
                ret
exitp           endp

break:          mov     cs:altah,3      ; neue BREAK-Routine
                iret
;=======================================; Zeichen von Tastatur lesen
con_read:       jcxz    con_exit        ; wenn keine Anzahl, dann Ende
con_loop:       push    cx              ; Anzahl merken
                call    chrin           ; Taste lesen
                pop     cx              ; Anzahl wiederherstellen
                stosb                   ; Taste speichern
                loop    con_loop	; Schleife f}r Anzahl
con_exit:       jmp     exit            ; Routine beenden

chrin:          xor     ax,ax           ; wenn Zeichen in altah
                xchg    al,altah        ; dann erst dieses }bergeben
                or      al,al           ; (z.b. Ctrl-Break/Scan-Code)
                jnz     keyret
inagn:          cmp     conflg,0        ; irgendein Puffer aktiv?
                jnz     tabchar         ; Ja, Zeichen aus Puffer holen
                mov     ah,KEY_READ     ; Tastatur abfragen
                int     KEYBOARD_IO     ; }ber BIOS
                cmp     al,0            ; Scan-Code?
                jne     alt10           ; Nein -->
                call    search          ; Zeichen aus Tabelle
                jz      alt10           ; keine Zeichen in Tabelle
                mov     conflg,cl       ; Anzahl Zeichen nach conflg
                mov     tabptr,bx       ; Pufferzeiger setzen
                call    tabchar         ; erstes Zeichen lesen
alt10:          or      ax,ax           ; Zeichen gelesen?
                jz      inagn           ; Nein, weiter versuchen
                or      al,al           ; Scan-Code?
                jnz     keyret          ; Nein -->
                mov     altah,ah        ; Ja, 2. Code in altah merken
keyret:         ret
;=======================================; Eingabe }ber Tabelle wandeln
tabchar:        mov     bx,tabptr       ; Zeiger auf Puffer
                mov     al,[bx]         ; Zeichen lesen
                xor     ah,ah           ; AH l|schen
                dec     conflg          ; Anzahl -1
                inc     bx              ; Zeiger +1
                mov     tabptr,bx       ; Zeiger merken
                ret

search:         mov     bx,offset scan  ; Sondertaste in Tabelle suchen
sloop:          mov     al,[bx]
                cmp     al,255          ; Tabellenende?
                je      notf            ; Ja -->
                cmp     al,ah           ; Code in Tabelle?
                je      found           ; Ja -->
                add     bx,5            ; Bytes pro Eintrag
                jmp     sloop           ; weitersuchen
found:          inc     bx              ; auf Anzahl zeigen
                mov     cl,[bx]         ; nach CL bringen
                inc     bx              ; auf Eintrag zeigen
                or      bx,bx           ; Zero-Flag setzen
                ret
notf:           xor     ax,ax
                ret
;=======================================; Nicht-destruktive Eingabe
con_rdnd:       mov     al,altah        ; noch ein Zeichen in altah?
                or      al,al
                jnz     rdexit          ; Ja -->
                cmp     conflg,0        ; sonst testen, ob Zeichen
                jz      rd1             ; in einem Puffer
                mov     bx,tabptr
                mov     al,[bx]         ; wenn ja, aus Puffer lesen
                jmp     short rdexit
rd1:            mov     ah,KEY_STATUS   ; Taste im Puffer?
                int     KEYBOARD_IO     ; }ber BIOS
                jz      conbus          ; Nein, keine Taste -->
                or      ax,ax           ; Ja
                jnz     rd2
                mov     ah,KEY_READ     ; Code 0,0 ignorieren
                int     KEYBOARD_IO     ; }ber BIOS aus Puffer nehmen
                jmp     con_rdnd
rd2:            call    search          ; Tabelleneintrag suchen
                jz      rdexit          ; kein Eintrag
                mov     al,[bx]         ; Zeichen lesen
rdexit:         lds     bx,cs:[ptrsav]
                mov     [bx].CHAR,al    ; Zeichen }bergeben
exvec:          jmp     exit 
conbus:         jmp     bus_exit
;=======================================; Eingabe-Puffer l|schen
con_flsh:       mov     altah,0
                mov     conflg,0        ; Anzahl Zeichen zur}cksetzen
                push    ds              ; BIOS-Puffer zur}cksetzen
                xor     bp,bp           ; Puffer fasst 15 Zchn a 2 Bytes
                mov     ds,bp           ; (Zeichen + Scan-Code)
                mov     ds:byte ptr BUFFER_HEAD,2*15 ; Puffer ist leer
                mov     ds:byte ptr BUFFER_TAIL,2*15 ; wenn HEAD = TAIL
                pop     ds
                jmp     exvec
;=======================================; Ausgabe
con_writ:       jcxz    exvec           ; wenn keine Anzahl, Ende
con_lp:         mov     al,es:[di]      ; ein Zeichen lesen
                inc     di              ; Zeiger erh|hen
                call    outc            ; Zeichen ausgeben
                loop    con_lp          ; Schleife bis alles ausgegeben
                jmp     exvec           ; Routine beenden

cout:           sti                     ; Zeichenausgabe DOS (INT 29h)
                push    ds              ; DS sichern
                push    cs
                pop     ds              ; DS = CS
                call    outc            ; Zeichen ausgeben
                pop     ds
                iret

outc:           push    ax              ; Zeichenausgabe Treiber
                push    cx
                push    dx
                push    si
                push    di
                push    es
                push    bp
                call    video           ; Zeichen interpret./ausgeben
                pop     bp              ; Register wiederherstellen
                pop     es
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     ax
                ret
;=======================================; Escape-Sequenzen-Interpreter
video:          mov     si,offset state
                cmp     si,offset char_test ; normale Routine?
                je      vid_jmp         ; Ja -->
                cmp     al,ESC          ; ESC?
                je      escape          ; Ja -->
vid_jmp:        jmp     word ptr [si]   ; Routine anspringen
escape:         mov     word ptr [si],offset escp
                ret

char_test:      cmp     al," "          ; Steuercode?
                jb      ctlcode         ; Ja -->
                cmp     al,DEL          ; del?
                je      passthru
                jmp     outchr          ; Nein, Zeichen ausgeben

passthru:       mov     state,offset char_test ; normale Behandlung
                ret

ctlcode:        xor     bx,bx           ; auf Steuercode reagieren
                mov     bl,al           ; ueber Steuercode-Sprungtabelle
                shl     bx,1            ; die entsprechende Routine
                add     bx,offset ctltbl; anspringen
                jmp     word ptr [bx]   ; Adresse der Routine in BX

escp:           cmp     al," "          ; g}ltige Escape-Sequenzen
                jb      passthru        ; zwischen " " und "~"
                cmp     al,"~"
                ja      passthru
                xor     bx,bx           ; g}ltig
                sub     al," "          ; Zeichen in Zeiger umwandeln
                mov     bl,al
                shl     bx,1
                add     bx,offset cmdtbl; }ber Kommando-Sprungtabelle
                jmp     word ptr [bx]   ; Escape-Kommando aufrufen
;=======================================; Interpreter Steuercodes
bell:           xor     bx,bx           ; Piepser
                mov     ah,WRITE_TTY    ; BIOS piepsen lassen
                int     VIDEO_IO
                ret

backspace:      cmp     col,0           ; wenn in Spalte 0,
                jz      backline        ; dann Sonderbehandlung
                dec     col             ; sonst Cursor um 1 zur}ck
backend:        jmp     setit           ; Cursor setzen
backline:       cmp     wrap,FALSE      ; wenn wrap nicht erlaubt,
                je      backend         ; ebenfalls nichts machen
                mov     al,maxcol       ; sonst in die letzte Spalte der
                mov     col,al          ; dar}berliegenden Zeile gehen
                jmp     cursor_up       ; mit Routine "Cursor nach oben"

hor_tab:        cmp     col,72          ; wenn Spalte }ber 72,
                jbe     do_tab          ; dann auf letzte Spalte gehen
                mov     col,0           ; sonst mit CR/LF auf Anfang
                jmp     line_feed       ; der n{chsten Zeile
do_tab:         mov     al,col          ; Normaler Tab
                add     al,8            ; auf aktuelle Spalte 8 addieren
                and     al,248          ; auf 8er-Position
                mov     col,al          ; und wieder in col speichern
                jmp     setit           ; Cursor setzen

carriage_return:mov     ah,VIDEO_STATE  ; Modus feststellen
                int     VIDEO_IO
                cmp     al,mode         ; wurde Modus von Anwendungsprg.
                je      mode_ok         ; ge{ndert? wenn nicht, ok
                call    reset_all       ; sonst Reset ausf}hren
mode_ok:        mov     col,0           ; in Spalte 0 = Carriage Return
                jmp     setit           ; sonst nur Cursor neu setzen
;=======================================; Zeichenausgabe auf Bildschirm
outchr:         mov     bx,cattw        ; Attribut und Bildschirmseite
                mov     cx,1            ; 1 Zeichen
                mov     ah,WRITE_CHAR   ; Zeichen und Attribut ausgeben
                int     VIDEO_IO        ; an der aktuellen Position
                mov     state, offset char_test ; normale behandlung
                inc     col             ; Spalte erh|hen
                mov     al,col
                cmp     al,maxcol       ; Zeilenende?
                jbe     setit           ; Nein -->
wrap_test:      cmp     wrap,TRUE       ; ist wrap eingeschaltet?
                jz      lf1             ; Ja, Position wird erh|ht
                dec     col             ; sonst alles beim Alten lassen,
                ret                     ; n{chstes Zeichen }berschreibt
;=======================================; Line Feed & Scroll
lf1:            mov     col,0           ; in Spalte 1
line_feed:      inc     line            ; der n{chsten Zeile
                mov     cl,maxrow
                cmp     line,cl         ; letzte Zeile
                jbe     setit           ; Nein -->
                mov     line,cl         ; Bildschirm nach oben scrollen
                mov     cx,0            ; obere linke Ecke f}r Scroll
                mov     dl,maxcol       ; untere rechte Ecke,max. Spalte
                mov     dh,maxrow       ; max. Zeile
                mov     al,1            ; Anzahl zu scrollender Zeilen
                mov     ah,SCROLL_UP    ; Bildschirm nach oben scrollen
                call    scroll
                jmp     short setit

scroll:         mov     bh,catt         ; Leerzeilen Attribut
                int     VIDEO_IO        ; Scrollen oder L|schen
                ret
;=======================================; Unterroutinen Cursorposition.
setit:          mov     dx,curpos       ; DX = line, col
                xor     bx,bx           ; BX = Bildschirmseite 0
                mov     ah,SET_POSITION ; Cursor positionieren
                int     VIDEO_IO
                ret
movcur:         cmp     [bx],ah         ; Hauptroutine Cursorbewegung
                jz      setcur          ; Maximum erreicht
                add     [bx],al         ; neuen Wert addieren
setcur:         call    setit           ; Cursorposition setzen
                jmp     passthru
;=======================================; Cursor positionieren
pos_cursor:     mov     word ptr [si],offset pos_cursor1
                ret
pos_cursor1:    sub     al,32           ; zuerst Zeile, 32 abziehen
                cmp     al,maxcol       ; ist die Zeilennummer g}ltig?
                jbe     l_ok            ; Ja -->
                mov     al,maxrow       ; Nein, max. Zeile annehmen
l_ok:           mov     line,al         ; Zeile speichern
                mov     word ptr [si],offset pos_cursor2
                ret
pos_cursor2:    sub     al,32           ; dann Spalte, 32 abzeihen
                cmp     al,maxcol       ; mit max. Spalte vergleichen
                jbe     c_ok            ; wenn kleiner oder gleich ok
                mov     al,maxcol       ; sonst max. Spalte annehmen
c_ok:           mov     col,al
                jmp     setcur
;=======================================; Cursor bewegung
cursor_home:    mov     curpos,0        ; Cursorposition 0,0 (1,1)
                jmp     setcur          ; einstellen
                                        ; Cursor nach rechts
cursor_right:   mov     ah,maxcol       ; Maximum in AH
                mov     al,1            ; Schrittweite
cursor_right1:  mov     bx,offset col   ; zuver{ndernder Wert
                jmp     movcur          ; --> ausf}hren
                                        ; Cursor nach links
cursor_back:    mov     ax,00ffh        ; Minimum 0,Schrittweite -1
                jmp     cursor_right1   ; --> ausf}hren
					; Cursor nach oben
cursor_up:      mov     ax,00ffh        ; Minimum 0,Schrittweite -1
cursor_up1:     mov     bx,offset line  ; zu ver{ndernder Wert
                jmp     movcur
                                        ; Cursor nach unten
cursor_down:    mov     ah,maxrow       ; Maximum
                mov     al,1            ; Schrittweite
                jmp     cursor_up1      ; --> ausf}hren
save_cursor:    mov     ax,curpos       ; Cursorposition merken
                mov     savcr,ax
                jmp     setcur
set_saved_pos:  mov     ax,savcr        ; gemerkte Pos. einstellen
                mov     curpos,ax
                jmp     setcur
;=======================================; Alle Parameter zur}ck setzen
reset_all:      mov     ah,VIDEO_STATE  ; Modus feststellen
                int     VIDEO_IO
                mov     bx,offset modtbl
                xlat                    ; Modus umwandeln (Text)
                mov     ah,SET_MODES    ; und neu einstellen
                int     VIDEO_IO
                mov     ah,VIDEO_STATE  ; Bildschirmseite/Spaltenzahl
                int     VIDEO_IO        ; abfragen
                mov     bpag,bh         ; und speichern
                dec     ah              ; Anzahl Spalten -1
                mov     modcol,ax       ; mode & maxcol einstellen
                mov     rev,FALSE       ; Flags auf Grundwerte
                mov     und,FALSE
                mov     catt,00000111b  ; normales Zeichenattribut
                mov     wrap,TRUE       ; wrap erlaubt
                mov     savcr,0         ; gemerkte Position 0,0 (1,1)
                mov     altah,0         ; Puffer leer
                mov     cursor_flag,TRUE; Cursor ein
                mov     cstr,0          ; Blockcursor
                mov     cend,13         ; Gr|sse
                cmp     mode,7          ; Mono-Adapter?
                je      cok             ; Ja -->
                mov     cend,7          ; Farb/Grafik-Adapter
cok:            call    cursor          ; Cursorformat einstellen
                mov     conflg,0        ; Zeichenpuffer l|schen
                mov     state,offset char_test
                mov     curpos,0        ; Home-Position, Schirm l|schen
                mov     cx,curpos       ; bis zur Zeile 25
                mov     dh,24
                jmp     erase
;=======================================; Bildschirmbereiche l|schen====
clrscr:         mov     curpos,0        ; Bildschirm l|schen von 0,0
                jmp     short era_eop1  ; Bildschirmende l|schen

era_eop:        mov     cl,maxrow       ; Bildschirmende l|schen
                cmp     line,cl         ; in der letzten Zeile?
                jae     era_eol         ; Ja, nur diese Zeile l|schen
                mov     cx,curpos       ; Ende der ersten Zeile l|schen
                mov     dh,ch
                mov     dl,maxcol
                mov     ax,CLEAR
                call    scroll
                mov     cx,curpos       ; dann den Rest des Bildschirms
                inc     ch
                cmp     ch,maxrow
                jae     era_eop3
                xor     cl,cl
                jmp     short era_eop2
era_eop1:       mov     cx,curpos       ; l|schen ab aktueller Position
era_eop2:       mov     dh,maxrow
                jmp     erase

era_lin:        mov     col,0           ; ganze Zeile l|schen
era_eol:        mov     cx,curpos       ; Zeileende l|schen
el2:            mov     dh,ch
erase:          mov     dl,maxcol
                mov     ax,CLEAR
                call    scroll
era_eop3:       jmp     setcur

era_bop:        mov     dx,curpos       ; Beginn der 1. Zeile l|schen
                mov     ch,dh
                xor     cl,cl
                mov     ax,CLEAR
                call    scroll
                mov     dx,curpos       ; dann den Rest des Bildschirms
                cmp     dh,0
                je      eb3
                dec     dh
                mov     dl,maxcol
eb2:            xor     cx,cx
ebl:            mov     ax,CLEAR
                call    scroll
eb3:            jmp     setcur

era_bol:        mov     cx,curpos      ; Zeilenanfang l|schen
                mov     dx,curpos      ; bis zum
                xor     cl,cl          ; Anfang der Zeile
                jmp     ebl
;======================================; Zeile l|schen/einf}gen
del_line:       mov     cl,maxrow      ; Zeile herausl|schen
                cmp     line,cl        ; letzte Zeilen?
                jb      dl1
                jmp     era_lin        ; Ja, Zeile nur l|schen
dl1:            mov     cx,curpos      ; von der aktuellen Zeile
                xor     cl,cl          ; Spalte 0
                mov     dh,maxrow      ; bis zur letzten Zeile
                mov     dl,maxcol      ; max. Spalte
                mov     al,1           ; alles um 1 Zeile
                mov     ah,SCROLL_UP   ; nach oben Scrollen
                call    scroll
                jmp     passthru

ins_line:       mov     cl,maxrow      ; Zeile einf}gen
                cmp     line,cl        ; eine der letzten Zeilen
                jb      il1
                jmp     era_lin        ; Ja, Zeile nur l|schen
il1:            mov     cx,curpos      ; von der aktuellen Zeile
                xor     cl,cl          ; Spalte 0
                mov     dh,maxrow      ; bis zur letzten Zeile
                mov     dl,maxcol      ; max. Spalte
                mov     al,1           ; alle um 1 Zeile
                mov     ah,SCROLL_DN   ; nach unten Scrollen
                call    scroll
                jmp     setcur
;======================================; Attribute
ent_rev_mde:    mov     rev,TRUE       ; Flag revers setzen
                cmp     mode,7         ; Mono-Adapter
                jne     gent_rev_mde
                mov     al,catt
                and     al,10001000b   ; Intensity-Bits erhalten
                or      al,01110000b   ; reverse Darstellung
seta:           mov     catt,al
                jmp     passthru
gent_rev_mde:   mov     al,catt        ; im Farbmodus
                and     al,10111111b   ; Farbe rot einstellen
                or      al,01000000b
                jmp     seta
exit_rev_mde:   mov     rev,FALSE      ; Flag revers zur}cksetzen
                cmp     mode,7         ; Mono-Adapter
                jne     gexit_rev_mde
                mov     al,catt
                and     al,10001000b   ; Intensity-Bits erhalten
                cmp     und,TRUE       ; war unterstrichen ein
                jnz     r_1 ; no ->
                or      al,00000001b   ; wieder unterstreichen
                jmp     short r_2
r_1:            or      al,00000111b   ; normale Darstellung
r_2:            jmp     seta
gexit_rev_mde:  mov     al,catt
                and     al,10111111b   ; im Farbmodus rot zur}cksetzen
                jmp     seta

foreground:     mov     al,catt        ; h|here Intensit{t ein
                and     al,11110111b
                or      al,00001000b   ; Intensity-Bit setzen
                jmp     seta
background:     mov     al,catt        ; h|here Intensit{t aus
                and     al,11110111b   ; Intensity-Bit l|schen
                jmp     seta

set_underline:  mov     und,TRUE       ; Flag unterstreichen setzen
                cmp     mode,7         ; Mono-Adapter
                jne     gset_underline
                mov     al,catt
                and     al,11111000b   ; Hintergrundfarbe behalten
                or      al,00000001b   ; Attribut unterstreichen
                jmp     seta
gset_underline: mov     al,catt        ; im Farbmodus
                and     al,11101111b   ; Zeichenfarbe beibehalten
                or      al,00010000b   ; Hintergrundfarbe blau
                jmp     seta
reset_underline:                       ; unterstreichen aus
                mov     und,FALSE
                cmp     mode,7         ; Mono-Adapter
                jne     greset_underline
                mov     al,catt
                and     al,11111000b   ; Hintergrundfarbe erhalten
                cmp     rev,TRUE       ; war revers ein?
                jnz     u_1            ; Nein -->
                or      al,01110000b   ; wieder revers
                jmp     short u_2
u_1:            or      al,00000111b   ; wieder normal
u_2:            jmp     seta
greset_underline:
                mov     al,catt
                and     al,11101111b   ; im Farbmodus blau r}cksetzen
                jmp     seta
;======================================; Cursor & Wrap ein/aus
crs_off:        mov     cursor_flag,FALSE ; Cursor aus
crs:            call    cursor         ; Cursorgr|sse einstellen
                jmp     passthru
crs_on:         mov     cursor_flag,TRUE; Cursor ein
                jmp     crs

cursor:         cmp     cursor_flag,TRUE; Einstellung Cursorgr|sse
                jne     cur_off        ; Nein -->
                mov     ch,cstr        ; Cursor ist an
                mov     cl,cend        ; Gr|sse ver{ndern
                jmp     short chcur
cur_off:        mov     cx,0f01h       ; Cursor ausschalten
chcur:          mov     ah,CURSOR_TYPE ; Cursorformat {ndern
                int     VIDEO_IO
                ret

wrap_eol:       mov     wrap,TRUE      ; Wrap ein
                jmp     passthru
discard_eol:    mov     wrap,FALSE     ; Wrap aus
                jmp     passthru
;======================================; Einheitentreiber INIT
con_init:       call    reset_all      ; alles zur}cksetzen
                xor     bx,bx          ; BREAK-Adresse einstellen
                mov     ds,bx
                mov     bx,BRKADR
                mov     word ptr [bx],offset break
                mov     word ptr [bx+2],cs
                mov     bx,DOS_CHAR_OUT ; DOS-Zeichenausgabe einstellen
                mov     word ptr [bx],offset cout
                mov     word ptr [bx+2],cs
                lds     bx,cs:[ptrsav]  ; Treiberende markieren
                mov     word ptr [bx].ENDADR,offset con_init
                mov     [bx].ENDADR+2,cs
                jmp     exit            ; Initialisierung beenden
code            ends
                end
