
\ -1 CONSTANT SOFTSCROLL       ( SCROLL PIXEL LINES )
   0 CONSTANT SOFTSCROLL       ( SCROLL CHARACTER LINES )

( HERCULES CHARACTER GENERATOR GRAPHICS MODE )


2VARIABLE CURSOR   0. CURSOR 2!


HEX B000 CONSTANT MDA   DECIMAL
720 CONSTANT XRES
348 CONSTANT YRES
  6 CONSTANT XDIST
  8 CONSTANT YDIST
  5 CONSTANT XSIZE
  7 CONSTANT YSIZE

XRES XDIST /   CONSTANT  CHARS/LINE
YRES YDIST /   CONSTANT  LINES/SCREEN


CREATE CHARTAB
INCLUDE CHARTAB
DECIMAL



CREATE SCRLOOKUP
   HEX   0 , 2000 , 4000 , 6000 ,        DECIMAL

\ LINE NUMBER TO OFFSET VIDEO SEGMENT CONVERSION
1 1 IN/OUT
: 'LINE  ( N -- OFFS )
       DUP 3 AND 2*  SCRLOOKUP + @
       SWAP 2/ 2/ XRES 8 / *  +  ;


2 0 IN/OUT
: TRANSPOSE  ( SOURCE DEST -- )
    'LINE SWAP 'LINE
    XRES 32 /  0 DO
            OVER >R
            MDA  OVER 2@L
            MDA  R>   2!L
            4 4 D+
         LOOP
\ REQUIRED FOR HERCULES BECAUSE ONE LINE CONSISTS OF 22.5 TIMES 32 BIT
            MDA SWAP @L
            MDA ROT  !L
            ;

SOFTSCROLL #IF

0 0 IN/OUT
: SCROLL    ( -- )
   YDIST 0 DO
      YRES 1  DO  I DUP 1-  TRANSPOSE   LOOP
      MDA  YRES 1- 'LINE
      XRES 32 /  0 DO   0. 2OVER 2!L   4 +     LOOP
      0 -ROT !L
   LOOP   ;

#ELSE

0 0 IN/OUT
: SCROLL    ( -- )
      YRES 1- 0  DO  I YDIST +  I  TRANSPOSE   LOOP
      YRES DUP YDIST - DO
         MDA  I  'LINE
         XRES 32 /  0 DO   0. 2OVER 2!L   4 +     LOOP
         0 -ROT !L
      LOOP
     ;

#THEN


2 2 IN/OUT
: NEXTPOS  ( X Y -- X' Y' )
           >R
           DUP  XRES XDIST - XSIZE - U>
           IF
               DROP 0
               R>
               DUP  YRES YDIST -  XSIZE -  U>
               IF
                  SCROLL
               ELSE
                  YDIST +
               THEN
           ELSE
               XDIST +  R>
           THEN    ;

3 0 IN/OUT
: CHARLINE  ( X Y PATT -- )
          XSIZE 0 DO
              >R
              R@ 128 AND
              IF 2DUP  +DOT ELSE 2DUP -DOT  THEN
              >R 1+ R>
              R> 2*
          LOOP
          2DROP DROP   ;

3 0 IN/OUT
: DRAWCHAR ( X Y ADDR -- )
          YSIZE  0 DO
             3DUP I + C@  CHARLINE
             SWAP 1+ SWAP
          LOOP  2DROP DROP  ;

1 1 IN/OUT : 'CHAR    ( ASC -- ADDR )    YSIZE  *  CHARTAB +    ;
1 0 IN/OUT : EMIT     ( ASC -- )
                      >R  CURSOR 2@
                      2DUP  R>  'CHAR   DRAWCHAR
                      NEXTPOS  CURSOR 2!  ;
2 0 IN/OUT : AT       ( X Y -- )       CURSOR 2!     ;
}}  #IF  CR .( GEMIT.4TH    Graphics Mode Character Gen. ) LIBSTATS  #THEN  {{
