	

; 30 Mar 82 JFP & HSP:
;	Split calculator into two parts, this is the
;	part we hope is interface-independent.  It
;	is meant to be included either by a debugging
;	environment (presently vcalcdbg.a86) or by
;	a production environment (presently vcalcwrm.a86).
	

; sizing parameters

dsize	equ	20		;display width
vsize	equ	14		;digitct for reg

; definitions for ascii register structures

r_sgn	equ	0		;sign code,0=>pos
r_ndig	equ	1		;no of digits
r_rpos	equ	2		;pos of radixpt
r_v	equ	3		;org of digitvec,msd last

r_siz	equ	r_v+vsize	;size of reg struc

; definitions for internal backsp and clear codes

bac	equ	8		;^H 
clr	equ	24		;^X
	

; general-use data & bss


; ascii registers

a	db	r_siz dup (?)	;main acc reg
k	db	r_siz dup (?)	;keyboard reg
t	db	r_siz dup (?)	;a temporary reg
s	db	r_siz dup (?)	;another temp
c	db	r_siz dup (?)	;constant reg
h	db	0,3,0,'00100000000000';const 100
o	db	0,1,0,'10000000000000';const 1

oa	dw	offset a	;o(a)
ok	dw	offset k	;o(k)
ot	dw	offset t	;o(t)
os	dw	offset s	;o(s)
oc	dw	offset c	;o(c)
oh	dw	offset h	;o(h)
oo	dw	offset o	;o(o)

; exit-time string for cp/m passthrough

exstrdl	dw	1		;longdescr len
exstrdo dw	1		;longdescr off
exstrds dw	1		;longdescr seg
exstro	db	vsize+4	dup (?)	;actual digs,sgn+pt,slop
exstre	label byte		;last byte+1
exstrp	dw	offset exstro   ;current avail pos
	

; (global data continues)
; other global state variables

exitcode db	1		;chcode for shift-calc
pflag	db	1		;radpt entered
guard	db	1		;guard digit
sep	dw	','		;US separator
radix	dw	'.'		;US radixpt
carry	db	1		;carry digit
lasttok	db	1		;last token
stkop	db	1		;1-lvl opstk entry
mdtmp	db	2*vsize	dup(?)	;mul/div accumulator
err	dw	0		;o(error string)

; error strings

ovfs	db	'overflow',0
dvzs	db	'divide by zero',0
badkey	db	'illegal input',0

; stack reservation

	dw	256 dup (?)	;actual stack
stbeg	label word		;initial sp

; local data for vcalc routine

parss	dw	1		;caller's sseg
parsp	dw	1		;caller's sp
savss	dw	1		;our ss during i/o
savsp	dw	1		;our sp during i/o

; local data for calcinit

ocins1	dw	cins1
cins1	db	27,'n'		;report cursorpos
	db	0		;eos

ocins2	dw	cins2
cins2	db	27,'O'		;exit insert-mode
	db	27,'x5'		;kill cursor 
	db	27,'x1'		;enable sts line
	db	27,'Y8 '	;pos to sts line
	db	27,'X'		;exch line
	db	27,'l'		;erase line
	db	0		;eos

; local data for calcexit

ocexs1	dw	offset cexs1
cexs1	db	'exit string = *',0
ocexs2	dw	offset	cexs2
cexs2	db	'*',15o,12o,0
ocexs3	dw	offset cexs3
cexs3	db	27,'Y8 '	;pos to line 25
	db	27,'l'		;erase line
	db	27,'X'		;exch line
savepos0 db	0		;pos
savepos1 db	0		;to
savepos2 db	0		;saved 
savepos3 db	0		;position
	db	27,'y5'		;turn on cursor
	db	0		;eos

; case table for first-level command char switch

timesop equ '*'

masw1	dw	7		;casect+1

	dw	'='		;equals 
	dw	'+'		;plus
	dw	'-'		;minus
	dw	timesop		;times
	dw	'/'		;divide
	dw	'%'		;percent

	dw	offset maeq	;'='
	dw	offset maad	;'+'
	dw	offset masb	;'-'
	dw	offset maml	;'*'
	dw	offset madv	;'/'
	dw	offset mapc	;'%'

	dw	offset madf1	;default

; Local data for main

maf1	db	' unexp cmd char '
	db	15o,12o,0
omaf1	dw	offset maf1

; local data for display

dif1	db	' Calculator Functions On       '
	db	'!',0
odif1	dw	offset dif1
dif2	db	'%-*s',0	;errmsg string
odif2	dw	offset dif2
dif3	db	'!',15o,12o,0	;suffix string
odif3	dw	offset dif3
dif4	db	27,'Y8 '	;command to line 25
	db	0		;eos
odif4	dw	dif4
c3	dw	3		;for div operation

; local data

c7	dw	7		;^G (bell) code

; static data for cistring


cilen	dw	0		;len(string)
cioff	dw	0		;off(string)
ciseg	dw	0		;seg(string)
cibyte	db	0,0		;2-byte string
	page




; **** end of vdata.asm ****
