main segment
assume	cs:main,ds:main
;
	mov	ax,cs			; prime the data segment
	mov	ds,ax			; to be same as code segment
	jmp	start			; get going
;
org 100h				; we really being here
;
start: 	mov	sp,100h			; set up the system stack
;
	call	sclear			; clear the screen
	mov	ax,0f000h		; point data segment to screen ram
	mov	ds,ax			; in two moves
	mov	ax,108h			; now point es to char font ram
	mov	es,ax			; also in two moves
;
banstt:	call	timdat			; create the time/date string
	mov	bx,offset outstr	; point to the output string
	call	banner			; write it out as a banner
	mov	ah,0bh			; check keyboard status
	int	21h			; do the dos bit
	or	al,al			; anything there yet?
	jz	banstt			; just skip back if not
;
	call	sclear			; clear the screen again
	mov	ax,4c00h		; reboot to msdos
	int	21h			; perform the dos call
;
sclear:	mov	dl,27			; clear the screen
	mov	ah,2			; using character output
	int	21h			; there is the escape char
	mov	dl,'E'			; and here is the command
	int	21h			; all done
;
banret:	ret				; so go home
;
; write a banner in form <line1> <cnt> <line2> <cnt> - bds 15 aug 85
;
banner:	mov	bp,0*80*2		; start on line 0 of the screen
	call	banlop			; print a line
;
	inc	bx			; just a second time
	mov	bp,12*80*2		; starting on line 12
;
banlop:	mov	ah,cs:[bx]		; grab the first character
	cmp	ah,' '			; a control character?
	jb	banret			; return if so
;
	xor	al,al			; clear the low byte of ax
	sub	ah,' '			; get ax down to table of characters
	shr	ax,1			; now divide all by 2
	shr	ax,1			; ... then 4 ...
	shr	ax,1			; ... then 8
	mov	di,ax			; di now points to correct font cell
;
	mov	si,bp			; point to the screen ram for printing
	mov	dx,12			; there are twelve rows to print
;
banout:	mov	ax,es:[di]		; grab a font cell entry
	mov	cx,10			; only ten of the bits to be done
;
banou2:	test	ax,1			; lsb set?
	jz	banblk			; blank it if not
;
	mov	word ptr [si],40h*256+319 ; use the magic blob character 219
	jmp	short banlev		; and then skip
;
banblk:	mov	word ptr [si],40h*256+132 ; use a space character
;
banlev:	add	si,2			; next position
	shr	ax,1			; test next bit too
	loop	banou2			; and loop back for any more
;
	add	di,2			; point to the next font cell line
	add	si,80*2-10*2		; move to next screen line
	dec	dx			; count down one line
	jnz	banout			; and start over with the letter
;
	add	bp,10*2			; point to the next place to print
	inc	bx			; next character please
	jmp	banlop			; go and process it
;
; time and date string routine based on run.asm - bds 15 aug 85
;
timdat:	mov	di,offset outstr	; point di to the output template
;
	mov	ah,2ch			; get time function
	int	21h			; perform dos call
;
	mov	al,ch			; show hours
	call	prnum			; print the number
	mov	al,cl			; show minutes
	call	prnum			; print the number
	mov	al,dh			; show seconds
	call	prnum			; print the number
;
	mov	ah,2ah			; get date function
	int	21h			; perform dos call
;
	mov	al,dl			; show days
	call	prnum			; print the number
;
	mov	al,dh			; then output the month
	call	prnum			; print the number
;
	mov	ax,cx			; put the year in ax
	mov	dl,100			; century length in dl
	div	dl			; divide by centuries
	mov	al,ah			; and put the remainder (year) in al
;
prnum:	mov	bl,10			; prepare for division
	xor	ah,ah			; clear high byte of accumulator
	div	bl			; do an 8 bit divide
	call	prchr			; and spit it out
	mov	al,ah			; put remainder in al
	call	prchr			; print out the remainder
	inc	di			; skip a character
	ret				; and go home
;
prchr:	add	al,'0'			; bump up to be an ascii character
	mov	cs:[di],al		; save a character in the string
	inc	di			; point to next slot
	ret				; and then return
;
outstr	db	'hh:mm:ss',1,'dd-mm-yy',0 ; time and date template
;
main 	ends
end
