cseg	segment
assume cs:cseg, ds:cseg
org	100h
start	proc	near
jmp	cset
start	endp

;-------------------------------------------------------------

address	dw	0effch

introms db	10,13,'CSET sets the Issue Clock+ Card to the System time ',
	db	10,13,'and date as set using the DATE and TIME commands.',
	db	10,13,'$'

badms	db	10,13,'ERROR: Issue Clock+ Card absent or malfunction.',
	db	10,13,'$'

csetms	db	10,13,'The Issue Clock+ Card has been set.',10,13,'$' 

;-------------------------------------------------------------

cset	proc near

	mov dx,offset introms
	mov ah,09h
	int 21h

	mov es,cs:address

	mov al,10000000b
	mov es:[0bh],al		;SET bit

	mov al,01110000b
	mov es:[0ah],al

	mov ah,2ah
	int 21h			;get date from DOS

	inc al
	mov es:[6],al		;day of week


	mov es:[7],dl		;date

	mov es:[8],dh		;month

	sub cx,076ch
	mov es:[9],cl		;year

	mov ah,2ch
	int 21h			;get time from DOS

	mov es:[0],dh		;secs

	mov es:[2],cl		;mins

	mov es:[4],ch		;hours

	mov al,00100000b
	mov es:[0ah],al		;set clock 32768 Hz

	mov al,10000110b
	mov es:[0bh],al		;DM (binary) and 24/12 (24)

	mov al,es:[0dh]		;read reg d, set VRT

	mov al,00000110b
	mov es:[0bh],al		;SET=0, start

	mov al,0
	mov es:[1],al		;PATCH FOR VI

	mov al,es:[0dh]		;check Valid Ram and Time
	cmp al,10000000b
	jnz badtime

	mov dx,offset csetms
	mov ah,09h
	int 21h

cset	endp

exit:	mov ah,0		;terminate
	int 21h

;--------------------------------------------------------

badtime:	mov dx,offset badms
		mov ah,09h
		int 21h
		jmp exit

;---------------------------------------------------------

cseg	ends
end	start

;-------------------------------------------------------------
