;---------------------------------------------------------------

cseg	segment
assume cs:cseg, ds:cseg
org	100h
start	proc	near
jmp 	nb
start	endp

;-------------------------------------------------------------

address	dw	0effch

introms	db	10,13,'NB v1.1 for the Victor Sirius (C) Issue 1988.',
	db	10,13,'Editor for the Clock+ Card non-volatile RAM.', 
	db	10,10,13,'$'

;-----------------------------------------------------------------
nb	proc near

	mov	ah,9			;display title
	mov	dx,offset introms
	int	21h

	mov dl,'>'	;cursor
	mov ah,02h
	int 21h
	mov es,address
	mov bp,0eh

	mov dl,1bh	;mem contents in high intensity
	mov ah,02h
	int 21h
	mov dl,'('
	mov ah,02h
	int 21h

	call read

	mov dl,13	;CR
	mov ah,02
	int 21h

	mov dl,1bh	;cursor one place right
	mov ah,02h
	int 21h
	mov dl,'C'
	mov ah,02h
	int 21h

	mov es,address
	mov bp,0eh

in:	mov ah,07h	;i/p from kb
	int 21h
	cmp al,7fh	;check for DEL
	jz left
	cmp al,08	;check for BS
	jz left
	cmp al,04	;check for WS ^D
	jz right
	cmp al,13	;check for CR
	jz exit
	cmp al,1bh	;check for ESC
	jz esc
	cmp al,20h	;check character is ASCII
	jl in
	cmp al,7fh
	jg in
	cmp bp,40h	;mem full
	jz in

	mov ah,02h	;o/p to screen
	mov dl,al
	int 21h
	mov es:[bp],al	;o/p to mem

	mov dl,0
	mov es:01,dl		;PATCH FOR VI

	inc bp
	jmp short in	

nb	endp

left:	cmp bp,0eh
	jz in
	mov dl,1bh
	mov ah,02h
	int 21h
	mov dl,'D'
	mov ah,02h
	int 21h
	dec bp
	jmp short in

right:	cmp bp,40h
	jz in
	mov dl,1bh
	mov ah,02h
	int 21h
	mov dl,'C'
	mov ah,02h
	int 21h
	inc bp
	jmp short in

esc:	mov ah,06h
	mov dl,0ffh
	int 21h
	cmp al,'D'
	jz left
	cmp al,'C'
	jz right
	cmp al,0
	jz exit
	mov ah,0ch
	mov al,0
	int 21h		;type ahead buffer flush
	jmp short in		


exit:	mov dl,1bh	;high intensity off
	mov ah,02h
	int 21h
	mov dl,')'
	mov ah,02h
	int 21h

	mov dl,13	;CR
	mov ah,02
	int 21h

	mov dl,'>'	;cursor
	mov ah,02h
	int 21h
	mov es,address
	mov bp,0eh

	call read

	mov dl,13	;CR
	mov ah,02
	int 21h

	mov dl,10	;LF
	mov ah,02h
	int 21h


	int 20h		;terminate

;==============================================================

read	proc near

rd:	mov dl,es:[bp]
	cmp dl,20h	;check is ASCII
	jl badrd
	cmp dl,7fh
	jge badrd
	jmp short out

badrd:	mov dl,20h	;space if not ASCII

out:	mov ah,02h
	int 21h
	inc bp
	cmp bp,40h
	jnz rd
	ret

read	endp

;--------------------------------------------------------

cseg ends
end start


