		page	62,132
;-----------------------------------------------------------------------------;
;	Scrnsave - a program to disable a video monitor after 3 minutes.      ;
;	Published:	SOFTALK for the IBM Personal Computer		      ;
;			December 1983					      ;
;			'Save your Monitor Screen'; pages 81-86               ;
;	Author	 -	John Socha					      ;
;									      ;
;	USAGE:		scrnsave  [nn] [-d]				      ;
;				where nn = 3 - 10 minutes		      ;
;				      -d = disable scrnsave		      ;
;									      ;
;-----------------------------------------------------------------------------;
;	change	date	    author	      description		      ;
;	1     01/28/84	John Teichert  Add ability to specify the time before ;
;				       screen is disabled on command line     ;
;	2     01/28/84	John Teichert  Add ability to change time out value   ;
;				       and prevent multiple invocation	      ;
;				       problems 			      ;
;	3     02/02/84	John Teichert  Add ability to disable scrnsave before ;
;				       using programs that take over video    ;
;				       and keyboard interrupts. 	      ;
;	4     04/21/84  Guy C. Gordon  Modified to run on the Victor 9000     ;
;				       MS-DOS 1.25 or 2.11		      ;
;-----------------------------------------------------------------------------;

;----------------------------------------------------------------------------;
;		Interrupt vectors for clock and keyboard		     ;
;----------------------------------------------------------------------------;

VECTORS 	SEGMENT AT 0
		ORG	42H*4
TIMER_INT_VECTOR	LABEL	DWORD	; time of day interrupt vector
		ORG	46H*4
KB_INT_VECTOR		LABEL	DWORD	; Keyboard interrupt vector

VECTORS 	ENDS

;-----------------------------------------------------------------------------;
;		Start of local data and executable code 		      ;
;-----------------------------------------------------------------------------;

CODE_SEG	SEGMENT
		ASSUME	CS:CODE_SEG
		ORG	100H		; This will be a .COM file
BEGIN:		JMP	INIT_VECTORS	; Jump over data areas 
SCRSMSG 	DB	'SCRNSAVE 1.04 '; self-recognition message
BRIGHTNESS	DB	?		; Save brightness level
					;  note even boundry for following words
TIMER_INT	DD	?		; Save area for BIOS interrupt
KEYBOARD_INT	DD	?		;   addresses

TIMER_DELAY	DW	0		; number of clock ticks to wait
MIN_COUNTER	DW	?		; counter for clock ticks 
					;   Super BIOS Parameter Blocks
PB1		DW	1		; Console vector function
CONSOLE		DD	0		; console vector returned here

PB2		DW	1		; Console vector function
		DW	INTERCEPT_CONSOLE	;offset
		DW	?		; segment
		page
;-----------------------------------------------------------------------------;
;	This proceedure decrements the MIN_COUNTER with each clock tick,      ;
;	and turns off video display when it reaches zero.		      ;
;-----------------------------------------------------------------------------;

INTERCEPT_TIMER	PROC	NEAR
	PUSH	AX
	PUSH	DS
	MOV	AX,CS			; Set dataseg to code seg
	MOV	DS,AX
	ASSUME	DS:CODE_SEG		; Tell assembler
	MOV	AX,7FFFH		; Check to see if not to touch
	CMP	AX,TIMER_DELAY		; Q. leave alone
	JE	GOTO_TIMER		;   Yes bypass
	DEC	MIN_COUNTER		; Q. Minutes eaten up
	JZ	TURN_VIDEO_OFF		; Yes turn off video
	JG	GOTO_TIMER		; No leave it
	MOV	MIN_COUNTER,0		; Already off, reset counter

GOTO_TIMER:
	POP	DS
	POP	AX
	ASSUME	DS:NOTHING		; Drop Data seg addressability
	JMP	TIMER_INT		; Resume further timer processing

TURN_VIDEO_OFF:
	ASSUME	DS:NOTHING
	PUSH	BX
	MOV	AX,0E804H		; Address of Brightness ctrl reg.
	MOV	DS,AX
	XOR	BX,BX
	MOV	AL,[BX]
	MOV	BRIGHTNESS,AL
	AND	AL,0E3H			; zero brightness, bits 2,3,4
	MOV	[BX],AL
	POP	BX
	JMP	GOTO_TIMER

INTERCEPT_TIMER	ENDP

		page
;-----------------------------------------------------------------------------;
;	    This proceedure resets the counter on every keystroke	      ;
;-----------------------------------------------------------------------------;
INTERCEPT_KB_INT	PROC	NEAR
	ASSUME	DS:NOTHING
	CALL	RESET_COUNTER		; Reset timer counter
	JMP	KEYBOARD_INT		; Continue with keyboard
INTERCEPT_KB_INT	ENDP


;-----------------------------------------------------------------------------;
;		This procedure resets the timer count 			      ;
;		and turns on the display if it was off.			      ;
;-----------------------------------------------------------------------------;
RESET_COUNTER	PROC	NEAR
	ASSUME	DS:NOTHING
	PUSH	AX
	PUSH	BX
	PUSH	DS
	CMP	MIN_COUNTER,0		; Q. Was display off
	JG	VIDEO_NOT_OFF		; No then reset
					; YES turn video on
	MOV	AX,0E804H		; address of Brightness reg.
	MOV	DS,AX
	XOR	BX,BX
	MOV	AL,BRIGHTNESS		; restore saved brightness level
	MOV	[BX],AL

VIDEO_NOT_OFF:
	MOV	AX,TIMER_DELAY
	MOV	MIN_COUNTER,AX
	POP	DS
	POP	BX
	POP	AX
	RET

RESET_COUNTER	ENDP

	page
;-----------------------------------------------------------------------------;
;	This procedure resets the timeout counter and passes control to       ;
;	the Console.  It also processes functions FF and FE which are 	      ;
;	called by the initialization proceedure to determine if scrnsave      ;
;	is already resident and to change the timeout value.		      ;
;-----------------------------------------------------------------------------;
INTERCEPT_CONSOLE	PROC	FAR
	ASSUME	DS:NOTHING
	CMP	AX,0FFH 		; Dummy interupt to see if installed
	JNE	IC_CHK_RST		; Check to see if reset
	MOV	AX,WORD PTR SCRSMSG[0]  ; Move first two bytes in
	MOV	BX,WORD PTR SCRSMSG[2]  ; Move second two bytes
	RET

IC_CHK_RST:
	CMP	AX,0FEH 		; Reset parms
	JNE	IC_RST_CNT
	MOV	CS:TIMER_DELAY,CX	; Reset parms
	RET

IC_RST_CNT:
	CMP	AX,01H			; Console display function
	JNE	IC_EXIT
	CALL	RESET_COUNTER

IC_EXIT:
	JMP	CONSOLE			; pass control on to console

INTERCEPT_CONSOLE	ENDP

	page
;-----------------------------------------------------------------------------;
;		This procedure intializes the interrupt vectors. 	      ;
;-----------------------------------------------------------------------------;
;									      ;
;	---NOTE --- NOTE --- NOTE --- NOTE --- NOTE --- NOTE --- NOTE ---     ;
;	Both DOS 1.1 and DOS 2.0 have function 25 for performing interrupt    ;
;	reseting.  DOS 2.0 has an interrupt function 35 for obtaining the     ;
;	address of a interrupt.  Persons wishing to perform interrupt	      ;
;	resetting should use the official mechanisms as this may become       ;
;	important in multitasking situations.				      ;
;					John Teichert			      ;
;									      ;
;-----------------------------------------------------------------------------;
INIT_VECTORS		PROC	NEAR
	ASSUME	DS:CODE_SEG		; Setup to analyze input if any
	ASSUME	SS:CODE_SEG		; Setup stack seg register address
	MOV	SP,100H 		; Point to top of unformatted area
	MOV	SI,080H 		; Point to unformatted parameter area
	CLD				; Clear direction flag
	LODSB				; Get first byte into ax
	OR	AL,AL			; See if any input
	JZ	TIM_DEFAULT		; No use default of 3 minutes
	XOR	AH,AH			; Clear high order register
	MOV	CX,AX			; Move to count register
	XOR	BX,BX			; Zero Working Reg
TIM_LOOP:
	LODSB				; Get first data byte
	CMP	AL,' '                  ; Is it blank
	JNE	TLP000			; No so bypass decrement loop would do
	LOOP	TIM_LOOP		; Yes loop back
TIM_DEFAULT:
	MOV	AL,'5'                  ; Set default value
	MOV	CX,1			; Fake having a parm of 5
	JMP	SHORT TVL001		;
TLP000:
	JMP	SHORT TVL000A		; bypass LODSB
TIM_VAL_LOOP:				;
	LODSB				; Get another value
TVL000A:
	CMP	AL,'-'                  ; Going for disable
	JNE	TVL000B 		; NO continue
	MOV	AX,7FFFH		; Assume they are so disable
	MOV	TIMER_DELAY,AX		;   and set value
	JMP	CHK_IS_INSTALLED	; Check whether or not been here
TVL000B:
	CMP	AL,'0'                  ; Q. Is it 0 or above
	JGE	TVL000			;    Yes check high range
	JMP	BAD_PARM		;    No bad
TVL000:
	CMP	AL,'9'                  ; Q. Is it 9 or below
	JLE	TVL001			;    Yes cont
	JMP	BAD_PARM		;    No bad
TVL001:
	SUB	AL,'0'                  ; Get value relative to hex 0
	MOV	BX,AX			; Save for time being
	MOV	AX,TIMER_DELAY		; Get prior value
	MUL	PWR10			; Multiply by 10
	JNO	TVL002
	JMP	BAD_PARM		; If overflowed then too high
TVL002:
	ADD	AX,BX			; Add last value
	MOV	TIMER_DELAY,AX		; Move it back in
	LOOP	TIM_VAL_LOOP		; if another
	MOV	AX,TIMER_DELAY		; Now figure out delay time
	CMP	AX,MAX_DELAY
	JLE	TVL003
	JMP	BAD_PARM
TVL003:
	CMP	AX,MIN_DELAY
	JGE	TVL004
	JMP	BAD_PARM
TVL004:
	MUL	SEC_MIN 		; Multiply by num seconds in minute
	MUL	TICKS_SEC		; timer number timer tics per second
	MOV	TIMER_DELAY,AX

CHK_IS_INSTALLED:
	MOV	AX,CS
	MOV	ES,AX
	MOV	BX,OFFSET PB1		; Set up ES:BX -> Param. Block
	MOV	AX,14			; Get device vector function
	INT	0DFH			; Victor Super Bios interrupt
	CMP	AX,0FFFFH
	JNE	CHK2
	JMP	BAD_PARM

CHK2:	MOV	AX,0FFH 		; Setup Inquiry
	CALL 	CONSOLE			; Call the Console
	CMP	AX,WORD PTR SCRSMSG[0]	; If up already this will find out
	JNE	SET_VECTORS		;  Nope so init
	CMP	BX,WORD PTR SCRSMSG[2]	;  Make real sure
	JNE	SET_VECTORS		;  Nope so init
	MOV	CX,TIMER_DELAY		; Get value to change to
	MOV	AX,0FEH 		; Set for change
	CALL	CONSOLE			; Call the Console
	JMP	SPILL_CHANGED		; Tell the world
	page

SET_VECTORS:
	ASSUME	DS:NOTHING
	CLI				; Disable interrupts while manipulating

	MOV	AX,CS			; Set Console Vector
	MOV	ES,AX
	MOV	BX,OFFSET PB2		; Set ES:BX -> Param. Block
	MOV	CS:[BX+4],AX		; put code seg in param block
	MOV	AX,15			; Set device vector function
	INT	0DFH			; Victor Super Bios interrupt
	CMP	AX,0FFFFH
	JE	BAD_PARM

	ASSUME	DS:VECTORS		; Setup data seg for vectors
	MOV	AX,VECTORS
	MOV	DS,AX

	MOV	AX,TIMER_INT_VECTOR	; Get timer interrupt vector
	MOV	TIMER_INT,AX		; Save
	MOV	AX,TIMER_INT_VECTOR[2]
	MOV	TIMER_INT[2],AX
	MOV	TIMER_INT_VECTOR,OFFSET INTERCEPT_TIMER
	MOV	TIMER_INT_VECTOR[2],CS

	MOV	AX,KB_INT_VECTOR
	MOV	KEYBOARD_INT,AX
	MOV	AX,KB_INT_VECTOR[2]
	MOV	KEYBOARD_INT[2],AX
	MOV	KB_INT_VECTOR,OFFSET INTERCEPT_KB_INT
	MOV	KB_INT_VECTOR[2],CS

	MOV	AX,TIMER_DELAY
	MOV	MIN_COUNTER,AX

	STI				; NOW that all vecotrs are set reenable
	MOV	DX,OFFSET INIT_VECTORS
	INT	27H			; Terminate but stay resident
	page

SPILL_CHANGED:
	MOV	AH,9			; DOS put video
	MOV	DX,OFFSET SC_MSG1	; Message to spill
	INT	21H			; To the op sys
	JMP	EXIT_DOS		; That's all folks

BAD_PARM:
	MOV	AH,9			; DOS put video interupt
	MOV	DX,OFFSET BP_MSG1	; More for interupt
	INT	21H			; DOS interrupt
	MOV	AH,9
	MOV	DX,OFFSET BP_MSG2
	INT	21H
	MOV	AH,9
	MOV	DX,OFFSET BP_MSG3
	INT	21H
EXIT_DOS:
	INT	20H			; DOS return

INIT_VECTORS	ENDP


PWR10		DW	10		; Power of 10
TICKS_SEC	DW	2		; Number of timer ticks per second
MAX_DELAY	DW	30		; Max delay time
MIN_DELAY	DW	3		; Set Minimum to 3 minutes
SEC_MIN 	DW	60		; Number of secs in minute
BP_MSG1 DB	'        Usage:  scrnsave  [nn] [-d]',13,10,'$'
BP_MSG2 DB	'                where nn = 3 - 30 minutes',13,10,'$'
BP_MSG3 DB	'                      -d = disable scrnsave',13,10,'$'

SC_MSG1 DB	'  Scrnsave time out value changed',13,10,'$'

CODE_SEG	ENDS
	END	BEGIN
