/*
	This simple program uses an undocumented feature of the
	8088 instruction set to distinguish between an 8088 and
	the NEC V20 plug-in replacement.  The MUL instruction
	for both processors are *documented* the same - both set
	the carry flag (CF) and overflow flag (OF) if the result
	of the MUL has a non-zero high-order half, and both do
	exhibit this behavior.  However, although *both* are not
	supposed to modify the zero flag (ZF), the 8088 sets it
	to the same value as CF and OF, while the NEC V20 leaves
	it alone (as it should).
*/

main()
	{
	if (V20())
		{
		printf("Processor is a NEC V20.\n") ;
		}
	else
		{
		printf("Processor is an 8088.\n") ;
		}
	}

int V20()
	{
#asm
	XOR	AL,AL	; Sets ZF
	MOV	AL,40h	; 64 decimal
	MUL	AL	; 64**2 > 255
	MOV	AX,1	; assume V20
	JZ	Is_V20	; V20 MUL leaves ZF untouched
	MOV	AX,0	; 8088 ZF==OF after MUL
Is_V20:
#end
	}
