;
; See the comment on header files in ssdaxpy.asm.
;
include model.h
INCLUDE PROLOGUE.H
	public ssxdot
; 8087 dot product
; ssxdot ()
;
.8087
ssxdot	  proc	  near
	push	bp
	mov	bp,sp
; Current syntax ssxdot(&f,&g,n,&h,stride1,stride2) -- > dot product stored in h
; &f in di,  &g in bx , n in cx. This function stores the dot product rather
; than returning it because different C compilers return doubles in different
; ways.
;
;This is equivalent to the following C function.
;
;	ssxdot(v1,v2,n,dptr,stride1,stride2)
;	double *v1,*v2,*dptr;
;	int n,stride1,stride2;
;	{
;		int i;
;		*dptr=0.0;
;		for(i=0;i<n;i++){
;			*dptr+=(*v1)*(*v2);
;			v1+=stride1;
;			v2+=stride2;
;		}
;	}
;
;      The strides are the distance between consecutive elements of v1, and v2
;      in bytes.
;
	push di
	push si
	push bx
	push ax
	mov di,4[bp]   ;vector 1
	mov si,6[bp]   ;vector 2
	mov cx,8[bp]   ;vector length
	mov ax,12[bp]  ;stride for vector 1
	mov bx,14[bp]  ;stride for vector 2
	finit
	fldz
done:
	fld qword ptr [si]	;get an element of vector 2
	add si,bx		;increment the pointer
	fmul qword ptr [di]	;multiply by vector 1
	add di,ax		;increment its pointer
	fadd			;accumulate the dot product
	loop done
	fwait			;hang around
	mov di,10[bp]		;address of dot product
	fstp qword ptr [di]	;store the dot product
	pop ax
	pop bx
	pop si
	pop di
	pop bp
	ret
ssxdot	  endp
INCLUDE EPILOGUE.H
end
