\
\  comport.4th library replacement   WORKS ON PORT 1 ONLY
\   original nonfunctioanl ...
\

FIND HIHERE  #IF  DROP   #ELSE    INCLUDE HIALLOT   #THEN

{{
HEX

FIND COMBUFSIZE  #IF DROP #ELSE
0400 CONSTANT COMBUFSIZE             ( bytes in ring buffer )   #THEN

HIHERE
COMBUFSIZE HIALLOT
HIHERE DUP  CONSTANT COMBUF

CR .( COM1 BUFFER ,high allocation              )
DECIMAL COMBUFSIZE 5 U.R   HEX  5 U.R   .( h)  5 U.R  .( h )

1 2 IN/OUT                                                              HEX
: COMPORT    ( N -- ADDR IRQ )
         ( BIOS-DATA ) 040  OVER 2* @L
          4 ROT  1 AND  -   ;


VARIABLE COM_IN                        ( modified by COM_INT )
VARIABLE COM_OUT                       ( modified by @COM )

( storage for original interrupt vector contents )
2VARIABLE PREV_ASC_VEC


HEX
1 0 IN/OUT
: BAUD ( BAUD -- )  \ CHANGE BAUD AT AUX1
  [HEX] 3FB PC@ 		\ save line control register
  80 3FB PC! SWAP 		\ enable baud generator access
     [DECIMAL]
 DUP 115 = IF  DROP 1           \ hack chop
     ELSE   0 10 UM/MOD NIP
  11520. ROT UM/MOD NIP		\ scale baud and get contents
    THEN
  [HEX] DUP >< 3F9 PC! 3F8 PC!  \ change baud
  3FB PC! ; 			\ reset line control register



( --- flag ; is anything in Asynch buffer? )
0 1 IN/OUT  
: ?COM                COM_IN @ COM_OUT @ <> ;



( --- c ;  wait and read one character from Asynch buffer )
( also increment the buffer output pointer )


FIND TASKER   #IF  DROP
: @COM
                BEGIN ?COM NOT WHILE  PAUSE REPEAT
                COM_OUT @ COMBUF + C@
		1  COM_OUT COMBUFSIZE
                ROT             ( --- var max incr )
                2 PICK @ +      ( --- var max @var+incr )
                2DUP U> NOT     ( new value >= maximum? )
                IF   SWAP -     ( --- var @var+incr-max )
                ELSE SWAP DROP  ( --- var @var+incr )
                THEN SWAP ! ;


             #ELSE
: @COM
                BEGIN ?COM  UNTIL
                COM_OUT @ COMBUF + C@
		1  COM_OUT COMBUFSIZE
                ROT             ( --- var max incr )
                2 PICK @ +      ( --- var max @var+incr )
                2DUP U> NOT      ( new value >= maximum? )
                IF   SWAP -     ( --- var @var+incr-max )
                ELSE SWAP DROP  ( --- var @var+incr )
                THEN SWAP ! ;


              #THEN

HEX

L:   COM_INT    STI                     ( enable interrupts )
                AX PUSH  BX PUSH        ( save affected regs)
                DX PUSH  DS PUSHSEG
                AX CS <SEG  AX DS >SEG  ( establish addressing)
                3F8 # DX MOV
                [DX] BYTE IN            ( read serial port )
                CLI                     ( clear interrupts for)
                                        ( pointer manipulation)
                COM_IN [] BX MOV        ( store this character)
                AL COMBUF +[BX] MOV     ( into ring buffer )
                BX INC                  ( bump ring pointer)
                COMBUFSIZE # BX  CMP    ( time to wrap? )
                =0 IF,
                BX  BX XOR  THEN,       ( reset pointer )
                BX COM_IN [] MOV        ( store updated ptr )
                STI                     ( enable interrupts)
                20 # AL MOV             ( send EOI to 8259 )
                20 BYTE OUT
                DS POPSEG  DX POP       ( restore registers )
                BX POP  AX POP
                IRET                    ( interrupt return )
                END-CODE



: CHARS_IN_BUF ( -- N )
     COM_IN @    COM_OUT @ -
     DUP 0< IF  COMBUFSIZE +  THEN   ;

HEX
: %FILLED  ( SCALE -- N )
        CHARS_IN_BUF  COMBUFSIZE 2/ 07FFF AND  */ 2/  ;



( --- ; enable interrupts, set up vectors )
( initialize the RS-232 interrupt trap; --- )
2 0 IN/OUT
: COMON         2DROP
                0 DUP COM_IN !  COM_OUT !
		0C GET-HANDLER
                PREV_ASC_VEC 2!
		?CS: COM_INT 0C SET-HANDLER
		0F 3FC PC!		( modem cont. DTR&OUT2)
                21 PC@ 0EF AND 21 PC!    ( 8259 int mask IRQ4 )
		03 3FB PC!		( set 8 data, 1 stop bits)
		3F8 PC@ DROP 3FD PC@ DROP ( reset unit )
                1 3F9 PC!                ( int enable register)
		;






HEX
( --- ; disable interrupts, release vectors )
0 0 IN/OUT
: COMOFF
	21 PC@ 10 OR 21 PC!	( mask IRQ4 interrupt )
	PREV_ASC_VEC 2@ 	( restore old )
        2DUP OR  IF
        0C SET-HANDLER
        ELSE 2DROP  THEN  ;        ( interrupt vectors )




1 0 IN/OUT
: REMIT           ( WAIT-EMIT )
        BEGIN
            03F8  5 + PC@               \ LINE STATUS REGISTER
            20 AND                       \ TX HOLDING REGISTER EMPTY
        UNTIL
        03F8  PC! ;                   \ TX DATA REGISTER





}}  #IF  CR .( COM1 support                              )  LIBSTATS  #THEN
