BASE @ DECIMAL
0 CONSTANT FIFOEND
2 CONSTANT FIFOIN
4 CONSTANT FIFOOUT
6 CONSTANT FIFODATA

\ ----------
: !FIFO   ( N ADDR -- )

             DUP
             FIFOIN
             +
             @
             TUCK                 \  N INDEX ADDR INDEX

             1+
             OVER
             FIFOEND
             +
             @
             AND                  \  N INDEX ADDR INDEX'

             OVER
             FIFOIN
             +
             !                    \  N INDEX ADDR

             FIFODATA
             +
             +
             C!
        ;



: @FIFO       ( ADDR -- N )
             DUP
             FIFOOUT
             +
             @
             TUCK                 \  INDEX ADDR INDEX

             1+
             OVER
             FIFOEND
             +
             @
             AND                  \  INDEX ADDR INDEX'

             OVER
             FIFOOUT
             +
             !                    \  INDEX ADDR

             FIFODATA
             +
             +
             C@
        ;


: ?FIFO      ( ADDR -- F )   ( NEXT FIFO READ  SUCCESSFUL ? )
                     DUP FIFOIN + @
                     SWAP FIFOOUT + @  <>   ;


: FLUSH      ( ADDR -- )
           DUP FIFOIN +  OFF
           FIFOOUT +  OFF   ;


\ setup memory as FIFO .   Allow for size to be determined by FIFOSET par

: FIFOSET    ( addr siz -- ) 1-  OVER  FIFOEND  + ! FIFODATA  OVER
FIFOIN   + ! FIFODATA  SWAP  FIFOOUT  + !     ; BASE !

