10 REM  *****************************************************************
20 REM  CONFIGURE GWBASIC for a desired printer
30 REM  *****************************************************************
100 GOTO 20000
1000 REM routine to set vars for a given printer
1010 REM  j contains a number from 1 to the no. of printers.
1030 REM  This routine is called once for each printer at the beginning
1040 REM  to find out how many printers there are, and to set up the
1050 REM  menu to choose a printer. (The calling routine checks if there is
1055 REM  a printer defined for the number j by seeing if this routine sets
1057 REM  HEAD$ to a non-null value. Thus HEAD$ must be set to a non-null
1058 REM  value by each routine called by this one.)
1060 REM  When a printer is chosen, this routine is called again to set up
1070 REM  the vars for that printer.
1110 ON J GOSUB 2500,5000,5500,6000,9000
1120 RETURN
2000 REM Following are the routines to set up the vars for each printer.
2010 REM  The strings HEAD$ and DESC$ will be displayed in the printer
2020 REM  selection menu in this program.  In addition, the string HEAD$
2030 REM  will be displayed in the GWBASIC sign on message.
2040 REM The values of the variables TYPPARM, WRDPARM, and STRPARM will
2050 REM  be stored in the configuration buffer in GWBASIC.
2060 REM  TYPPARM(1) specifies the ovarall algorithm to be used for the
2068 REM  graphics printing.  If TYPPARM(1)=0 then LCOPY will be disabled.
2070 REM  The following descriptions of the other parameters apply to the
2072 REM  case TYPPARM(1)=1.  This currently suffices for all printers.
2080 REM  TYPPARM(2) specifies the format of the count of number of bytes
2090 REM  used in the command to enter the graphics mode.
2100 REM  The absolute value of WRDPARM(1) specifies the number of scan lines
2110 REM  printed in one pass across the paper.
2112 REM  The sign of WRDPARM(1) tells whether the lsb of the byte is mapped
2114 REM  to the top or the bottom of the print head.
2120 REM  WRDPARM(2) specifies the minimum number of bytes to send for
2122 REM  non-blank lines.  Setting this greater than zero seems to help
2124 REM  the vertical spacing on the Tally printer. MORE EXPERIMENTATION
2126 REM  could be done.
2150 REM  The strings stored in STRPARM are control strings for the printers.
2160 REM  STRPARM(1) is output before each screen image.
2170 REM  STRPARM(2) is output after each screen image.
2180 REM  STRPARM(3) is output before each line. (not currently used)
2190 REM  STRPARM(4) is output after each line.
2200 REM  STRPARM(5) is output to switch to graphics mode.  After this string
2210 REM  is output, the byte count is output, and then STRPARM(6), followed
2220 REM  by the bytes of graphics data.
2490 REM
2500 REM --------------------- ABORT ----------------------------------
2510 HEAD$="ABORT"
2520 DESC$=" - abort this program without changing GWBASIC"
2530 RETURN
4990 REM
5000 REM --------------------- Epson MX80/MX100 ------------------------
5005 HEAD$="Epson MX80/MX100 Printer"
5010 DESC$=""
5020 TYPPARM(1)=1
5030 STRPARM$(1)=LF$+ESC$+"A"+CHR$(8)
5040 STRPARM$(2)=ESC$+"2"
5050 STRPARM$(3)=""
5060 STRPARM$(4)=CR$+LF$
5070 STRPARM$(5)=ESC$+"L"
5080 TYPPARM(2)=1
5090 STRPARM$(6)=""
5092 WRDPARM(1)=8
5093 WRDPARM(2)=0
5100 RETURN
5500 REM -------------------------- Tally -----------------------------
5505 HEAD$="Tally Printer"
5510 DESC$=""
5520 TYPPARM(1)=1
5530 STPARM$(1)=""
5550 STRPARM$(2)=""
5560 STRPARM$(3)=""
5570 STRPARM$(4)=CR$+LF$
5580 STRPARM$(5)=ESC$+"L"
5590 TYPPARM(2)=1
5600 STRPARM$(6)=CHR$(&H20)
5602 WRDPARM(1)=-8
5604 WRDPARM(2)=200
5610 RETURN
6000 REM -------------------------- C. Itoh ------------------------------
6010 HEAD$="C. Itoh Printer"
6020 TYPPARM(1)=1
6030 STRPARM$(1)=ESC$+"E"+ESC$+"T16"+CR$+LF$
6040 STRPARM$(2)=ESC$+"N"+ESC$+"A"
6050 STRPARM$(3)=""
6060 STRPARM$(4)=CR$+LF$
6070 STRPARM$(5)=ESC$+"S0"
6080 TYPPARM(2)=2
6090 STRPARM$(6)=""
6092 WRDPARM(1)=-8
6093 WRDPARM(2)=0
6100 RETURN
9000 REM --------------------- No Printer ----------------------------
9010 HEAD$="No Printer"
9020 DESC$=" - disable LCOPY"
9025 TYPPARM(1)=0
9030 RETURN
10000 REM routine to display the menu and let the user choose a printer
10010 SCREEN 0
10020 J=1
10030 CLS
10040 LOCATE 1,1
10048 PRINT "This program modifies GWBASIC so that the LCOPY statement will"
10049 PRINT "produce output for a selected printer."
10051 PRINT
10053 PRINT "Use the up and down arrow keys on the right side of the keyboard"
10054 PRINT "to choose a printer."
10055 PRINT "When the desired choice is highlit, press the RETURN key - "
10056 PRINT "the file ";GWBASEXE$;" on the default disk drive will be modified."
10060 PRINT
10062 PRINT "-----------------------------------------------------------------"
10070 MENULIN0=CSRLIN-1    'display menu
10080 FOR I=1 TO NUMPRTS
10090 IF I=J THEN
       COLOR 0,7
10100 PRINT MENUSTR$(I)
10110 COLOR 7,0
10115 NEXT I
10117 PRINT "-----------------------------------------------------------------"
10130 SAVLIN=CSRLIN+1   'remember where to put cursor for later messages
10135 J1=J
10140 ICHAR = 0
10150 WHILE ICHAR<>13   'loop to move up and down and look for carriage ret
10160 I$=INKEY$
10170 IF I$="" GOTO 10210
10180 ICHAR=ASC(I$)
10190 IF (ICHAR=30 OR ICHAR=5) AND J>1 THEN
       J1=J-1
    ELSE IF (ICHAR=31 OR ICHAR=24) AND J<NUMPRTS THEN
       J1=J+1
10200 IF J<>J1 THEN
       LOCATE MENULIN0+J,1:
       PRINT MENUSTR$(J):
       J=J1:
       LOCATE MENULIN0+J,1:
       COLOR 0,7:
       PRINT MENUSTR$(J):
       COLOR 7,0           'reprint old choice normally and new choice reversed
10210 WEND
10220 LOCATE SAVLIN,1      'put cursor back below menu
10300 RETURN
20000 REM main program
20010 VERS$="aa"
20020 CR$=CHR$(13): LF$=CHR$(10): ESC$=CHR$(27)
20030 GWBASEXE$="GWBASIC.EXE"
20040 NUMPRTS=0
20050 HEAD$="not null"
20060 WHILE HEAD$<>""
20070 HEAD$=""
20080 J=NUMPRTS+1
20090 GOSUB 1000
20100 IF HEAD$<>"" THEN
       NUMPRTS=J:
       MENUSTR$(NUMPRTS)=HEAD$+" "+DESC$
20110 WEND
20120 GOSUB 10000 'display menu and let user choose a printer
20130 HEAD$=""
20140 DESC$=""
20150 FOR I=1 TO 4
20160 TYPPARM(I)=0
20170 WRDPARM(I)=0
20180 NEXT I
20190 FOR I=1 TO 8
20200 STRPARM$(I)=""
20210 NEXT I
20220 GOSUB 1000 ' go to set up strings for the chosen printer
20230 IF HEAD$="ABORT" THEN GOTO 50000
30000 OPEN GWBASEXE$ AS #1
30010 FIELD #1, 2 AS WORD0$, 2 AS WORD1$, 2 AS WORD2$, 2 AS WORD3$, 2 AS WORD4$
30020 FIELD #1,10 AS ID$,
  1 AS TP1$,1 AS TP2$,1 AS TP3$,1 AS TP4$,
  2 AS WD1$,2 AS WD2$,2 AS WD3$,2 AS WD4$,
  1 AS ST$(1),1 AS ST$(2),1 AS ST$(3),1 AS ST$(4),
  1 AS ST$(5),1 AS ST$(6),1 AS ST$(7),1 AS ST$(8),
  66 AS STBUF$
30030 GET #1,1
30040 CREC=FIX((CVI(WORD4$)+31)/32)*4+1 'record number in which code seg starts
30050 GET #1,CREC
30060 IF ID$<>"gwcfgbufaa" THEN 
 PRINT "Format of file "; GWBASEXE$;" is not as expected.":
 PRINT "Expected: 'gwcfgbuf' version: '";VERS$;"'  ";"Found: '";MID$(ID$,1,8);
 "' version: '";MID$(ID$,9,2);"'":
 GOTO 50000
30070 LSET TP1$ = CHR$(TYPPARM(1))
30080 LSET TP2$ = CHR$(TYPPARM(2))
30090 LSET TP3$ = CHR$(TYPPARM(3))
30100 LSET TP4$ = CHR$(TYPPARM(4))
30110 LSET WD1$ = MKI$(WRDPARM(1))
30120 LSET WD2$ = MKI$(WRDPARM(2))
30130 LSET WD3$ = MKI$(WRDPARM(3))
30140 LSET WD4$ = MKI$(WRDPARM(4))
30150 ILEN=LEN(HEAD$)
30160 IST=ILEN+1
30170 STRBUF$=CHR$(ILEN)+HEAD$
30180 FOR I = 1 TO 9
30190 LSET ST$(I) = CHR$(IST)
30200 ILEN = LEN(STRPARM$(I))
30210 STRBUF$=STRBUF$+CHR$(ILEN)+STRPARM$(I)
30220 IST=IST+ILEN+1
30230 NEXT I
30240 LSET STBUF$=STRBUF$
30250 PUT #1,CREC
30260 PRINT GWBASEXE$;" modified"
30270 GOTO 50020
50000 COLOR 0,7
50010 PRINT "Program aborted. ";GWBASEXE$;" not modified.";
50020 COLOR 7,0
50030 PRINT
50040 PRINT SPC(79);" "
50050 PRINT SPC(79);" "
50052 PRINT "You must re-enter GWBASIC from MSDOS"
50053 PRINT "before the changes will take effect."
50054 PRINT "This program will return you to MSDOS."
50055 CLOSE
50060 REM  kill some time before exiting so user can read final message
50070 REM  before screen is cleared.
50080 FOR I=0 TO 10
50090 LOCATE 24,1
50100 COLOR 0,7
50120 FOR J=1 TO 400
50125 NEXT J
50130 PRINT 10-I;
50140 NEXT I
50200 SYSTEM
 TO 10
50090 LOCATE 24,1
50100 COLOR 0,7
50120 FOR J=1 TO 400
50125 NEXT J
50130 