cseg	segment
assume cs:cseg, ds:cseg
org	100h
start	proc	near
jmp	rdclk
start	endp

;-------------------------------------------------------------

address	dw	0effch

badmsg	db	10,13,'INVALID CLOCK DATA: ',
	db	'Clock+ Card absent, malfunction or not set',10,13,
	db	10,'System time and/or date have NOT been set.',10,13,'$'

endmsg	db	10,13,'Issue Clock+ Card: System time and date set.',10,13,'$'
;-------------------------------------------------------------


rdclk	proc	near

	mov es,cs:address

	mov al,es:[0dh]		;check Valid Ram and Time
	cmp al,10000000b
	jnz badtime

chuip:	mov al,es:[0ah]		;check if clock update in progress
	cmp al,10100000b
	jz chuip		;wait until clear

	mov dl,es:[07h]		;day
	mov dh,es:[08h]		;month
	xor ch,ch
	mov cl,es:[09h]		;year
	add cx,076ch

	mov ah,2bh
	int 21h			;set date

	cmp al,0ffh		;DOS returns date invalid
	jz badtime

	mov dl,0		;hundredths of secs to zero
	mov dh,es:[0]		;secs
	mov cl,es:[02h]		;mins
	mov ch,es:[04h]		;hours

	mov ah,2dh
	int 21h			;set time

	cmp al,0ffh		;DOS returns time invalid
	jz badtime		

	mov dx,offset endmsg
	mov ah,09h
	int 21h			;print endmsg

rdclk	endp

exit:	mov ah,0		;terminate
	int 21h

;--------------------------------------------------------

badtime:	mov dx,offset badmsg
		mov ah,09h
		int 21h
		jmp exit

;---------------------------------------------------------


cseg	ends
end	start

