NAME CAMREAD
VISION GROUP VIZSYS,VARIABLE
VARIABLE    SEGMENT PUBLIC 'VARI'
TLIM        DB 0
BLIM        DB 255
VARIABLE    ENDS

VIZSYS      SEGMENT PUBLIC 'VIZ'
            ASSUME CS:VIZSYS,DS:VISION,SS:VISION
            EXTRN FILT:WORD,IMAGE:ABS,VIA:ABS,THRESH:BYTE,BLIMX:WORD,BLIMY:WORD
            EXTRN XL:WORD,YL:WORD,NLFLG:BYTE,CONT:BYTE             
            PUBLIC CAMREAD 
CAMREAD:    CMP FILT,3
            JNE TEST2
            JMP ENHANCE 
TEST2:      CMP FILT,2
            JNE INPUT
            JMP ENHANCE
INPUT:      CLI              ;Disable interupts (under protest)
            MOV BP,FILT      ;Flag for recursive filtering
            MOV AX,VIA       ;Input data from vision unit
            MOV DS,AX        ;Set up via
            MOV BH,255       ;Clm count
            MOV DI,80H       ;Set up base for VIA 
            MOV AL,0
            MOV [DI+3],AL    ;Set data direction register A  
            MOV DX,0
            MOV SI,0         ;Image pointer
            CALL SETOUT      ;Set up register B
            CALL MASSET      ;Output master reset pulse
            CALL FRAMSET     ;Output fram reset pulse 
            MOV CL,0
TOPLINS:    MOV AL,[DI]      ;Wait for first line
            AND AL,4
            JE TOPLINS
            CALL FRAMSET     ;Output frame reset pulse
            CALL FRAMSET
            CALL FRAMSET
            CALL FRAMSET
            INC DX
            INC SI
            MOV CH,20
PIXH1:      MOV AL,[DI]       ;Miss first twenty lines
            AND AL,1          ;Wait for strobe to go hi
            JNE PIXH1
PIXL1:      MOV AL,[DI]       ;Wait for strobe to go low again
            AND AL,1
            JE PIXL1
            DEC CH
            JNE PIXH1         ;Loop round until first twenty lines skipped
            MOV CH,255
PIXH2:  
PIXH21:     MOV AL,[DI]       ;Wait for strobe to go hi
            AND AL,1
            JNE PIXH21
RIX:	    PUSH CX
            MOV CX,IMAGE 
PIXL2:      MOV AL,[DI]       ;wait for strobe to go low again
            AND AL,1
            JE PIXL2
            MOV BL,1
DELAY:      DEC BL
            JNE DELAY
            NOP
	    MOV BL,[DI+1]
            PUSH DS
 
            MOV DS,CX
            CMP BP,0         ;Test recursive filter flag
            JE REIN
            MOV AL,[SI]      ;Recursive filtering routine
            ADD BL,AL
            RCR BL,1
REIN:       CMP BL,1         ;TEST FOR EOL
            JNE NOT1
            MOV BL,0
NOT1:       MOV [SI],BL
            POP DS
            ADD SI,256       ;Increment data pointer
            POP CX
            DEC CH           ;Decrement line count
            JNE RIX          ;If not zero get next element in line
            DEC BH           ;Decrement column count 
            JNE TOPLINS      ;Test to see if wholre image read in
            JMP ENDAT        ;If it is jump to ENDAT routine
SETOUT:     MOV AL,10        ;Set data direction output A up 
            MOV [DI+2],AL
            MOV AL,0
            MOV [DI],AL     
            RET
MASSET:     MOV CL,2          ;Output master reset pulse
            MOV [DI],CL
            MOV CL,10    
            MOV [DI],CL
            MOV BH,255
            RET                  
FRAMSET:    MOV CL,10          ;Output frame reset pulse
CYC:        MOV AL,8
            MOV [DI],AL
            DEC CL
            JNE CYC
            MOV AL,10
            MOV [DI],AL
            MOV SI,DX
            RET
ENDAT:      MOV SI,0           ;Steps throught the image data putting
            MOV AX,IMAGE       ;in end of line pulses every 256 elements
            MOV DS,AX          ;Sets up data pointer
            MOV CL,255         ;Set up count
LINE:       MOV AL,01
            MOV [SI],AL        ;Write 01 (eol) to element pointed to
            MOV AL,0
            MOV [SI+1],AL
            ADD SI,256         ;Increment pointer by 256
            DEC CL
            JNE LINE           ;Repeat until count is zero
            STI
            MOV AX,VARIABLE    ;Set DS to look at VARIABLE segment
            MOV DS,AX
            STI                ;Renable interupts
            RET            
ENHANCE:
            PUSH DS            ;Set pointer to image
            MOV AX,IMAGE
            MOV DS,AX
            MOV DX,0
            MOV CX,0
            PUSH CX
            MOV DS,AX          ;Set up counters
            MOV DI,2
            MOV BP,6           ;X
            MOV SI,400	       ;Y
SLOOP:      PUSH DS
            MOV BX,VARIABLE
            MOV DS,BX	       ;Check within window
            CMP BP,XL
            JB FAIL
            CMP SI,YL
            JB FAIL
            CMP SI,BLIMY
            JA FAIL
            CMP BP,BLIMX
            JA FAIL	       ;If not loop to next point
            POP DS
            JMP PASS
FAIL:       POP DS
            JMP MISS
PASS:       MOV BL,[DI]
            CMP BL,1	       ;Check for line pulse
            JE MISS
            POP CX
            INC CX
            PUSH CX        
            PUSH DS
            MOV CX,VARIABLE    ;Test to see whether data modify required
            MOV DS,CX
            CMP FILT,3
            JNE SK3
            MOV CL,1
SK3:        POP DS
            CMP CL,1
            JE NOCHANGE	       ;Adjust light levels
DWN1:       CMP BL,160
            JBE DWN
            SUB BL,80 
DWN:        CMP BL,80
            JA ADJUST
            PUSH AX
            MOV AL,3
            MUL BL
            MOV BL,AL
            POP AX
NOCHANGE:                      
ADJUST:
STORE:      MOV BH,0	      ;Keep running total
            CLC
            ADC AX,BX	      ;in AX and DX
            ADC DX,0
            MOV [DI],BL
MISS:       INC DI	      ;Test for end of data
            CMP DI,0FFFEH
            JA FINISH
            INC BP
            INC BP
            INC BP
            CMP BP,768
            JB SCON
            MOV BP,0
            DEC SI
            DEC SI
SCON:       JMP SLOOP
FINISH:     POP CX	     ;Calculate average for threshold
            DIV CX
SK1:        POP DS
            MOV THRESH,AL
            MOV AL,10
            MOV CONT,AL	     ;Set contrast
            RET
VIZSYS      ENDS
            END  CAMREAD       
            
