NAME MANIP
COMMENT * SCREEN MANIPULATION PROGRAM TO
          BE LINKED WITH VISION
        *
VISION      GROUP VIZSYS,VARIABLE
VARIABLE    SEGMENT PUBLIC 'VARI'
CHARTABLE   DB      0,0,0,0,62,62,2,32,130,32,130,32,130,32,128,0,240,7
            DB      130,32,130,32,130,32,2,32,62,62,0,0,0,0


MOVON       DB      0
WINDON      DB      0
YCEN        DW      ?
XCEN        DW      ?
EIGHT       DW      8
SIXTEEN	    DW      16
ULFLG       DB      0
OVFLG       DB      0
XPOS        DB      25
YPOS        DB      12
PNTRSTORE   DW      0
VARIABLE    ENDS           
		          
VIZSYS      SEGMENT PUBLIC 'VIZ'
            ASSUME CS:VIZSYS,DS:VISION,SS:VISION
            PUBLIC MANIPULATE,MENOUT,WINPLOT,CURMOVE,HLIN,VLIN,MENSET
            PUBLIC MESS1OUT,MESS2OUT
            EXTRN LINETYPE:BYTE,HIREZ:ABS,CHARPUT:NEAR,KEYWAIT:NEAR,CORE:NEAR
            EXTRN BLIMY:WORD,BLIMX:WORD,XL:WORD,YL:WORD,PLOT:NEAR,MENRES:ABS 
            EXTRN CLEAR:NEAR,ZOOM:NEAR,FGREY:NEAR,MOVE:NEAR,RESET:NEAR
            EXTRN FUNC5:ABS,MESS8:ABS,MESS0:ABS,WIN:BYTE,MESS25:ABS

MANIPULATE:            
            MOV AL,0
            MOV WIN,AL            
            MOV DI,0		   
            MOV SI,OFFSET CHARTABLE
            MOV CX,16 
MCYC:       MOV BX,[SI]
            PUSH DS
            MOV AX,HIREZ
            MOV DS,AX
            MOV [DI],BX
            POP DS
            INC DI
            INC DI
            INC SI
            INC SI
            LOOPNZ MCYC
            MOV AL,0            ;Set window flag closed
            MOV WINDON,AL
            MOV MOVON,AL        ;Set move flag to zero
            CALL CURMOVE

INITM:      MOV DI,OFFSET FUNC5
            CALL MENOUT 
         

KEYLOOP:
MONKEY:     CALL KEYWAIT
            CMP AL,31H
            JNE MKEY1
            CALL CURMOVE
            CALL DOWN
            CALL LEFT
            CALL CURMOVE
MKEY1:      CMP AL,32H
            JNE MKEY2
            CALL CURMOVE
            CALL DOWN
            CALL CURMOVE
MKEY2:      CMP AL,33H
            JNE MKEY3
            CALL CURMOVE
            CALL DOWN
            CALL RIGHT
            CALL CURMOVE
MKEY3:      CMP AL,34H     ;4
            JNE MKEY4
            CALL CURMOVE
            CALL LEFT
            CALL CURMOVE
MKEY4:      CMP AL,36H    ;6
            JNE MKEY5
            CALL CURMOVE
            CALL RIGHT
            CALL CURMOVE
MKEY5:      CMP AL,37H    ;7
            JNE MKEY6
            CALL CURMOVE
            CALL UP
            CALL LEFT
            CALL CURMOVE
MKEY6:      CMP AL,38H     ;8
            JNE MKEY7
            CALL CURMOVE
            CALL UP
            CALL CURMOVE
MKEY7:      CMP AL,39H      ;9
            JNE MKEY8
            CALL CURMOVE
            CALL UP
            CALL RIGHT
            CALL CURMOVE

MKEY8:      CMP AL,27      ;EXIT
            JNE MKEY9
            CALL CURMOVE
            MOV AX,0
            MOV YL,AX
            MOV XL,AX
            MOV AX,800
            MOV BLIMX,AX
            MOV AX,400
            MOV BLIMY,AX
            JMP CORE

MKEY9:      CMP AL,241     ;WINDOW
            JNE MKEY10
            MOV DI,OFFSET MESS8 
            CALL MESS1OUT
            MOV DI,OFFSET MESS0
            CALL MESS2OUT 
            CALL WINDOW
            MOV AL,1
            MOV WIN,AL 
            JMP INITM 

MKEY10:     CMP AL,242     ;MOVE
            JNE MKEY11
            MOV DI,OFFSET MESS25 
            CALL MESS1OUT
            MOV DI,OFFSET MENRES
            CALL MESS2OUT
            CALL MOVE
            MOV AL,0 
            MOV WIN,AL
            JMP INITM

MKEY11:     CMP AL,244    ;ZOOM
            JNE MKEY12
            CALL CURMOVE
            CALL RESET
            CALL ZOOM
            CALL CURMOVE
            MOV AL,0
            MOV WIN,AL
            JMP INITM


MKEY12:     CMP AL,243     ;Reset screen pointers
            JNE MKEY14
            CALL CURMOVE
            CALL RESET
            CALL CURMOVE
            JMP INITM

MKEY14:	    CMP AL,246
            JNE MKEY15
            CALL CURMOVE
            CALL RESET
            CALL CLEAR
            MOV AX,0
            MOV XL,AX
            MOV YL,AX
            MOV AX,768
            MOV BLIMX,AX
            MOV AX,400
            MOV BLIMY,AX
            CALL FGREY
            CALL CURMOVE
            JMP INITM

MKEY15:     CMP AL,245
            JNE MKEY16
            CALL INVERT
            JMP INITM


MKEY16:     JMP MONKEY                                                  


MENOUT:     MOV BH,24        ;Outputs menu pointed to by DI
            MOV BL,0
FLOOP1:     MOV CX,[DI]
            CMP CX,2
            JE FLOOP2
            ADD CX,32768
FLOOP2:     CALL CHARPUT
            INC DI
            INC DI
            INC BL
            CMP BL,50
            JNE FLOOP1
            RET


MESS1OUT:  MOV BH,24       ;Output first section of message
           MOV BL,0 
MESSLOOP1: MOV CX,[DI]            
           CALL CHARPUT 
           INC DI
           INC DI
           INC BL
           CMP BL,20
           JNE MESSLOOP1
           RET 


MESS2OUT:  MOV BH,24       ;Output any additional message  
           MOV BL,20
MESSLOOP2: MOV CX,[DI]           
           CALL CHARPUT
           INC DI
           INC DI
           INC BL
           CMP BL,49 
           JNE MESSLOOP2
           RET

         
MENSET:     MOV BH,24       ;Routine to set up menu blanking   
            MOV BL,0
MENSLOOP:   CALL CHARPUT     
            MOV [DI],DX 
            INC DI
            INC DI
            INC BL 
            CMP BL,49
            JNE MENSLOOP
            RET



UP:         DEC YPOS        ;Move cursor pointer up
            CMP YPOS,0
            JA  CYCUP
            INC YPOS
CYCUP:      RET
DOWN:       INC YPOS        ;Move cursor pointer down
            CMP YPOS,24
            JB CYCDOWN
            DEC YPOS
CYCDOWN:    RET
LEFT:       DEC XPOS        ;Move cursor pointer left
            CMP XPOS,0
            JA CYCLEFT
            INC XPOS
CYCLEFT:    RET
RIGHT:      INC XPOS        ;Move cursor pointer right
            CMP XPOS,50
            JB CYCRIGHT
            DEC XPOS     
CYCRIGHT:   RET
CURMOVE:    MOV CX,PNTRSTORE ;Moves cursor to new position
            MOV BL,XPOS
            MOV BH,YPOS
            CALL CHARPUT
            MOV PNTRSTORE,DX
            RET
               
WINDOW:     MOV AL,0
            MOV OVFLG,AL
            MOV ULFLG,AL
            CALL CURMOVE
            MOV AX,16
            MOV BL,XPOS
            MUL BL
            MOV XL,AX
            ADD AX,SIXTEEN
            MOV BLIMX,AX
            SUB AX,EIGHT
            MOV XCEN,AX
            MOV AX,16
            MOV BL,25
            SUB BL,YPOS
            MUL BL
            MOV BLIMY,AX
            SUB AX,EIGHT
            MOV YCEN,AX
            SUB AX,EIGHT
            MOV YL,AX
            CALL WINPLOT
WINKEY:     CALL KEYWAIT
            CMP AL,13
            JE WEXIT
            CMP AL,2BH
            JNE WSKIP
            CALL WINPLOT
            CALL GROW
            CALL WINPLOT
            JMP WINKEY
WSKIP:      CMP AL,2DH
            JNE WSKIP1
            CALL WINPLOT
            CALL SHRINK
            CALL WINPLOT
WSKIP1:     JMP WINKEY
WEXIT:      CALL CURMOVE
            RET
GROW:       CMP OVFLG,0
            JNE GEXIT
            MOV AL,0
            MOV ULFLG,AL
            MOV AX,BLIMX
            ADD AX,SIXTEEN
            CMP AX,768
            JA FLAGSET
            MOV BLIMX,AX
            MOV AX,XL
            SUB AX,SIXTEEN
            CMP AX,16   
            JB FLAGSET
            MOV XL,AX
            MOV AX,YL
            SUB AX,EIGHT
            CMP AX,16
            JB FLAGSET
            MOV YL,AX
            MOV AX,BLIMY
            ADD AX,EIGHT
            CMP AX,361
            JA FLAGSET
            MOV BLIMY,AX
GEXIT:      RET
FLAGSET:     MOV AL,01
            MOV OVFLG,01
            RET
SHRINK:	    CMP ULFLG,0
            JNE GEXIT
            MOV AL,0
            MOV OVFLG,AL
            MOV AX,BLIMX
            SUB AX,SIXTEEN
            CMP AX,XCEN
            JBE FLAGSET1
            MOV BLIMX,AX
            MOV AX,XL   
            ADD AX,SIXTEEN
            CMP AX,XCEN
            JAE FLAGSET1
            MOV XL,AX
            MOV AX,YL
            ADD AX,EIGHT
            CMP AX,YCEN
            JAE FLAGSET1
            MOV YL,AX
            MOV AX,BLIMY
            SUB AX,EIGHT
            CMP AX,YCEN
            JBE FLAGSET1
            MOV BLIMY,AX
            RET
FLAGSET1:   MOV AL,01
            MOV ULFLG,AL
            RET
WINPLOT:    MOV AL,1
            MOV LINETYPE,AL
            MOV BX,BLIMX
            MOV DX,YL
            MOV CX,XL
            CALL HLIN
            MOV DX,BLIMY
            MOV BX,BLIMX
            MOV CX,XL
            CALL HLIN
            MOV BX,BLIMY
            MOV CX,YL
            MOV BP,XL
            CALL VLIN
            MOV BP,BLIMX
            MOV BX,BLIMY
            MOV CX,YL
            CALL VLIN
            MOV AL,0
            MOV LINETYPE,AL
            RET
HLIN:       INC BX
            MOV BP,BX
LINCYC:     CALL PLOT
            DEC BP
            CMP BP,CX
            JAE LINCYC
            RET
VLIN:       INC BX
            MOV DX,BX
VLINCYC:    CALL PLOT
            DEC DX
            CMP DX,CX
            JAE VLINCYC
            RET

INVERT:     PUSH DS
            MOV AX,HIREZ
            MOV BL,0
            MOV DS,AX
            MOV DI,20000
ILOOP1:     MOV AL,[DI]
            XOR AL,0FFH
            MOV [DI],AL
            INC DI
            CMP DI,60000
            JNE ILOOP1
            POP DS
            RET
VIZSYS      ENDS
            END MANIPULATE  